/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.compiler;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.n4js.ide.server.N4JSWorkspaceManager;
import org.eclipse.n4js.projectModel.locations.FileURI;

@Singleton
public class IssueSerializer {
    @Inject
    N4JSWorkspaceManager workspaceManager;

    public String diagnostics(Diagnostic diagnostic) {
        String s = "   ";
        s = String.valueOf(s) + "[" + diagnostic.getSeverity() + "]";
        s = String.valueOf(s) + " (" + diagnostic.getRange().getStart().getLine();
        s = String.valueOf(s) + ":" + diagnostic.getRange().getStart().getCharacter();
        s = String.valueOf(s) + "): " + diagnostic.getMessage();
        return s;
    }

    public String uri(String uri) {
        URI baseDir = this.workspaceManager.getBaseDir();
        FileURI fileUri = new FileURI(URI.createURI((String)uri));
        URI relativeUri = fileUri.toURI().deresolve(baseDir);
        String relativeFileString = relativeUri.toFileString();
        return relativeFileString;
    }
}

