/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.preferences;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceModel;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStoreImpl;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.osgi.service.prefs.BackingStoreException;

@Singleton
public class HlcExternalLibraryPreferenceStore
extends ExternalLibraryPreferenceStoreImpl {
    private static final Logger LOGGER = Logger.getLogger(HlcExternalLibraryPreferenceStore.class);
    private static final String QUALIFIER = ExternalLibraryPreferenceStore.class.getName();
    private static final String CONFIGURATION_KEY = String.valueOf(QUALIFIER) + ".configuration";
    @Inject
    private StatusHelper statusHelper;

    @Override
    protected IStatus doSave(ExternalLibraryPreferenceModel modelToSave) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(QUALIFIER);
        node.put(CONFIGURATION_KEY, modelToSave.toJsonString());
        try {
            node.flush();
            return Status.OK_STATUS;
        }
        catch (BackingStoreException e) {
            String message = "Unexpected error when trying to persist external library preferences.";
            LOGGER.error((Object)"Unexpected error when trying to persist external library preferences.", (Throwable)e);
            return this.statusHelper.createError("Unexpected error when trying to persist external library preferences.", e);
        }
    }

    @Override
    protected ExternalLibraryPreferenceModel doLoad() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(QUALIFIER);
        String jsonString = node.get(CONFIGURATION_KEY, "");
        if (StringExtensions.isNullOrEmpty((String)jsonString)) {
            return ExternalLibraryPreferenceModel.createDefaultForN4Product();
        }
        return ExternalLibraryPreferenceModel.createFromJson(jsonString);
    }

    @Override
    protected ExternalLibraryPreferenceModel getDefaults() {
        return ExternalLibraryPreferenceModel.createDefaultForN4Product();
    }
}

