/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.runner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xpect.XjmMethod;
import org.eclipse.xpect.XjmTestMethod;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.runner.DescriptionFactory;
import org.eclipse.xpect.runner.IXpectURIProvider;
import org.eclipse.xpect.runner.TestExecutor;
import org.eclipse.xpect.runner.TestRunner;
import org.eclipse.xpect.runner.ValidatingSetup;
import org.eclipse.xpect.runner.XpectTestRunner;
import org.eclipse.xpect.setup.ThisRootTestClass;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.state.StateContainer;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class XpectFileRunner
extends Runner
implements Filterable,
Sortable {
    private List<Runner> children;
    private Description description;
    private final StateContainer state;
    private final XpectFile xpectFile;

    public XpectFileRunner(StateContainer state, XpectFile file) {
        this.xpectFile = file;
        this.state = state;
    }

    @Creates
    public XpectFileRunner create() {
        return this;
    }

    protected List<Runner> createChildren() {
        ArrayList children = Lists.newArrayList();
        if (this.xpectFile != null) {
            Runner testRunner;
            XpectJavaModel xjm = this.xpectFile.getJavaModel();
            for (XjmMethod method : xjm.getMethods().values()) {
                if (!(method instanceof XjmTestMethod) || (testRunner = this.createTestRunner((XjmTestMethod)method)) == null) continue;
                children.add(testRunner);
            }
            for (XpectInvocation inv : this.xpectFile.getInvocations()) {
                testRunner = this.createTestRunner(inv);
                if (testRunner == null) continue;
                children.add(testRunner);
            }
        }
        return children;
    }

    protected Description createDescription() {
        Description result = DescriptionFactory.createFileDescription(this.getJavaTestClass(), this.getURIProvider(), this.getUri());
        for (Runner child : this.getChildren()) {
            result.addChild(child.getDescription());
        }
        return result;
    }

    protected Runner createTestRunner(XjmTestMethod method) {
        StateContainer childState = TestExecutor.createState(this.state, TestExecutor.createTestConfiguration(method));
        return childState.get(TestRunner.class, new Object[0]).get();
    }

    protected Runner createTestRunner(XpectInvocation invocation) {
        StateContainer childState = TestExecutor.createState(this.state, TestExecutor.createXpectConfiguration(invocation));
        return childState.get(XpectTestRunner.class, new Object[0]).get();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        ArrayList filtered = Lists.newArrayList();
        for (Runner child : this.getChildren()) {
            if (!filter.shouldRun(child.getDescription())) continue;
            filtered.add(child);
        }
        this.description = null;
        this.children = filtered;
    }

    protected List<Runner> getChildren() {
        if (this.children == null) {
            this.children = this.createChildren();
        }
        return this.children;
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = this.createDescription();
        }
        return this.description;
    }

    public Class<?> getJavaTestClass() {
        return this.state.get(Class.class, ThisRootTestClass.class).get();
    }

    public IXpectURIProvider getURIProvider() {
        return this.state.get(IXpectURIProvider.class, new Object[0]).get();
    }

    public StateContainer getState() {
        return this.state;
    }

    public URI getUri() {
        return this.xpectFile.eResource().getURI();
    }

    public XpectFile getXpectFile() {
        return this.xpectFile;
    }

    public void run(RunNotifier notifier) {
        try {
            try {
                this.state.get(ValidatingSetup.class, new Object[0]).get().validate();
                if (this.getChildren().isEmpty()) {
                    notifier.fireTestStarted(this.getDescription());
                    notifier.fireTestFinished(this.getDescription());
                } else {
                    for (Runner child : this.getChildren()) {
                        try {
                            child.run(notifier);
                        }
                        catch (Throwable t) {
                            notifier.fireTestFailure(new Failure(this.getDescription(), t));
                        }
                    }
                }
            }
            catch (Throwable t) {
                notifier.fireTestFailure(new Failure(this.getDescription(), t));
                try {
                    this.state.invalidate();
                }
                catch (Throwable t2) {
                    notifier.fireTestFailure(new Failure(this.getDescription(), t2));
                }
            }
        }
        finally {
            try {
                this.state.invalidate();
            }
            catch (Throwable t) {
                notifier.fireTestFailure(new Failure(this.getDescription(), t));
            }
        }
    }

    public void sort(final Sorter sorter) {
        this.description = null;
        Collections.sort(this.getChildren(), new Comparator<Runner>(){

            @Override
            public int compare(Runner o1, Runner o2) {
                return sorter.compare(o1.getDescription(), o2.getDescription());
            }
        });
    }
}

