/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.server.N4JSBuildManager;
import org.eclipse.n4js.ide.server.ReflectionUtils;
import org.eclipse.n4js.ide.xtext.server.XBuildManager;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class N4JSWorkspaceManager
extends XWorkspaceManager {
    private Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor;
    private N4JSBuildManager accessibleBuildManager;

    @Override
    public void initialize(URI pBaseDir, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> pIssueAcceptor, CancelIndicator cancelIndicator) {
        super.initialize(pBaseDir, pIssueAcceptor, cancelIndicator);
        this.issueAcceptor = pIssueAcceptor;
    }

    @Override
    @Inject
    public void setBuildManager(XBuildManager buildManager) {
        super.setBuildManager(buildManager);
        this.accessibleBuildManager = (N4JSBuildManager)buildManager;
    }

    N4JSBuildManager getBuildManager() {
        return this.accessibleBuildManager;
    }

    @Override
    public XBuildManager.XBuildable didClose(final URI uri) {
        final IProjectConfig projectConfig = this.getWorkspaceConfig().findProjectContaining(uri);
        final XBuildManager.XBuildable closedBuildable = super.didClose(uri);
        XBuildManager.XBuildable cleaningBuildable = new XBuildManager.XBuildable(){

            @Override
            public List<IResourceDescription.Delta> build(CancelIndicator cancelIndicator) {
                List<IResourceDescription.Delta> build = closedBuildable.build(cancelIndicator);
                ISourceFolder sourceFolder = projectConfig.findSourceFolderContaining(uri);
                if (sourceFolder == null) {
                    N4JSWorkspaceManager.this.clearIssues(uri);
                }
                return build;
            }
        };
        return cleaningBuildable;
    }

    public URI getBaseDir() {
        return (URI)ReflectionUtils.getFieldValue(XWorkspaceManager.class, this, "baseDir");
    }

    public void clearIssues(URI uri) {
        this.issueAcceptor.apply((Object)uri, Collections.emptyList());
    }

    @Override
    public IWorkspaceConfig getWorkspaceConfig() {
        return super.getWorkspaceConfig();
    }
}

