/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.RunningLengthWord32;

public final class BufferedRunningLengthWord32
implements Cloneable {
    public int literalWordOffset = 0;
    protected int NumberOfLiteralWords;
    public boolean RunningBit;
    public int RunningLength;

    public BufferedRunningLengthWord32(int a) {
        this.NumberOfLiteralWords = a >>> 17;
        this.RunningBit = (a & 1) != 0;
        this.RunningLength = a >>> 1 & 0xFFFF;
    }

    public BufferedRunningLengthWord32(RunningLengthWord32 rlw) {
        this(rlw.buffer.getWord(rlw.position));
    }

    public void discardFirstWords(int x) {
        if (this.RunningLength >= x) {
            this.RunningLength -= x;
            return;
        }
        this.RunningLength = 0;
        this.literalWordOffset += (x -= this.RunningLength);
        this.NumberOfLiteralWords -= x;
    }

    public int getNumberOfLiteralWords() {
        return this.NumberOfLiteralWords;
    }

    public boolean getRunningBit() {
        return this.RunningBit;
    }

    public int getRunningLength() {
        return this.RunningLength;
    }

    public void reset(int a) {
        this.NumberOfLiteralWords = a >>> 17;
        this.RunningBit = (a & 1) != 0;
        this.RunningLength = a >>> 1 & 0xFFFF;
        this.literalWordOffset = 0;
    }

    public void reset(RunningLengthWord32 rlw) {
        this.reset(rlw.buffer.getWord(rlw.position));
    }

    public void setNumberOfLiteralWords(int number) {
        this.NumberOfLiteralWords = number;
    }

    public void setRunningBit(boolean b) {
        this.RunningBit = b;
    }

    public void setRunningLength(int number) {
        this.RunningLength = number;
    }

    public int size() {
        return this.RunningLength + this.NumberOfLiteralWords;
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }

    public BufferedRunningLengthWord32 clone() throws CloneNotSupportedException {
        BufferedRunningLengthWord32 answer = (BufferedRunningLengthWord32)super.clone();
        answer.literalWordOffset = this.literalWordOffset;
        answer.NumberOfLiteralWords = this.NumberOfLiteralWords;
        answer.RunningBit = this.RunningBit;
        answer.RunningLength = this.RunningLength;
        return answer;
    }
}

