/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.model;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.factories.CFEMapper;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Script;

public class FlowGraph {
    private final Script script;
    private final Set<ControlFlowElement> cfContainers;
    private final Map<ControlFlowElement, ComplexNode> cnMap;

    public FlowGraph(Script script, Set<ControlFlowElement> cfContainers, Map<ControlFlowElement, ComplexNode> cnMap) {
        this.script = script;
        this.cfContainers = cfContainers;
        this.cnMap = cnMap;
    }

    public Script getScript() {
        return this.script;
    }

    public String getScriptName() {
        return this.script.eResource().getURI().toString();
    }

    public Map<ControlFlowElement, ComplexNode> getMap() {
        return this.cnMap;
    }

    public ComplexNode getComplexNode(ControlFlowElement cfe) {
        if (!this.cnMap.containsKey(cfe = CFEMapper.map(cfe))) {
            return null;
        }
        return this.cnMap.get(cfe);
    }

    public ControlFlowElement getContainer(ControlFlowElement cfe) {
        ComplexNode cn = this.getComplexNode(cfe);
        return cn.getControlFlowContainer();
    }

    public Collection<ControlFlowElement> getAllContainers() {
        LinkedList<ControlFlowElement> containerList = new LinkedList<ControlFlowElement>();
        for (ControlFlowElement cfe : this.cfContainers) {
            containerList.add(0, cfe);
        }
        return containerList;
    }
}

