/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.ui.internal.contentassist.CSSCACandidate;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistContext;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGenerator;
import org.eclipse.wst.css.ui.internal.image.CSSImageType;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocumentFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class CSSProposalGeneratorForHTMLTag
extends CSSProposalGenerator {
    private static String[] fHTMLTags = null;

    CSSProposalGeneratorForHTMLTag(CSSContentAssistContext context) {
        super(context);
        if (fHTMLTags == null) {
            fHTMLTags = CSSProposalGeneratorForHTMLTag.setupHTMLTags();
        }
    }

    @Override
    protected Iterator getCandidates() {
        DocumentTypeAdapter adapter;
        Node domNode;
        boolean bLowerCase;
        ArrayList<CSSCACandidate> candidates = new ArrayList<CSSCACandidate>();
        if (this.checkLeadingColon()) {
            return candidates.iterator();
        }
        boolean bl = bLowerCase = CSSCorePlugin.getDefault().getPluginPreferences().getInt("selectorCase") == 1;
        if (this.fContext.getModel().getStyleSheetType() == "embeddedCSS" && (domNode = this.fContext.getModel().getOwnerDOMNode()) != null && !(domNode instanceof Document) && (domNode = domNode.getOwnerDocument()) instanceof IDOMDocument && (adapter = (DocumentTypeAdapter)((IDOMDocument)domNode).getAdapterFor(DocumentTypeAdapter.class)) != null) {
            bLowerCase = adapter.getTagNameCase() == 2;
        }
        int length = fHTMLTags.length;
        int i = 0;
        while (i < length) {
            String tagText = fHTMLTags[i];
            if (bLowerCase) {
                tagText = tagText.toLowerCase();
            }
            if (this.isMatch(tagText)) {
                int cursorPos = 0;
                StringBuffer buf = new StringBuffer();
                buf.append(tagText);
                cursorPos += tagText.length();
                boolean inRule = this.fContext.getTargetNode() instanceof ICSSStyleRule;
                if (!inRule || this.fContext.getTextToReplace().length() == 0) {
                    buf.append(" ");
                    ++cursorPos;
                }
                if (!inRule) {
                    CSSProposalGenerator.StringAndOffset sao = this.generateBraces();
                    buf.append(sao.fString);
                    cursorPos += sao.fOffset;
                }
                CSSCACandidate item = new CSSCACandidate();
                item.setReplacementString(buf.toString());
                item.setCursorPosition(cursorPos);
                item.setDisplayString(tagText);
                item.setImageType(CSSImageType.SELECTOR_TAG);
                candidates.add(item);
            }
            ++i;
        }
        return candidates.iterator();
    }

    private static String[] setupHTMLTags() {
        CMDocument cmdoc = HTMLCMDocumentFactory.getCMDocument((String)"HTML");
        CMNamedNodeMap elements = cmdoc.getElements();
        Vector<String> names = new Vector<String>();
        int nElements = elements.getLength();
        int i = 0;
        while (i < nElements) {
            CMElementDeclaration edec = (CMElementDeclaration)elements.item(i);
            if (CSSProposalGeneratorForHTMLTag.isAttrDefined(edec, "style")) {
                names.add(edec.getElementName());
            }
            ++i;
        }
        Collections.sort(names);
        String[] tags = new String[names.size()];
        Iterator iNames = names.iterator();
        int i2 = 0;
        while (iNames.hasNext()) {
            tags[i2] = (String)iNames.next();
            ++i2;
        }
        return tags;
    }

    private static boolean isAttrDefined(CMElementDeclaration edec, String attrName) {
        if (edec == null) {
            return false;
        }
        CMNamedNodeMap attrs = edec.getAttributes();
        if (attrs == null) {
            return false;
        }
        int i = 0;
        while (i < attrs.getLength()) {
            CMAttributeDeclaration attr = (CMAttributeDeclaration)attrs.item(i);
            if (attr != null && attr.getAttrName().equalsIgnoreCase(attrName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

