/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.ide.xtext.server.build.XIncrementalBuilder;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ide.server.TopologicalSorter;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class XBuildManager {
    public static final String CYCLIC_PROJECT_DEPENDENCIES = String.valueOf(XBuildManager.class.getName()) + ".cyclicProjectDependencies";
    private XWorkspaceManager workspaceManager;
    @Inject
    private Provider<TopologicalSorter> sorterProvider;
    private final LinkedHashSet<URI> dirtyFiles = new LinkedHashSet();
    private final LinkedHashSet<URI> deletedFiles = new LinkedHashSet();
    private List<IResourceDescription.Delta> unreportedDeltas = new ArrayList<IResourceDescription.Delta>();

    public XBuildable submit(List<URI> dirtyFiles, List<URI> deletedFiles) {
        this.queue(this.dirtyFiles, deletedFiles, dirtyFiles);
        this.queue(this.deletedFiles, dirtyFiles, deletedFiles);
        return this::internalBuild;
    }

    @Deprecated
    public List<IResourceDescription.Delta> doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, CancelIndicator cancelIndicator) {
        return this.submit(dirtyFiles, deletedFiles).build(cancelIndicator);
    }

    protected void queue(Set<URI> files, Collection<URI> toRemove, Collection<URI> toAdd) {
        files.removeAll(toRemove);
        files.addAll(toAdd);
    }

    public List<IResourceDescription.Delta> doInitialBuild(List<ProjectDescription> projects, CancelIndicator indicator) {
        List<ProjectDescription> sortedDescriptions = this.sortByDependencies(projects);
        ArrayList<IResourceDescription.Delta> result = new ArrayList<IResourceDescription.Delta>();
        for (ProjectDescription description : sortedDescriptions) {
            XIncrementalBuilder.XResult partialresult = this.workspaceManager.getProjectManager(description.getName()).doInitialBuild(indicator);
            result.addAll(partialresult.getAffectedResources());
        }
        return result;
    }

    protected List<IResourceDescription.Delta> internalBuild(CancelIndicator cancelIndicator) {
        ArrayList<URI> allDirty = new ArrayList<URI>(this.dirtyFiles);
        HashMultimap project2dirty = HashMultimap.create();
        for (URI dirty : allDirty) {
            project2dirty.put((Object)this.workspaceManager.getProjectManager(dirty).getProjectDescription(), (Object)dirty);
        }
        HashMultimap project2deleted = HashMultimap.create();
        for (URI deleted : this.deletedFiles) {
            ProjectDescription projectManager = this.workspaceManager.getProjectManager(deleted).getProjectDescription();
            project2deleted.put((Object)projectManager, (Object)deleted);
        }
        List<ProjectDescription> sortedDescriptions = this.sortByDependencies((Iterable<ProjectDescription>)Sets.union((Set)project2dirty.keySet(), (Set)project2deleted.keySet()));
        for (ProjectDescription it : sortedDescriptions) {
            XProjectManager projectManager = this.workspaceManager.getProjectManager(it.getName());
            ArrayList<URI> projectDirty = new ArrayList<URI>(project2dirty.get((Object)it));
            ArrayList<URI> projectDeleted = new ArrayList<URI>(project2deleted.get((Object)it));
            XIncrementalBuilder.XResult partialResult = projectManager.doBuild(projectDirty, projectDeleted, this.unreportedDeltas, cancelIndicator);
            FluentIterable.from(partialResult.getAffectedResources()).transform(IResourceDescription.Delta::getUri).copyInto(allDirty);
            this.dirtyFiles.removeAll(projectDirty);
            this.deletedFiles.removeAll(projectDeleted);
            this.mergeWithUnreportedDeltas(partialResult.getAffectedResources());
        }
        List<IResourceDescription.Delta> result = this.unreportedDeltas;
        this.unreportedDeltas = new ArrayList<IResourceDescription.Delta>();
        return result;
    }

    protected void mergeWithUnreportedDeltas(List<IResourceDescription.Delta> newDeltas) {
        if (this.unreportedDeltas.isEmpty()) {
            this.unreportedDeltas.addAll(newDeltas);
        } else {
            Map unreportedByUri = IterableExtensions.toMap(this.unreportedDeltas, IResourceDescription.Delta::getUri);
            newDeltas.forEach(newDelta -> {
                IResourceDescription.Delta unreportedDelta = (IResourceDescription.Delta)unreportedByUri.get(newDelta.getUri());
                if (unreportedDelta == null) {
                    this.unreportedDeltas.add((IResourceDescription.Delta)newDelta);
                } else {
                    this.unreportedDeltas.remove(unreportedDelta);
                    IResourceDescription _old = unreportedDelta.getOld();
                    IResourceDescription _new = newDelta.getNew();
                    this.unreportedDeltas.add((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(_old, _new));
                }
            });
        }
    }

    protected List<ProjectDescription> sortByDependencies(Iterable<ProjectDescription> projectDescriptions) {
        return ((TopologicalSorter)this.sorterProvider.get()).sortByDependencies(projectDescriptions, it -> this.reportDependencyCycle(this.workspaceManager.getProjectManager(it.getName())));
    }

    protected void reportDependencyCycle(XProjectManager manager) {
        manager.reportProjectIssue("Project has cyclic dependencies", CYCLIC_PROJECT_DEPENDENCIES, Severity.ERROR);
    }

    public void setWorkspaceManager(XWorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public static interface XBuildable {
        public static final XBuildable NO_BUILD = cancelIndicator -> Collections.emptyList();

        public List<IResourceDescription.Delta> build(CancelIndicator var1);
    }

    protected static class XProjectBuildData {
        private final List<URI> dirtyFiles;
        private final List<URI> deletedFiles;

        public XProjectBuildData(List<URI> dirtyFiles, List<URI> deletedFiles) {
            this.dirtyFiles = dirtyFiles;
            this.deletedFiles = deletedFiles;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.dirtyFiles == null ? 0 : this.dirtyFiles.hashCode());
            return prime * result + (this.deletedFiles == null ? 0 : this.deletedFiles.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XProjectBuildData other = (XProjectBuildData)obj;
            if (this.dirtyFiles == null ? other.dirtyFiles != null : !this.dirtyFiles.equals(other.dirtyFiles)) {
                return false;
            }
            return !(this.deletedFiles == null ? other.deletedFiles != null : !this.deletedFiles.equals(other.deletedFiles));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("dirtyFiles", this.dirtyFiles);
            b.add("deletedFiles", this.deletedFiles);
            return b.toString();
        }

        public List<URI> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public List<URI> getDeletedFiles() {
            return this.deletedFiles;
        }
    }
}

