/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import org.eclipse.n4js.conversion.AbstractN4JSStringValueConverter;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;

public class N4JSStringValueConverter
extends AbstractN4JSStringValueConverter {
    @Override
    protected String getRightDelimiter() {
        return "\"";
    }

    @Override
    protected String getLeftDelimiter() {
        return "\"";
    }

    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            if (string.length() == 1) {
                throw this.newN4JSValueConverterException(string.charAt(0), node, "");
            }
            char first = string.charAt(0);
            int lastIdx = string.length() - 1;
            if (string.charAt(lastIdx) == first) {
                if (string.length() >= 3 && string.charAt(lastIdx - 1) == '\\' && string.charAt(lastIdx - 2) != '\\') {
                    String value = N4JSStringValueConverter.convertFromN4JSString(string.substring(1), node, false);
                    throw this.newN4JSValueConverterException(first, node, value);
                }
                return N4JSStringValueConverter.convertFromN4JSString(string.substring(1, lastIdx), node, true);
            }
            String value = N4JSStringValueConverter.convertFromN4JSString(string.substring(1), node, false);
            throw this.newN4JSValueConverterException(first, node, value);
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }

    protected N4JSValueConverterWithValueException newN4JSValueConverterException(char c, INode node, String value) {
        if (c == '\"') {
            return new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_STRING_DOUBLE_QUOTE(), "VCO_STRING_DOUBLE_QUOTE", node, value, null);
        }
        return new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_STRING_QUOTE(), "VCO_STRING_QUOTE", node, value, null);
    }
}

