/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.subscribers.ChangeSet;

public abstract class CheckedInChangeSet
extends ChangeSet {
    private final SyncInfoTree set = new SyncInfoTree();

    public abstract String getAuthor();

    public abstract Date getDate();

    public SyncInfoTree getSyncInfoSet() {
        return this.set;
    }

    @Override
    public IResource[] getResources() {
        return this.set.getResources();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(IResource local) {
        return this.set.getSyncInfo(local) != null;
    }

    public void add(SyncInfo info) {
        if (this.isValidChange(info)) {
            this.set.add(info);
        }
    }

    protected boolean isValidChange(SyncInfo info) {
        return info != null;
    }

    public void add(SyncInfo[] infos) {
        try {
            this.set.beginInput();
            SyncInfo[] syncInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                SyncInfo info = syncInfoArray[n2];
                this.add(info);
                ++n2;
            }
        }
        finally {
            this.set.endInput(null);
        }
    }

    @Override
    public void remove(IResource resource) {
        if (this.contains(resource)) {
            this.set.remove(resource);
        }
    }

    @Override
    public void remove(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.remove(resource);
            ++n2;
        }
    }

    @Override
    public void rootRemoved(IResource resource, int depth) {
        SyncInfo[] infos = this.set.getSyncInfos(resource, depth);
        if (infos.length > 0) {
            IResource[] resources = new IResource[infos.length];
            int i = 0;
            while (i < resources.length) {
                resources[i] = infos[i].getLocal();
                ++i;
            }
            this.set.removeAll(resources);
        }
    }

    @Override
    public boolean containsChildren(IResource resource, int depth) {
        return this.set.getSyncInfos(resource, depth).length > 0;
    }
}

