/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.serializer.sequencer.AbstractSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.IAssignmentFinder;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.TransientValueUtil;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;

public class BacktrackingSemanticSequencer
extends AbstractSemanticSequencer {
    protected static final Object INVALID = new Object();
    @Inject
    protected IAssignmentFinder assignmentFinder;
    @Inject
    private IGrammarConstraintProvider constraintProvider;
    @Inject
    protected TransientValueUtil transientValueUtil;
    @Inject
    private IGrammarAccess grammar;

    protected void accept(TraceItem ti, SequenceFeeder feeder) {
        AbstractElement ele = ti.getState().getAssignedGrammarElement();
        if (ti.getState().getFeature().isMany()) {
            if (ele instanceof RuleCall) {
                feeder.accept((RuleCall)ele, ti.getValue(), ti.getIndex(), ti.getNode());
            } else if (ele instanceof Action) {
                feeder.accept((Action)ele, (EObject)ti.getValue(), ti.getCompositeNode());
            } else if (ele instanceof Keyword) {
                feeder.accept((Keyword)ele, ti.getValue(), ti.getIndex(), ti.getLeafNode());
            }
        } else if (ele instanceof RuleCall) {
            feeder.accept((RuleCall)ele, ti.getValue(), ti.getNode());
        } else if (ele instanceof Action) {
            feeder.accept((Action)ele, (EObject)ti.getValue(), ti.getCompositeNode());
        } else if (ele instanceof Keyword) {
            feeder.accept((Keyword)ele, ti.getValue(), ti.getLeafNode());
        }
    }

    protected Comparator<ISemanticSequencerNfaProvider.ISemState> createFollowerSorter(SerializableObject obj, AbstractElement nodeModelEle) {
        return new FollowerSorter(obj, nodeModelEle);
    }

    @Override
    @Deprecated
    public void createSequence(EObject context, EObject obj) {
        this.createSequence(SerializationContext.fromEObject(context, obj), obj);
    }

    @Override
    public void createSequence(ISerializationContext context, EObject obj) {
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.nodeProvider.getNodesForSemanticObject(obj, null);
        SerializationContextMap<IGrammarConstraintProvider.IConstraint> constraints = this.constraintProvider.getConstraints(this.grammar.getGrammar());
        IGrammarConstraintProvider.IConstraint constraint = constraints.get(context);
        if (constraint == null) {
            throw new IllegalStateException("Invalid context: " + context);
        }
        Nfa<ISemanticSequencerNfaProvider.ISemState> nfa = constraint.getNfa();
        final SerializableObject object = new SerializableObject(context, obj, nodes);
        TraceItem co = new TraceItem(object);
        List trace = new NfaUtil().backtrack(nfa, (Object)co, (NfaUtil.BacktrackHandler)new NfaUtil.BacktrackHandler<ISemanticSequencerNfaProvider.ISemState, TraceItem>(){

            public TraceItem handle(ISemanticSequencerNfaProvider.ISemState state, TraceItem previous) {
                if (!previous.canEnter(state)) {
                    return null;
                }
                if (state.getFeature() != null) {
                    return previous.cloneAndConsume(state);
                }
                return previous.clone(state);
            }

            public boolean isSolution(TraceItem result) {
                return result.isConsumed();
            }

            public Iterable<ISemanticSequencerNfaProvider.ISemState> sortFollowers(TraceItem result, Iterable<ISemanticSequencerNfaProvider.ISemState> followers) {
                AbstractElement next = result.getNextGrammarElement();
                ArrayList r = Lists.newArrayList(followers);
                Collections.sort(r, BacktrackingSemanticSequencer.this.createFollowerSorter(object, next));
                return r;
            }
        });
        SequenceFeeder feeder = this.feederProvider.create(context, obj, nodes, this.masterSequencer, this.sequenceAcceptor, this.errorAcceptor);
        if (trace != null) {
            for (TraceItem ti : trace) {
                if (ti.getState() == null || ti.getState().getFeature() == null) continue;
                this.accept(ti, feeder);
            }
        } else if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createBacktrackingFailedDiagnostic(object, context, constraint));
        }
        feeder.finish();
    }

    public static class FollowerSorter
    implements Comparator<ISemanticSequencerNfaProvider.ISemState> {
        protected EObject nodeModelEle;
        protected SerializableObject obj;

        public FollowerSorter(SerializableObject obj, AbstractElement nodeModelEle) {
            this.obj = obj;
            this.nodeModelEle = nodeModelEle;
        }

        @Override
        public int compare(ISemanticSequencerNfaProvider.ISemState o1, ISemanticSequencerNfaProvider.ISemState o2) {
            int o2id;
            if (this.nodeModelEle != null) {
                if (o1.getAssignedGrammarElement() == this.nodeModelEle) {
                    return -1;
                }
                if (o2.getAssignedGrammarElement() == this.nodeModelEle) {
                    return 1;
                }
            }
            if (o1.getAssignedGrammarElement() == null && o2.getAssignedGrammarElement() == null) {
                return 0;
            }
            if (o1.getAssignedGrammarElement() == null) {
                return -1;
            }
            if (o2.getAssignedGrammarElement() == null) {
                return 1;
            }
            boolean o1Opt = this.obj.isOptional(o1.getFeatureID());
            boolean o2Opt = this.obj.isOptional(o2.getFeatureID());
            if (o1Opt && !o2Opt) {
                return 1;
            }
            if (o2Opt && !o1Opt) {
                return -1;
            }
            int o1Cnt = this.obj.getValueCount(o1.getFeatureID());
            int o2Cnt = this.obj.getValueCount(o2.getFeatureID());
            if (o1Cnt == 0 && o2Cnt > 0) {
                return 1;
            }
            if (o2Cnt == 0 && o1Cnt > 0) {
                return -1;
            }
            int o1id = o1.getOrderID();
            return o1id < (o2id = o2.getOrderID()) ? -1 : (o1id > o2id ? 1 : 0);
        }
    }

    public class SerializableObject {
        protected final EObject eObject;
        protected final ISerializationContext context;
        protected List<ISemanticNodeProvider.ISemanticNode>[] nodes;
        protected final ISemanticNodeProvider.ISemanticNode firstNode;
        protected boolean[] optional;
        protected Map<Pair<AbstractElement, Integer>, Boolean> valid = Maps.newHashMap();
        protected Object[] values;

        public SerializableObject(ISerializationContext context, EObject eObject, ISemanticNodeProvider.INodesForEObjectProvider nodeProvider) {
            this.eObject = eObject;
            this.context = context;
            this.firstNode = nodeProvider.getFirstSemanticNode();
            EClass clazz = eObject.eClass();
            this.values = new Object[clazz.getFeatureCount()];
            this.nodes = new List[clazz.getFeatureCount()];
            this.optional = new boolean[clazz.getFeatureCount()];
            for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
                int featureID = eObject.eClass().getFeatureID(feature);
                if (feature.isMany()) {
                    switch (BacktrackingSemanticSequencer.this.transientValues.isListTransient(eObject, feature)) {
                        case NO: {
                            ArrayList nodes1 = Lists.newArrayList();
                            List values1 = feature instanceof EReference && ((EReference)feature).isResolveProxies() ? ((InternalEList)eObject.eGet(feature)).basicList() : (List)eObject.eGet(feature);
                            for (int i = 0; i < values1.size(); ++i) {
                                nodes1.add(nodeProvider.getSemanticNodeForMultiValue(feature, i, i, values1.get(i)));
                            }
                            this.values[featureID] = values1;
                            this.nodes[featureID] = nodes1;
                            break;
                        }
                        case SOME: {
                            ArrayList nodes2 = Lists.newArrayList();
                            List values2 = feature instanceof EReference && ((EReference)feature).isResolveProxies() ? ((InternalEList)eObject.eGet(feature)).basicList() : (List)eObject.eGet(feature);
                            ArrayList values3 = Lists.newArrayList();
                            int j = 0;
                            for (int i = 0; i < values2.size(); ++i) {
                                if (BacktrackingSemanticSequencer.this.transientValues.isValueInListTransient(eObject, i, feature)) continue;
                                Object value = values2.get(i);
                                ISemanticNodeProvider.ISemanticNode node = nodeProvider.getSemanticNodeForMultiValue(feature, i, j++, value);
                                values3.add(value);
                                nodes2.add(node);
                            }
                            this.values[featureID] = values3;
                            this.nodes[featureID] = nodes2;
                            break;
                        }
                        case YES: {
                            this.values[featureID] = INVALID;
                        }
                    }
                    continue;
                }
                switch (BacktrackingSemanticSequencer.this.transientValues.isValueTransient(eObject, feature)) {
                    case PREFERABLY: {
                        Object value1;
                        this.optional[featureID] = true;
                        this.values[featureID] = value1 = eObject.eGet(feature, false);
                        this.nodes[featureID] = Collections.singletonList(nodeProvider.getSemanticNodeForSingelValue(feature, value1));
                        break;
                    }
                    case NO: {
                        Object value2;
                        this.values[featureID] = value2 = eObject.eGet(feature, false);
                        this.nodes[featureID] = Collections.singletonList(nodeProvider.getSemanticNodeForSingelValue(feature, value2));
                        break;
                    }
                    case YES: {
                        this.values[featureID] = INVALID;
                    }
                }
            }
        }

        public EObject getEObject() {
            return this.eObject;
        }

        public ISemanticNodeProvider.ISemanticNode getFirstNode() {
            return this.firstNode;
        }

        public ISemanticNodeProvider.ISemanticNode getNode(int featureID, int index) {
            List<ISemanticNodeProvider.ISemanticNode> featureNodes = this.nodes[featureID];
            if (featureNodes != null && index >= 0 && index < featureNodes.size()) {
                return featureNodes.get(index);
            }
            return null;
        }

        public Object getValue(ISemanticSequencerNfaProvider.ISemState state, int index) {
            Object value = this.values[state.getFeatureID()];
            if (value instanceof List) {
                value = ((List)value).get(index);
            }
            if (!this.isValueValid(state, index, value)) {
                return INVALID;
            }
            return value;
        }

        public int getValueCount(int featureID) {
            Object v = this.values[featureID];
            if (v == INVALID) {
                return 0;
            }
            if (v instanceof List) {
                return ((List)v).size();
            }
            return 1;
        }

        public String getValuesString() {
            ArrayList items = Lists.newArrayList();
            for (int i = 0; i < this.values.length; ++i) {
                int count = this.getValueCount(i);
                if (count <= 0) continue;
                EStructuralFeature feature = this.eObject.eClass().getEStructuralFeature(i);
                String cnt = this.optional[i] ? "0-" + count : String.valueOf(count);
                items.add(feature.getName() + "(" + cnt + ")");
            }
            return "Values: " + Joiner.on((String)", ").join((Iterable)items);
        }

        public boolean isList(int featureID) {
            return this.values[featureID] instanceof List;
        }

        public boolean isOptional(int featureID) {
            return this.optional[featureID];
        }

        protected boolean isValueValid(ISemanticSequencerNfaProvider.ISemState state, int index, Object value) {
            List<AbstractElement> candidates = state.getToBeValidatedAssignedElements();
            if (candidates.isEmpty()) {
                return true;
            }
            Pair key = Tuples.create((Object)state.getAssignedGrammarElement(), (Object)index);
            if (this.valid.get(key) == Boolean.TRUE) {
                return true;
            }
            ISemanticNodeProvider.ISemanticNode semanticNode = this.getNode(state.getFeatureID(), index);
            INode node = semanticNode == null ? null : semanticNode.getNode();
            ArrayListMultimap assignments = ArrayListMultimap.create();
            for (AbstractElement ele : candidates) {
                assignments.put((Object)ele, (Object)this.context);
            }
            Set<AbstractElement> found = BacktrackingSemanticSequencer.this.assignmentFinder.findAssignmentsByValue(this.eObject, (Multimap<AbstractElement, ISerializationContext>)assignments, value, node);
            boolean result = found.contains(state.getAssignedGrammarElement());
            this.valid.put((Pair<AbstractElement, Integer>)key, result);
            return result;
        }

        public String toString() {
            ArrayList mandatory = Lists.newArrayList();
            ArrayList optional = Lists.newArrayList();
            for (int i = 0; i < this.values.length; ++i) {
                int count = this.getValueCount(i);
                if (count <= 0) continue;
                EStructuralFeature feature = this.eObject.eClass().getEStructuralFeature(i);
                if (this.optional[i]) {
                    optional.add(feature.getName() + "(" + count + ")");
                    continue;
                }
                mandatory.add(feature.getName() + "(" + count + ")");
            }
            StringBuilder result = new StringBuilder();
            result.append("EObject: " + EmfFormatter.objPath((EObject)this.eObject) + "\n");
            result.append(this.getValuesString() + "\n");
            return result.toString();
        }
    }

    protected static class TraceItem {
        protected int index;
        protected int[] nextIndex;
        protected ISemanticNodeProvider.ISemanticNode node;
        protected SerializableObject obj;
        protected TraceItem parent;
        protected ISemanticSequencerNfaProvider.ISemState state;
        protected Object value;

        public TraceItem(SerializableObject obj) {
            this(obj, new int[obj.getEObject().eClass().getFeatureCount()]);
        }

        public TraceItem(SerializableObject obj, int[] unconsumed) {
            this.obj = obj;
            this.nextIndex = unconsumed;
        }

        public boolean canEnter(ISemanticSequencerNfaProvider.ISemState state) {
            if (state.isBooleanAssignment() && !Boolean.TRUE.equals(this.obj.getValue(state, state.getFeatureID()))) {
                return false;
            }
            for (int i = 0; i < this.nextIndex.length; ++i) {
                int count;
                if (i == state.getFeatureID() || (count = this.nextIndex[i]) >= this.obj.getValueCount(i) || count == 0 && this.obj.isOptional(i) || state.getAllFollowerFeatures().get(i)) continue;
                return false;
            }
            return true;
        }

        public TraceItem clone(ISemanticSequencerNfaProvider.ISemState state) {
            TraceItem result = new TraceItem(this.obj, this.nextIndex);
            result.parent = this;
            result.state = state;
            result.value = this.value;
            result.index = this.index;
            result.node = this.node;
            return result;
        }

        public TraceItem cloneAndConsume(ISemanticSequencerNfaProvider.ISemState state) {
            int index = this.nextIndex[state.getFeatureID()];
            if (index >= this.obj.getValueCount(state.getFeatureID())) {
                return null;
            }
            Object value = this.obj.getValue(state, index);
            if (value == INVALID) {
                return null;
            }
            int[] unconsumedCopy = new int[this.nextIndex.length];
            System.arraycopy(this.nextIndex, 0, unconsumedCopy, 0, this.nextIndex.length);
            unconsumedCopy[state.getFeatureID()] = index + 1;
            TraceItem result = new TraceItem(this.obj, unconsumedCopy);
            result.parent = this;
            result.state = state;
            result.value = value;
            result.index = index;
            result.node = this.obj.getNode(state.getFeatureID(), index);
            return result;
        }

        public int getIndex() {
            return this.index;
        }

        public AbstractElement getNextGrammarElement() {
            ISemanticNodeProvider.ISemanticNode sem = null;
            if (this.obj != null && (this.parent == null || this.parent.parent == null)) {
                sem = this.obj.getFirstNode();
            } else if (this.node != null) {
                sem = this.node.getFollower();
            }
            if (sem != null) {
                return sem.getGrammarElement();
            }
            return null;
        }

        public INode getNode() {
            if (this.node == null) {
                return null;
            }
            return this.node.getNode();
        }

        public ICompositeNode getCompositeNode() {
            INode result = this.getNode();
            return result instanceof ICompositeNode ? (ICompositeNode)result : null;
        }

        public ILeafNode getLeafNode() {
            INode result = this.getNode();
            return result instanceof ILeafNode ? (ILeafNode)result : null;
        }

        public SerializableObject getObj() {
            return this.obj;
        }

        public TraceItem getParent() {
            return this.parent;
        }

        public ISemanticSequencerNfaProvider.ISemState getState() {
            return this.state;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isConsumed() {
            for (int i = 0; i < this.nextIndex.length; ++i) {
                int count = this.nextIndex[i];
                if (count >= this.obj.getValueCount(i) || count == 0 && this.obj.isOptional(i)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            ArrayList mandatory = Lists.newArrayList();
            ArrayList optional = Lists.newArrayList();
            ArrayList consumed = Lists.newArrayList();
            for (int i = 0; i < this.nextIndex.length; ++i) {
                int count = this.nextIndex[i];
                int max = this.obj.getValueCount(i);
                EStructuralFeature feature = this.obj.getEObject().eClass().getEStructuralFeature(i);
                if (count < max) {
                    if (count == 0 && this.obj.isOptional(i)) {
                        optional.add(feature.getName() + "(" + (max - count) + ")");
                        continue;
                    }
                    mandatory.add(feature.getName() + "(" + (max - count) + ")");
                    continue;
                }
                if (max <= 0) continue;
                consumed.add(feature.getName() + "(" + count + ")");
            }
            StringBuilder result = new StringBuilder();
            result.append("State: " + this.state + "\n");
            result.append("EObject: " + EmfFormatter.objPath((EObject)this.obj.getEObject()) + "\n");
            result.append("Remaining Mandatory Values: " + Joiner.on((String)", ").join((Iterable)mandatory) + "\n");
            result.append("Remaining Optional Values: " + Joiner.on((String)", ").join((Iterable)optional) + "\n");
            result.append("Consumed Values: " + Joiner.on((String)", ").join((Iterable)consumed) + "\n");
            return result.toString();
        }
    }
}

