/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.monitoring;

import org.eclipse.ui.monitoring.StackSample;

public class UiFreezeEvent {
    private final long startTimestamp;
    private final long totalDuration;
    private final StackSample[] stackTraceSamples;
    private final boolean isStillRunning;
    private final boolean isStarvedAwake;
    private final boolean isStarvedAsleep;

    public UiFreezeEvent(long startTime, long duration, StackSample[] samples, boolean stillRunning, boolean starvedAwake, boolean starvedAsleep) {
        this.startTimestamp = startTime;
        this.stackTraceSamples = samples;
        this.totalDuration = duration;
        this.isStillRunning = stillRunning;
        this.isStarvedAwake = starvedAwake;
        this.isStarvedAsleep = starvedAsleep;
    }

    public final long getStartTimestamp() {
        return this.startTimestamp;
    }

    public final long getTotalDuration() {
        return this.totalDuration;
    }

    public final StackSample[] getStackTraceSamples() {
        return this.stackTraceSamples;
    }

    public final boolean isStillRunning() {
        return this.isStillRunning;
    }

    public final boolean isStarvedAwake() {
        return this.isStarvedAwake;
    }

    public final boolean isStarvedAsleep() {
        return this.isStarvedAsleep;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Freeze started at ");
        buf.append(this.startTimestamp);
        if (this.isStillRunning) {
            buf.append(" still ongoing after ");
        } else {
            buf.append(" lasted ");
        }
        buf.append(this.totalDuration);
        buf.append("ms");
        if (this.isStarvedAwake || this.isStarvedAsleep) {
            String when = this.isStarvedAwake && this.isStarvedAsleep ? "awake and asleep" : (this.isStarvedAwake ? "awake" : "asleep");
            buf.append(", monitoring thread starved for CPU while " + when);
        }
        if (this.stackTraceSamples.length != 0) {
            buf.append("\nStack trace samples:");
            StackSample[] stackSampleArray = this.stackTraceSamples;
            int n = this.stackTraceSamples.length;
            int n2 = 0;
            while (n2 < n) {
                StackSample stackTraceSample = stackSampleArray[n2];
                buf.append('\n');
                buf.append(stackTraceSample.toString());
                ++n2;
            }
        }
        return buf.toString();
    }
}

