/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.typeRefs.util.TypeRefsSwitch;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.AbstractJudgment;
import org.eclipse.n4js.typesystem.utils.BoundType;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.RecursionGuard;

class BoundJudgment
extends AbstractJudgment {
    BoundJudgment() {
    }

    public TypeRef applyUpperBound(RuleEnvironment G, TypeArgument typeArg, boolean reopen, boolean resolve) {
        BoundSwitch theSwitch = new BoundSwitch(G, BoundType.UPPER, reopen, resolve);
        TypeRef result = (TypeRef)theSwitch.doSwitch((EObject)typeArg);
        if (result == null) {
            String stringRep = typeArg != null ? typeArg.getTypeRefAsString() : "<null>";
            throw new IllegalStateException("null return value in upperBound judgment for type argument: " + stringRep);
        }
        return result;
    }

    public TypeRef applyLowerBound(RuleEnvironment G, TypeArgument typeArg, boolean reopen, boolean resolve) {
        BoundSwitch theSwitch = new BoundSwitch(G, BoundType.LOWER, reopen, resolve);
        TypeRef result = (TypeRef)theSwitch.doSwitch((EObject)typeArg);
        if (result == null) {
            String stringRep = typeArg != null ? typeArg.getTypeRefAsString() : "<null>";
            throw new IllegalStateException("null return value in lowerBound judgment for type argument: " + stringRep);
        }
        return result;
    }

    private final class BoundSwitch
    extends TypeRefsSwitch<TypeRef> {
        private final RuleEnvironment G;
        private final BoundType boundType;
        private final boolean reopen;
        private final boolean resolve;
        private final RecursionGuard<EObject> guard = new RecursionGuard();

        public BoundSwitch(RuleEnvironment G, BoundType boundType, boolean reopen, boolean resolve) {
            this.G = G;
            this.boundType = boundType;
            this.reopen = reopen;
            this.resolve = resolve;
        }

        private TypeRef bound(TypeArgument typeArg) {
            return this.bound(this.G, typeArg, this.boundType, this.reopen, this.resolve);
        }

        private TypeRef bound(RuleEnvironment G_NEW, TypeArgument typeArg, BoundType boundTypeNEW, boolean reopenNEW, boolean resolveNEW) {
            if (G_NEW == this.G && boundTypeNEW == this.boundType && reopenNEW == this.reopen && resolveNEW == this.resolve) {
                return (TypeRef)this.doSwitch((EObject)typeArg);
            }
            BoundSwitch nestedSwitch = new BoundSwitch(G_NEW, boundTypeNEW, reopenNEW, resolveNEW);
            return (TypeRef)nestedSwitch.doSwitch((EObject)typeArg);
        }

        protected TypeRef doSwitch(int classifierID, EObject eObject) {
            if (this.guard.tryNext((Object)eObject)) {
                try {
                    TypeRef typeRef = (TypeRef)super.doSwitch(classifierID, eObject);
                    return typeRef;
                }
                finally {
                    this.guard.done((Object)eObject);
                }
            }
            return eObject instanceof Wildcard ? this.getFallbackBoundForWildcard((Wildcard)eObject) : (TypeRef)eObject;
        }

        public TypeRef caseTypeRef(TypeRef typeRef) {
            return typeRef;
        }

        public TypeRef caseWildcard(Wildcard wildcard) {
            TypeRef declBound;
            TypeRef typeRef = declBound = this.boundType == BoundType.UPPER ? wildcard.getDeclaredOrImplicitUpperBound() : wildcard.getDeclaredLowerBound();
            if (declBound != null) {
                return declBound;
            }
            return this.getFallbackBoundForWildcard(wildcard);
        }

        private TypeRef getFallbackBoundForWildcard(Wildcard wildcard) {
            return this.boundType == BoundType.UPPER ? RuleEnvironmentExtensions.topTypeRef(this.G) : RuleEnvironmentExtensions.bottomTypeRef(this.G);
        }

        public TypeRef caseExistentialTypeRef(ExistentialTypeRef existentialTypeRef) {
            if (existentialTypeRef.isReopened() || this.shouldBeReopened(existentialTypeRef)) {
                TypeRef result = this.caseWildcard(existentialTypeRef.getWildcard());
                result = (TypeRef)TypeUtils.copy((EObject)result);
                TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)existentialTypeRef);
                return result;
            }
            return existentialTypeRef;
        }

        public TypeRef caseUnionTypeExpression(UnionTypeExpression union) {
            Optional<List<TypeRef>> typeRefsBounds = this.mapAndCompare((List)union.getTypeRefs(), (Function)this::bound);
            if (typeRefsBounds.isPresent()) {
                UnionTypeExpression result = TypeUtils.createNonSimplifiedUnionType((Iterable)((Iterable)typeRefsBounds.get()));
                TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)union);
                return result;
            }
            return union;
        }

        public TypeRef caseIntersectionTypeExpression(IntersectionTypeExpression intersection) {
            Optional<List<TypeRef>> typeRefsBounds = this.mapAndCompare((List)intersection.getTypeRefs(), (Function)this::bound);
            if (typeRefsBounds.isPresent()) {
                IntersectionTypeExpression result = TypeUtils.createNonSimplifiedIntersectionType((Iterable)((Iterable)typeRefsBounds.get()));
                TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)intersection);
                return result;
            }
            return intersection;
        }

        private <T extends TypeArgument> Optional<List<T>> mapAndCompare(List<T> typeArgs, Function<T, T> fn) {
            ArrayList<TypeArgument> typeArgsBounds = new ArrayList<TypeArgument>(typeArgs.size());
            boolean haveChange = false;
            for (TypeArgument typeArg : typeArgs) {
                TypeArgument typeArgBound = (TypeArgument)fn.apply(typeArg);
                typeArgsBounds.add(typeArgBound);
                haveChange |= typeArgBound != typeArg;
            }
            return haveChange ? Optional.of(typeArgsBounds) : Optional.absent();
        }

        public TypeRef caseParameterizedTypeRef(ParameterizedTypeRef ptr) {
            Type declType = ptr.getDeclaredType();
            if (declType instanceof TypeVariable && this.resolve) {
                switch (this.boundType) {
                    case UPPER: {
                        TypeRef upperBound = ((TypeVariable)declType).getDeclaredUpperBound();
                        if (upperBound != null) {
                            TypeRef upperBoundOfUpperBound = this.bound((TypeArgument)upperBound);
                            return upperBoundOfUpperBound;
                        }
                        return RuleEnvironmentExtensions.topTypeRef(this.G);
                    }
                    case LOWER: {
                        return RuleEnvironmentExtensions.bottomTypeRef(this.G);
                    }
                }
            }
            if (ptr.isGeneric()) {
                Iterator typeParamsIter = declType != null ? declType.getTypeVars().iterator() : Collections.emptyIterator();
                ArrayList<TypeArgument> typeArgsPushed = new ArrayList<TypeArgument>();
                boolean haveChange = false;
                for (TypeArgument typeArg : ptr.getTypeArgs()) {
                    TypeVariable typeParam = typeParamsIter.hasNext() ? (TypeVariable)typeParamsIter.next() : null;
                    Variance defSiteVariance = typeParam != null ? typeParam.getVariance() : Variance.INV;
                    TypeArgument typeArgPushed = this.pushBoundOfTypeArgument(typeArg, defSiteVariance);
                    typeArgsPushed.add(typeArgPushed);
                    haveChange |= typeArgPushed != typeArg;
                }
                if (haveChange) {
                    ParameterizedTypeRef ptrCpy = (ParameterizedTypeRef)TypeUtils.copyPartial((EObject)ptr, (EReference[])new EReference[]{TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_TypeArgs()});
                    ptrCpy.getTypeArgs().clear();
                    ptrCpy.getTypeArgs().addAll(TypeUtils.copyAll(typeArgsPushed));
                    return ptrCpy;
                }
            }
            return ptr;
        }

        private TypeArgument pushBoundOfTypeArgument(TypeArgument typeArg, Variance defSiteVariance) {
            if (typeArg instanceof Wildcard) {
                TypeRef boundOfBoundToBePushed;
                BoundType pushDirection;
                TypeRef boundToBePushed;
                Wildcard wildcard = (Wildcard)typeArg;
                TypeRef upperBound = wildcard.getDeclaredOrImplicitUpperBound();
                TypeRef lowerBound = wildcard.getDeclaredLowerBound();
                if (upperBound != null) {
                    boundToBePushed = upperBound;
                    pushDirection = this.boundType;
                } else if (lowerBound != null) {
                    boundToBePushed = lowerBound;
                    pushDirection = this.boundType.inverse();
                } else {
                    boundToBePushed = null;
                    pushDirection = null;
                }
                if (boundToBePushed != null && (boundOfBoundToBePushed = this.bound(this.G, (TypeArgument)boundToBePushed, pushDirection, this.reopen, false)) != boundToBePushed) {
                    Wildcard wildcardCpy = (Wildcard)TypeUtils.copy((EObject)wildcard);
                    if (upperBound != null) {
                        wildcardCpy.setDeclaredUpperBound((TypeRef)TypeUtils.copyIfContained((EObject)boundOfBoundToBePushed));
                    } else if (lowerBound != null) {
                        wildcardCpy.setDeclaredLowerBound((TypeRef)TypeUtils.copyIfContained((EObject)boundOfBoundToBePushed));
                    }
                    return wildcardCpy;
                }
            } else {
                if (typeArg instanceof ExistentialTypeRef && ((ExistentialTypeRef)typeArg).isReopened()) {
                    Wildcard wildcard = ((ExistentialTypeRef)typeArg).getWildcard();
                    Wildcard wildcardPushed = (Wildcard)this.pushBoundOfTypeArgument((TypeArgument)wildcard, defSiteVariance);
                    return wildcardPushed;
                }
                if (defSiteVariance == Variance.CO) {
                    TypeRef boundToBePushed = (TypeRef)typeArg;
                    BoundType pushDirection = this.boundType;
                    TypeRef boundOfBoundToBePushed = this.bound(this.G, (TypeArgument)boundToBePushed, pushDirection, this.reopen, false);
                    if (boundOfBoundToBePushed != boundToBePushed) {
                        return boundOfBoundToBePushed;
                    }
                } else if (defSiteVariance == Variance.CONTRA) {
                    TypeRef boundToBePushed = (TypeRef)typeArg;
                    BoundType pushDirection = this.boundType.inverse();
                    TypeRef boundOfBoundToBePushed = this.bound(this.G, (TypeArgument)boundToBePushed, pushDirection, this.reopen, false);
                    if (boundOfBoundToBePushed != boundToBePushed) {
                        return boundOfBoundToBePushed;
                    }
                } else if (typeArg instanceof ExistentialTypeRef && this.shouldBeReopened((ExistentialTypeRef)typeArg)) {
                    Wildcard wildcard = ((ExistentialTypeRef)typeArg).getWildcard();
                    Wildcard wildcardPushed = (Wildcard)this.pushBoundOfTypeArgument((TypeArgument)wildcard, defSiteVariance);
                    return wildcardPushed;
                }
            }
            return typeArg;
        }

        public TypeRef caseFunctionTypeRef(FunctionTypeRef F) {
            return this.caseFunctionTypeExprOrRef((FunctionTypeExprOrRef)F);
        }

        public TypeRef caseFunctionTypeExprOrRef(FunctionTypeExprOrRef F) {
            boolean haveReplacement = false;
            TypeRef returnTypeRef = F.getReturnTypeRef();
            TypeRef resultReturnTypeRef = returnTypeRef != null ? this.bound(this.G, (TypeArgument)F.getReturnTypeRef(), this.boundType, this.reopen, false) : null;
            haveReplacement |= resultReturnTypeRef != returnTypeRef;
            EList fpars = F.getFpars();
            ArrayList<TFormalParameter> resultFpars = new ArrayList<TFormalParameter>(fpars.size());
            for (TFormalParameter oldPar : fpars) {
                if (oldPar == null) {
                    resultFpars.add(null);
                    continue;
                }
                TFormalParameter newPar = TypesFactory.eINSTANCE.createTFormalParameter();
                newPar.setName(oldPar.getName());
                newPar.setVariadic(oldPar.isVariadic());
                newPar.setHasInitializerAssignment(oldPar.isHasInitializerAssignment());
                TypeRef oldParTypeRef = oldPar.getTypeRef();
                if (oldParTypeRef != null) {
                    TypeRef newParTypeRef = this.bound(this.G, (TypeArgument)oldParTypeRef, this.boundType.inverse(), this.reopen, false);
                    newPar.setTypeRef((TypeRef)TypeUtils.copyIfContained((EObject)newParTypeRef));
                    haveReplacement |= newParTypeRef != oldParTypeRef;
                }
                resultFpars.add(newPar);
            }
            if (haveReplacement) {
                FunctionTypeExpression result = TypeRefsFactory.eINSTANCE.createFunctionTypeExpression();
                result.setBinding(true);
                result.setDeclaredType(F.getFunctionType());
                result.getUnboundTypeVars().addAll((Collection)F.getTypeVars());
                if (F instanceof FunctionTypeExpression) {
                    result.getUnboundTypeVarsUpperBounds().addAll(TypeUtils.copyAll((Collection)((FunctionTypeExpression)F).getUnboundTypeVarsUpperBounds()));
                }
                if (F.getDeclaredThisType() != null) {
                    result.setDeclaredThisType((TypeRef)TypeUtils.copyIfContained((EObject)F.getDeclaredThisType()));
                }
                result.setReturnTypeRef((TypeRef)TypeUtils.copyIfContained((EObject)resultReturnTypeRef));
                result.setReturnValueMarkedOptional(F.isReturnValueOptional());
                result.getFpars().addAll(resultFpars);
                TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)F);
                return result;
            }
            return F;
        }

        public TypeRef caseBoundThisTypeRef(BoundThisTypeRef boundThisTypeRef) {
            if (this.reopen) {
                if (this.boundType == BoundType.UPPER) {
                    return this.bound((TypeArgument)TypeUtils.createResolvedThisTypeRef((BoundThisTypeRef)boundThisTypeRef));
                }
                ParameterizedTypeRef result = RuleEnvironmentExtensions.bottomTypeRef(this.G);
                TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)boundThisTypeRef);
                return result;
            }
            return boundThisTypeRef;
        }

        public TypeRef caseTypeTypeRef(TypeTypeRef ct) {
            TypeArgument typeArg;
            if (this.reopen && this.boundType == BoundType.UPPER && (typeArg = ct.getTypeArg()) instanceof BoundThisTypeRef) {
                ParameterizedTypeRef typeArgNew = TypeUtils.createResolvedThisTypeRef((BoundThisTypeRef)((BoundThisTypeRef)typeArg));
                return TypeUtils.createTypeTypeRef((TypeArgument)typeArgNew, (boolean)ct.isConstructorRef());
            }
            typeArg = ct.getTypeArg();
            TypeArgument typeArgBound = this.pushBoundOfTypeArgument(typeArg, Variance.INV);
            if (typeArgBound != typeArg) {
                TypeTypeRef ctCpy = (TypeTypeRef)TypeUtils.copyPartial((EObject)ct, (EReference[])new EReference[]{TypeRefsPackage.eINSTANCE.getTypeTypeRef_TypeArg()});
                ctCpy.setTypeArg((TypeArgument)TypeUtils.copyIfContained((EObject)typeArgBound));
                return ctCpy;
            }
            return ct;
        }

        private boolean shouldBeReopened(ExistentialTypeRef etr) {
            return this.reopen && !RuleEnvironmentExtensions.isFixedCapture(this.G, etr);
        }
    }
}

