/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.print;

import java.io.IOException;
import org.eclipse.n4js.transpiler.sourcemap.FilePosition;

class LineColTrackingAppendable
implements Appendable {
    private final Appendable out;
    private final CharSequence indent;
    private int currentIndentLevel = 0;
    private int currentLine = 0;
    private int currentCol = 0;

    public LineColTrackingAppendable(Appendable out, CharSequence indent) {
        this.out = out;
        this.indent = indent;
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (c == '\n') {
            this.newLine();
        } else {
            this.out.append(c);
            ++this.currentCol;
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        if (csq == null) {
            throw new NullPointerException("CharSequence must not be null when appending.");
        }
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        while (start < end) {
            int nextNL = start;
            while (nextNL < end && csq.charAt(nextNL) != '\n') {
                ++nextNL;
            }
            this.out.append(csq, start, nextNL);
            this.currentCol += csq.length();
            if (nextNL < end) {
                this.newLine();
            }
            start = nextNL + 1;
        }
        return this;
    }

    public void newLine() throws IOException {
        this.out.append('\n');
        int n = 0;
        while (n < this.currentIndentLevel) {
            this.out.append(this.indent);
            ++n;
        }
        ++this.currentLine;
        this.currentCol = this.currentIndentLevel * this.indent.length();
    }

    public int getIndentLevel() {
        return this.currentIndentLevel;
    }

    public void setIndentLevel(int indentLevel) {
        this.currentIndentLevel = indentLevel;
    }

    public void indent() {
        ++this.currentIndentLevel;
    }

    public void undent() {
        if (this.currentIndentLevel <= 0) {
            throw new IllegalStateException();
        }
        --this.currentIndentLevel;
    }

    public FilePosition getCurrentPos() {
        return new FilePosition(this.currentLine, this.currentCol);
    }
}

