/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.build;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Procedures;

public class XBuildRequest {
    private URI baseDir;
    private List<URI> dirtyFiles = new ArrayList<URI>();
    private List<URI> deletedFiles = new ArrayList<URI>();
    private List<IResourceDescription.Delta> externalDeltas = new ArrayList<IResourceDescription.Delta>();
    private XIPostValidationCallback afterValidate = new XDefaultValidationCallback();
    private Procedures.Procedure2<? super URI, ? super URI> afterGenerateFile = (source, generated) -> {};
    private Procedures.Procedure1<? super URI> afterDeleteFile = file -> {};
    private XIndexState state = new XIndexState();
    private boolean writeStorageResources = false;
    private boolean indexOnly = false;
    private XtextResourceSet resourceSet;
    private CancelIndicator cancelIndicator = CancelIndicator.NullImpl;

    public void setBaseDir(URI baseDir) {
        this.baseDir = baseDir;
    }

    public URI getBaseDir() {
        if (this.baseDir == null) {
            String userDir = System.getProperty("user.dir");
            this.baseDir = UriUtil.createFolderURI((File)new File(userDir));
        }
        return this.baseDir;
    }

    public List<URI> getDirtyFiles() {
        return this.dirtyFiles;
    }

    public void setDirtyFiles(List<URI> dirtyFiles) {
        this.dirtyFiles = dirtyFiles;
    }

    public List<URI> getDeletedFiles() {
        return this.deletedFiles;
    }

    public void setDeletedFiles(List<URI> deletedFiles) {
        this.deletedFiles = deletedFiles;
    }

    public List<IResourceDescription.Delta> getExternalDeltas() {
        return this.externalDeltas;
    }

    public void setExternalDeltas(List<IResourceDescription.Delta> externalDeltas) {
        this.externalDeltas = externalDeltas;
    }

    public XIPostValidationCallback getAfterValidate() {
        return this.afterValidate;
    }

    public void setAfterValidate(XIPostValidationCallback afterValidate) {
        this.afterValidate = afterValidate;
    }

    public Procedures.Procedure2<? super URI, ? super URI> getAfterGenerateFile() {
        return this.afterGenerateFile;
    }

    public void setAfterGenerateFile(Procedures.Procedure2<? super URI, ? super URI> afterGenerateFile) {
        this.afterGenerateFile = afterGenerateFile;
    }

    public Procedures.Procedure1<? super URI> getAfterDeleteFile() {
        return this.afterDeleteFile;
    }

    public void setAfterDeleteFile(Procedures.Procedure1<? super URI> afterDeleteFile) {
        this.afterDeleteFile = afterDeleteFile;
    }

    public XIndexState getState() {
        return this.state;
    }

    public void setState(XIndexState state) {
        this.state = state;
    }

    public boolean isWriteStorageResources() {
        return this.writeStorageResources;
    }

    public void setWriteStorageResources(boolean writeStorageResources) {
        this.writeStorageResources = writeStorageResources;
    }

    public boolean isIndexOnly() {
        return this.indexOnly;
    }

    public void setIndexOnly(boolean indexOnly) {
        this.indexOnly = indexOnly;
    }

    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setResourceSet(XtextResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public CancelIndicator getCancelIndicator() {
        return this.cancelIndicator;
    }

    public void setCancelIndicator(CancelIndicator cancelIndicator) {
        this.cancelIndicator = cancelIndicator;
    }

    private static class XDefaultValidationCallback
    implements XIPostValidationCallback {
        private static final Logger LOG = Logger.getLogger(XDefaultValidationCallback.class);

        private XDefaultValidationCallback() {
        }

        @Override
        public boolean afterValidate(URI validated, Iterable<Issue> issues) {
            for (Issue issue : issues) {
                Severity severity = issue.getSeverity();
                if (severity == null) continue;
                switch (severity) {
                    case ERROR: {
                        LOG.error((Object)issue.toString());
                        return false;
                    }
                    case WARNING: {
                        LOG.warn((Object)issue.toString());
                        break;
                    }
                    case INFO: {
                        LOG.info((Object)issue.toString());
                        break;
                    }
                    case IGNORE: {
                        LOG.debug((Object)issue.toString());
                    }
                }
            }
            return true;
        }
    }

    public static interface XIPostValidationCallback {
        public boolean afterValidate(URI var1, Iterable<Issue> var2);
    }
}

