/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Stack;

public class RecursionGuard<T> {
    private Item<T> head;
    private final Equivalence<? super T> equivalence;

    public RecursionGuard() {
        this(Equivalence.identity());
    }

    public RecursionGuard(Equivalence<? super T> equivalence) {
        this.equivalence = (Equivalence)Preconditions.checkNotNull(equivalence, (Object)"equivalence");
    }

    public boolean tryNext(T element) {
        Item<T> item = this.head;
        while (item != null) {
            if (this.equivalent(item.element, element)) {
                return false;
            }
            item = item.next;
        }
        Item newHead = new Item();
        newHead.element = element;
        newHead.next = this.head;
        this.head = newHead;
        return true;
    }

    public void done(T element) {
        Item<T> item = this.head;
        Item<T> prev = null;
        while (item != null) {
            if (this.equivalent(item.element, element)) {
                if (prev == null) {
                    this.head = item.next;
                } else {
                    prev.next = item.next;
                }
                return;
            }
            prev = item;
            item = item.next;
        }
        throw new IllegalStateException("Element not found: " + element);
    }

    public Stack<T> getElements() {
        Stack result = new Stack();
        Item<T> item = this.head;
        while (item != null) {
            result.push(item.element);
            item = item.next;
        }
        Collections.reverse(result);
        return result;
    }

    protected boolean equivalent(T left, T right) {
        return this.equivalence.equivalent(left, right);
    }

    private static class Item<T> {
        T element;
        Item<T> next;

        private Item() {
        }
    }
}

