/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.binaries;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.IllegalBinaryStateException;
import org.eclipse.n4js.ui.binaries.BinariesPreferencePage;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class IllegalBinaryStateDialog
extends MessageDialog {
    private static final int TEXT_HEIGHT_HINT = 50;
    private static final int TEXT_WIDTH_HINT = 450;
    private static final String[] BUTTON_LABELS = new String[]{IDialogConstants.OK_LABEL};
    private static final String[] FILTER_IDS = new String[]{BinariesPreferencePage.ID};
    private final IllegalBinaryStateException cause;

    public IllegalBinaryStateDialog(IllegalBinaryStateException cause) {
        this(cause, String.valueOf(cause.getBinary().getLabel()) + " Configuration Error", cause.getMessage());
    }

    protected IllegalBinaryStateDialog(IllegalBinaryStateException cause, String title, String message) {
        super(UIUtils.getShell(), title, null, message, 1, BUTTON_LABELS, 0);
        this.cause = cause;
    }

    protected Control createCustomArea(Composite parent) {
        return IllegalBinaryStateDialog.createCustomAreaWithLink(parent, (Dialog)this, this.cause.getBinary());
    }

    public static Control createCustomAreaWithLink(Composite parent, final Dialog dialog, Binary binary) {
        String binaryLabel = binary.getLabel();
        String prefix = "The requested operation cannot be performed due to invalid '" + binaryLabel + "' settings. Check your '" + binaryLabel + "' configuration and preferences under the corresponding ";
        String link = "preference page";
        String suffix = ".";
        String text = String.valueOf(prefix) + "preference page" + ".";
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridData gridData = GridDataFactory.fillDefaults().align(16384, 128).grab(true, true).create();
        control.setLayoutData((Object)gridData);
        StyleRange style = new StyleRange();
        style.underline = true;
        style.underlineStyle = 4;
        final StyledText styledText = new StyledText(control, 74);
        styledText.setWordWrap(true);
        styledText.setJustify(true);
        styledText.setText(text);
        GridData textGridData = GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create();
        textGridData.widthHint = 450;
        textGridData.heightHint = 50;
        styledText.setLayoutData((Object)textGridData);
        styledText.setEditable(false);
        styledText.setBackground(UIUtils.getSystemColor(22));
        int[] ranges = new int[]{text.indexOf("preference page"), "preference page".length()};
        StyleRange[] styles = new StyleRange[]{style};
        styledText.setStyleRanges(ranges, styles);
        styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                try {
                    StyleRange actualStyle;
                    int offset = styledText.getOffsetAtPoint(new Point(event.x, event.y));
                    StyleRange styleRange = actualStyle = offset >= 0 ? styledText.getStyleRangeAtOffset(offset) : null;
                    if (actualStyle != null && actualStyle.underline && 4 == actualStyle.underlineStyle) {
                        dialog.close();
                        PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)UIUtils.getShell(), (String)BinariesPreferencePage.ID, (String[])FILTER_IDS, null);
                        if (preferenceDialog != null) {
                            preferenceDialog.open();
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        return control;
    }
}

