/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import java.util.TreeSet;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FlowEdge;
import org.eclipse.n4js.flowgraphs.analysis.IPathWalker;
import org.eclipse.n4js.flowgraphs.analysis.IPathWalkerInternal;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class PathWalkerGuide
implements IPathWalkerInternal {
    final IPathWalker walker;
    final TreeSet<ControlFlowType> cfTypes = new TreeSet();
    private Node lastVisitedNode = null;

    public PathWalkerGuide(IPathWalker walker) {
        this.walker = walker;
    }

    @Override
    public void visitNode(Node node) {
        if (node instanceof RepresentingNode) {
            ControlFlowElement cfeEnd = node.getRepresentedControlFlowElement();
            if (this.lastVisitedNode != null) {
                ControlFlowElement cfeStart = this.lastVisitedNode.getRepresentedControlFlowElement();
                FlowEdge edge = new FlowEdge(cfeStart, cfeEnd, this.cfTypes);
                this.walker.visit(edge);
            }
            this.cfTypes.clear();
            this.walker.visit(cfeEnd);
            this.lastVisitedNode = node;
        }
    }

    @Override
    public void visitEdge(Node start, Node end, ControlFlowEdge edge) {
        this.cfTypes.add(edge.cfType);
    }

    @Override
    public void init() {
    }

    @Override
    public void finish() {
    }
}

