/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.components;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.n4js.ui.wizard.components.WizardComponent;
import org.eclipse.n4js.ui.wizard.components.WizardComponentContainer;
import org.eclipse.n4js.ui.wizard.components.WizardComponentUtils;
import org.eclipse.n4js.ui.wizard.model.AccessModifiableModel;
import org.eclipse.n4js.ui.wizard.model.AccessModifier;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class AccessModifierComponent
extends WizardComponent {
    private final Button privateAccessModifierBox;
    private final Button projectAccessModifierBox;
    private final Button internalAnnotationBox;
    private final Button publicAccessModifierBox;
    private final AccessModifiableModel model;
    private final DataBindingContext dataBindingContext;
    private final WizardComponentContainer componentContainer;

    public AccessModifierComponent(AccessModifiableModel model, WizardComponentContainer container) {
        super(container);
        this.model = model;
        this.componentContainer = container;
        this.dataBindingContext = container.getDataBindingContext();
        Label accessModifierLabel = new Label(this.componentContainer.getComposite(), 0);
        accessModifierLabel.setLayoutData((Object)WizardComponentUtils.fillLabelDefaults());
        accessModifierLabel.setText("Access modifier:");
        Composite accessModifiersComposite = new Composite(this.componentContainer.getComposite(), 0);
        accessModifiersComposite.setLayout((Layout)RowLayoutFactory.swtDefaults().extendedMargins(0, 0, 0, 0).create());
        GridData accessModifiersCompositeLayoutData = WizardComponentUtils.fillTextDefaults();
        accessModifiersCompositeLayoutData.horizontalSpan = 2;
        accessModifiersComposite.setLayoutData((Object)accessModifiersCompositeLayoutData);
        this.publicAccessModifierBox = new Button(accessModifiersComposite, 16);
        this.publicAccessModifierBox.setText("public");
        this.projectAccessModifierBox = new Button(accessModifiersComposite, 16);
        this.projectAccessModifierBox.setText("project");
        this.privateAccessModifierBox = new Button(accessModifiersComposite, 16);
        this.privateAccessModifierBox.setText("private");
        this.internalAnnotationBox = new Button(accessModifiersComposite, 32);
        this.getInternalAnnotationBox().setText("@Internal");
        this.setupBindings();
    }

    private void setupBindings() {
        ISWTObservableValue publicButtonSelection = WidgetProperties.buttonSelection().observe((Widget)this.publicAccessModifierBox);
        ISWTObservableValue projectButtonSelection = WidgetProperties.buttonSelection().observe((Widget)this.projectAccessModifierBox);
        ISWTObservableValue privateButtonSelection = WidgetProperties.buttonSelection().observe((Widget)this.privateAccessModifierBox);
        SelectObservableValue accessModifierSelectObservable = new SelectObservableValue();
        accessModifierSelectObservable.addOption((Object)AccessModifier.PUBLIC, (IObservableValue)publicButtonSelection);
        accessModifierSelectObservable.addOption((Object)AccessModifier.PROJECT, (IObservableValue)projectButtonSelection);
        accessModifierSelectObservable.addOption((Object)AccessModifier.PRIVATE, (IObservableValue)privateButtonSelection);
        IObservableValue accessModifierProperty = BeanProperties.value(AccessModifiableModel.class, (String)"accessModifier", AccessModifier.class).observe((Object)this.model);
        this.dataBindingContext.bindValue((IObservableValue)accessModifierSelectObservable, accessModifierProperty);
        IObservableValue internalValue = BeanProperties.value(AccessModifiableModel.class, (String)"internal", Boolean.class).observe((Object)this.model);
        ISWTObservableValue internalUI = WidgetProperties.buttonSelection().observe((Widget)this.getInternalAnnotationBox());
        this.dataBindingContext.bindValue((IObservableValue)internalUI, internalValue);
    }

    public Button getInternalAnnotationBox() {
        return this.internalAnnotationBox;
    }

    @Override
    public void setFocus() {
        this.publicAccessModifierBox.setFocus();
    }
}

