/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.AccessibleTypeElement;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

class N4JSVariableStatementTypesBuilder {
    @Inject
    @Extension
    private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;

    N4JSVariableStatementTypesBuilder() {
    }

    int relinkVariableTypes(VariableStatement n4VariableStatement, TModule target, boolean preLinkingPhase, int start) {
        Functions.Function2 _function = (idx, decl) -> {
            boolean _relinkVariableType = this.relinkVariableType((ExportedVariableDeclaration)decl, target, (int)idx);
            if (_relinkVariableType) {
                return idx + 1;
            }
            return idx;
        };
        return (Integer)IterableExtensions.fold((Iterable)Iterables.filter((Iterable)n4VariableStatement.getVarDecl(), ExportedVariableDeclaration.class), (Object)start, (Functions.Function2)_function);
    }

    private boolean relinkVariableType(ExportedVariableDeclaration n4VariableDeclaration, TModule target, int idx) {
        boolean _tripleEquals;
        String _name = n4VariableDeclaration.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return false;
        }
        TVariable variable = (TVariable)target.getVariables().get(idx);
        this._n4JSTypesBuilderHelper.ensureEqualName((NamedElement)n4VariableDeclaration, (IdentifiableElement)variable);
        variable.setAstElement((EObject)n4VariableDeclaration);
        n4VariableDeclaration.setDefinedVariable(variable);
        return true;
    }

    void createVariableTypes(VariableStatement n4VariableStatement, TModule target, boolean preLinkingPhase) {
        Iterable<TVariable> variables = this.createVariables(n4VariableStatement, preLinkingPhase);
        EList _variables = target.getVariables();
        Iterables.addAll((Collection)_variables, variables);
    }

    private Iterable<TVariable> createVariables(VariableStatement n4VariableStatement, boolean preLinkingPhase) {
        Functions.Function1 _function = it -> this.createVariable((ExportedVariableDeclaration)it, n4VariableStatement, preLinkingPhase);
        return IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)n4VariableStatement.getVarDecl(), ExportedVariableDeclaration.class), (Functions.Function1)_function));
    }

    private TVariable createVariable(ExportedVariableDeclaration n4VariableDeclaration, VariableStatement n4VariableStatement, boolean preLinkingPhase) {
        boolean _tripleEquals;
        String _name = n4VariableDeclaration.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return null;
        }
        TVariable variable = TypesFactory.eINSTANCE.createTVariable();
        variable.setName(n4VariableDeclaration.getName());
        variable.setConst(n4VariableDeclaration.isConst());
        Expression _expression = n4VariableDeclaration.getExpression();
        variable.setObjectLiteral(_expression instanceof ObjectLiteral);
        Expression _expression_1 = n4VariableDeclaration.getExpression();
        variable.setNewExpression(_expression_1 instanceof NewExpression);
        if (n4VariableStatement instanceof ExportedVariableStatement) {
            String _name_1;
            String _elvis = null;
            String _exportedName = ((ExportedVariableStatement)n4VariableStatement).getExportedName();
            _elvis = _exportedName != null ? _exportedName : (_name_1 = n4VariableDeclaration.getName());
            variable.setExportedName(_elvis);
            this._n4JSTypesBuilderHelper.setTypeAccessModifier((AccessibleTypeElement)variable, (ExportedVariableStatement)n4VariableStatement);
        } else {
            variable.setExportedName(null);
        }
        this._n4JSTypesBuilderHelper.copyAnnotations((TAnnotableElement)variable, (AnnotableElement)n4VariableDeclaration, preLinkingPhase);
        variable.setDeclaredProvidedByRuntime(AnnotationDefinition.PROVIDED_BY_RUNTIME.hasAnnotation((AnnotableElement)n4VariableDeclaration));
        this.setVariableType(variable, n4VariableDeclaration, preLinkingPhase);
        variable.setAstElement((EObject)n4VariableDeclaration);
        n4VariableDeclaration.setDefinedVariable(variable);
        return variable;
    }

    private void setVariableType(TVariable variable, ExportedVariableDeclaration n4VariableDeclaration, boolean preLinkingPhase) {
        boolean _tripleNotEquals;
        TypeRef _declaredTypeRef = n4VariableDeclaration.getDeclaredTypeRef();
        boolean bl = _tripleNotEquals = _declaredTypeRef != null;
        if (_tripleNotEquals) {
            if (!preLinkingPhase) {
                variable.setTypeRef((TypeRef)TypeUtils.copyWithProxies((EObject)n4VariableDeclaration.getDeclaredTypeRef()));
            }
        } else {
            variable.setTypeRef((TypeRef)TypeUtils.createDeferredTypeRef());
        }
    }
}

