/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TypingStrategy implements Enumerator
{
    DEFAULT(0, "default", "?~"),
    NOMINAL(1, "nominal", ""),
    STRUCTURAL(2, "structural", "~"),
    STRUCTURAL_FIELDS(3, "structuralFields", "~~"),
    STRUCTURAL_READ_ONLY_FIELDS(4, "structuralReadOnlyFields", "~r~"),
    STRUCTURAL_WRITE_ONLY_FIELDS(5, "structuralWriteOnlyFields", "~w~"),
    STRUCTURAL_FIELD_INITIALIZER(6, "structuralFieldInitializer", "~i~"),
    EMPTY(-1, "empty", "~\u2205~");

    public static final int DEFAULT_VALUE = 0;
    public static final int NOMINAL_VALUE = 1;
    public static final int STRUCTURAL_VALUE = 2;
    public static final int STRUCTURAL_FIELDS_VALUE = 3;
    public static final int STRUCTURAL_READ_ONLY_FIELDS_VALUE = 4;
    public static final int STRUCTURAL_WRITE_ONLY_FIELDS_VALUE = 5;
    public static final int STRUCTURAL_FIELD_INITIALIZER_VALUE = 6;
    public static final int EMPTY_VALUE = -1;
    private static final TypingStrategy[] VALUES_ARRAY;
    public static final List<TypingStrategy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TypingStrategy[]{DEFAULT, NOMINAL, STRUCTURAL, STRUCTURAL_FIELDS, STRUCTURAL_READ_ONLY_FIELDS, STRUCTURAL_WRITE_ONLY_FIELDS, STRUCTURAL_FIELD_INITIALIZER, EMPTY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TypingStrategy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypingStrategy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypingStrategy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypingStrategy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypingStrategy get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return NOMINAL;
            }
            case 2: {
                return STRUCTURAL;
            }
            case 3: {
                return STRUCTURAL_FIELDS;
            }
            case 4: {
                return STRUCTURAL_READ_ONLY_FIELDS;
            }
            case 5: {
                return STRUCTURAL_WRITE_ONLY_FIELDS;
            }
            case 6: {
                return STRUCTURAL_FIELD_INITIALIZER;
            }
            case -1: {
                return EMPTY;
            }
        }
        return null;
    }

    private TypingStrategy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

