/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.n4js.tester.TestConfiguration;
import org.eclipse.n4js.tester.TesterFrontEnd;
import org.eclipse.n4js.tester.domain.TestCase;

@Singleton
public class TestConfigurationConverter {
    @Inject
    private TesterFrontEnd testerFrontEnd;

    public TestConfiguration toTestConfiguration(ILaunchConfiguration launchConfig) {
        try {
            Map properties = launchConfig.getAttributes();
            properties.put("NAME", launchConfig.getName());
            TestConfiguration testConfig = this.testerFrontEnd.createConfiguration(properties);
            testConfig.setLaunchConfigurationTypeIdentifier(launchConfig.getType().getIdentifier());
            return testConfig;
        }
        catch (Exception e) {
            throw new WrappedException("could not convert Eclipse ILaunchConfiguration to N4JS TestConfiguration", e);
        }
    }

    public ILaunchConfiguration toLaunchConfiguration(ILaunchConfigurationType type, TestConfiguration testConfig, List<TestCase> failed) {
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (this.equals(testConfig, config)) {
                    return config;
                }
                ++n2;
            }
            IContainer container = null;
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(container, testConfig.getName());
            workingCopy.setAttributes(testConfig.readPersistentValues());
            if (failed != null && !failed.isEmpty()) {
                workingCopy.setAttribute("TESTCASE_SELECTION", failed.stream().map(tc -> {
                    String s = tc.getURI().toString();
                    return s;
                }).collect(Collectors.toList()));
            }
            return workingCopy.doSave();
        }
        catch (Exception e) {
            throw new WrappedException("could not convert N4JS TestConfiguration to Eclipse ILaunchConfiguration", e);
        }
    }

    private boolean equals(TestConfiguration testConfig, ILaunchConfiguration launchConfig) throws CoreException {
        return testConfig.getName().equals(launchConfig.getName()) && testConfig.readPersistentValues().equals(launchConfig.getAttributes());
    }
}

