/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.expectation.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.xpect.XpectArgument;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.CommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.ICommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.impl.AbstractExpectation;
import org.eclipse.xpect.expectation.impl.ActualCollection;
import org.eclipse.xpect.expectation.impl.ExpectationCollection;
import org.eclipse.xpect.expectation.impl.ExpectationRegionProvider;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.text.Text;
import org.eclipse.xpect.util.ReflectionUtil;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.junit.ComparisonFailure;

@XpectSetupFactory
@XpectImport(value={ExpectationRegionProvider.class})
public class CommaSeparatedValuesExpectationImpl
extends AbstractExpectation
implements ICommaSeparatedValuesExpectation {
    private final CommaSeparatedValuesExpectation annotation;
    private final ExpectationCollection expectationCollection;

    public CommaSeparatedValuesExpectationImpl(CommaSeparatedValuesExpectationImpl original, CommaSeparatedValuesExpectation config) {
        super(original.getArgument(), original.getTargetSyntax());
        this.annotation = config;
        this.expectationCollection = this.createExpectationCollection();
    }

    public CommaSeparatedValuesExpectationImpl(XpectArgument argument, TargetSyntaxSupport syntax) {
        super(argument, syntax);
        this.annotation = argument.getAnnotationOrDefault(CommaSeparatedValuesExpectation.class);
        this.expectationCollection = this.createExpectationCollection();
    }

    @Override
    public void assertEquals(Iterable<?> actual) {
        this.assertEquals(actual, null);
    }

    @Override
    public void assertEquals(Iterable<?> actual, Predicate<String> predicate) {
        ActualCollection act = new ActualCollection();
        act.setTargetLiteralSupport(this.getTargetSyntaxLiteral());
        act.setCaseSensitive(this.annotation.caseSensitive());
        act.setOrdered(this.annotation.ordered());
        act.setQuoted(this.annotation.quoted());
        act.setSeparator(',');
        act.setWhitespaceSensitive(this.annotation.whitespaceSensitive());
        act.setItemFormatter(ReflectionUtil.newInstanceUnchecked(this.annotation.itemFormatter()));
        if (actual != null && predicate != null) {
            if (this.expectationCollection.isWildcard()) {
                act.init(this.expectationCollection.applyPredicate(predicate));
            } else {
                act.init(actual);
            }
        } else if (predicate != null) {
            act.init(this.expectationCollection.applyPredicate(predicate));
        } else if (actual != null) {
            act.init(actual);
        } else {
            throw new NullPointerException();
        }
        String nl = new Text(this.getRegion().getDocument()).getNL();
        if (!this.expectationCollection.matches(act)) {
            StringBuilder expString = new StringBuilder();
            StringBuilder actString = new StringBuilder();
            boolean expWrap = false;
            boolean expEmpty = false;
            boolean actWrap = false;
            int lineLength = 0;
            int lineCount = 0;
            for (Pair<Collection<ExpectationCollection.ExpectationItem>, ActualCollection.ActualItem> pair : this.expectationCollection.map(act)) {
                String expItem = null;
                String actItem = null;
                if (pair.getFirst() != null && !((Collection)pair.getFirst()).isEmpty()) {
                    expItem = pair.getSecond() != null ? ((ActualCollection.ActualItem)pair.getSecond()).getEscaped() : ((ExpectationCollection.ExpectationItem)((Collection)pair.getFirst()).iterator().next()).getEscaped();
                } else if (pair.getSecond() != null) {
                    expItem = this.str(((ActualCollection.ActualItem)pair.getSecond()).getEscaped().length());
                }
                if (pair.getSecond() != null) {
                    boolean width;
                    actItem = ((ActualCollection.ActualItem)pair.getSecond()).getEscaped();
                    boolean count = this.annotation.maxItemsPerLine() > 0 && ++lineCount > this.annotation.maxItemsPerLine();
                    boolean bl = width = this.annotation.maxLineWidth() > 0 && (lineLength += actItem.length() + 2) > this.annotation.maxLineWidth();
                    if (count || width) {
                        actWrap = true;
                        expWrap = true;
                    }
                }
                if (expItem != null && expString.length() > 0) {
                    if (expWrap) {
                        expString.append(expEmpty ? nl : "," + nl);
                        expWrap = false;
                    } else {
                        expString.append(expEmpty ? "  " : ", ");
                    }
                }
                if (actItem != null && actString.length() > 0) {
                    if (actWrap) {
                        actString.append("," + nl);
                        actWrap = false;
                        lineCount = 0;
                        lineLength = 0;
                    } else {
                        actString.append(", ");
                    }
                }
                if (expItem != null) {
                    expString.append(expItem);
                    boolean bl = expEmpty = expItem.trim().length() == 0;
                }
                if (actItem == null) continue;
                actString.append(actItem);
            }
            String expDoc = this.replaceInDocument(expString.toString());
            String actDoc = this.replaceInDocument(actString.toString());
            throw new ComparisonFailure("", expDoc, actDoc);
        }
    }

    @Override
    public void assertEquals(Predicate<String> predicate) {
        this.assertEquals(null, predicate);
    }

    @Creates
    public ICommaSeparatedValuesExpectation create() {
        return this;
    }

    protected ExpectationCollection createExpectationCollection() {
        ExpectationCollection exp = new ExpectationCollection();
        exp.setCaseSensitive(this.annotation.caseSensitive());
        exp.setOrdered(this.annotation.ordered());
        exp.setQuoted(this.annotation.quoted());
        exp.setSeparator(',');
        exp.setWhitespaceSensitive(this.annotation.whitespaceSensitive());
        exp.init(this.getExpectation());
        return exp;
    }

    public CommaSeparatedValuesExpectation getAnnotation() {
        return this.annotation;
    }

    @Override
    public List<ICommaSeparatedValuesExpectation.Value> getExpectedValues() {
        ArrayList result = Lists.newArrayList();
        for (ExpectationCollection.ExpectationItem item : this.expectationCollection) {
            result.add(new ValueImpl(item));
        }
        return ImmutableList.copyOf((Collection)result);
    }

    protected String str(int length) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < length) {
            b.append(" ");
            ++i;
        }
        return b.toString();
    }

    protected static class ValueImpl
    implements ICommaSeparatedValuesExpectation.Value {
        private final ExpectationCollection.ExpectationItem delegate;

        public ValueImpl(ExpectationCollection.ExpectationItem delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getText() {
            return this.delegate.getPure();
        }

        @Override
        public boolean isNegated() {
            return this.delegate.isNegated();
        }

        @Override
        public boolean isWildcard() {
            return this.delegate.isWildcard();
        }

        public String toString() {
            ToStringBuilder helper = new ToStringBuilder((Object)this).add("text", (Object)this.getText()).add("negated", (Object)this.isNegated()).add("wildcard", (Object)this.isWildcard());
            return helper.toString();
        }
    }
}

