/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.expectation.impl;

import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.parameter.IStatementRelatedRegion;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.text.IReplacement;

public class TargetSyntaxSupport {
    public boolean supportsMultiLineLiteral() {
        return false;
    }

    public TargetLiteralSupport getLiteralSupport(int offset) {
        return new TargetLiteralSupport();
    }

    public int findFirstSemanticCharAfterStatement(XpectInvocation statement) {
        int result;
        String text = statement.getFile().getDocument();
        do {
            IStatementRelatedRegion region = statement.getExtendedRegion();
            result = region.getOffset() + region.getLength();
            while (result < text.length() && Character.isWhitespace(text.charAt(result))) {
                ++result;
            }
        } while ((statement = statement.getFile().getInvocationAt(result)) != null && result < text.length());
        if (result < text.length()) {
            return result;
        }
        throw new RuntimeException("Reached end of the file before finding a value for OFFSET.");
    }

    @Creates
    public TargetSyntaxSupport create() {
        return this;
    }

    public static class TargetLiteralSupport {
        public String escape(String value) {
            return value;
        }

        public IReplacement adoptToTargetSyntax(IReplacement replacement, boolean enforceMultilineLiteral) {
            return replacement;
        }
    }
}

