/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.hlc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.n4js.hlc.MainBundleConstants;
import org.eclipse.n4js.hlc.ThreadsUtil;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ProductLauncher {
    private static boolean DEBUG = false;
    private static final String BUNDLE_INSTALL_SCHEME = "reference:file:/";
    private static final String EQUINOX_THREAD_DESCRIPTION_TOKEN = "equinox";

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            args = new String[]{};
        }
        String[] platformArgs = new String[]{};
        String[] appCallArgs = args;
        List<String> bundlesToInstall = ProductLauncher.getInstallableBundlesNames("/plugins-list.txt", " ");
        if (bundlesToInstall.isEmpty()) {
            throw new RuntimeException("No bundles to load discovered");
        }
        Path osgiConfigurationArea = Files.createTempDirectory(".n4jsc", new FileAttribute[0]);
        if (!osgiConfigurationArea.toFile().exists()) {
            throw new RuntimeException("Cannot obtain working directory");
        }
        try {
            BundleContext context = ProductLauncher.startPlatform(platformArgs, osgiConfigurationArea);
            Set<String> installedBundleDescriptions = ProductLauncher.preLaodedBundlesNamePtterns(context);
            ProductLauncher.log("start install bundles");
            for (String bundle : bundlesToInstall) {
                if (ProductLauncher.isBundleLoaded(bundle, installedBundleDescriptions)) {
                    ProductLauncher.log("SKIP INSTALL  " + bundle);
                    continue;
                }
                InputStream bndInputStream = ProductLauncher.getResourceAsStream(bundle);
                Objects.requireNonNull(bndInputStream, "Cannot obtain resource for bundle " + bundle);
                String loc = BUNDLE_INSTALL_SCHEME + bundle;
                ProductLauncher.log("INSTALL " + loc);
                context.installBundle(loc, bndInputStream);
                bndInputStream.close();
            }
            ProductLauncher.log("load bundle and invoke its method");
            ProductLauncher.invoke(context, ProductLauncher.findBundle(context, MainBundleConstants.MAIN_BUNDLE_NAME_PATTERN), MainBundleConstants.MAIN_BUNDLE_CLASS_FQN, "main", appCallArgs);
            ProductLauncher.log("invocation finished");
            ProductLauncher.shutdownPlatform();
        }
        finally {
            ProductLauncher.log("finally");
            String errors = "";
            ProductLauncher.cleanupWorkArea(osgiConfigurationArea);
            if (osgiConfigurationArea.toFile().exists()) {
                errors = String.valueOf(errors) + "ERROR: Cannot cleanup working area : " + osgiConfigurationArea.toString() + "\n";
            }
            ProductLauncher.cleanupThreads();
            if (ThreadsUtil.getIdentifiedThredsCount(EQUINOX_THREAD_DESCRIPTION_TOKEN) > 0) {
                errors = String.valueOf(errors) + "ERROR: There are still platform threads running:\n" + ThreadsUtil.getThreadsInfo(EQUINOX_THREAD_DESCRIPTION_TOKEN);
            }
            if (!errors.isEmpty()) {
                System.err.println(errors);
            }
        }
    }

    private static void cleanupThreads() {
        if (ThreadsUtil.getIdentifiedThredsCount(EQUINOX_THREAD_DESCRIPTION_TOKEN) > 0) {
            ProductLauncher.log("There are still platform threads running:\n" + ThreadsUtil.getThreadsInfo(EQUINOX_THREAD_DESCRIPTION_TOKEN));
            try {
                ProductLauncher.shutdownPlatform();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void cleanupWorkArea(Path path) {
        ProductLauncher.log("working area exists : " + path.toFile().exists());
        try {
            FileDeleter.delete((Path)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static BundleContext startPlatform(String[] platformArgs, Path osgiConfigurationArea) throws Exception {
        HashMap<String, String> ip = new HashMap<String, String>();
        ip.put("eclipse.ignoreApp", "true");
        ip.put("eclipse.consoleLog", "true");
        ip.put("eclipse.log.level", "ALL");
        ip.put("osgi.clean", "true");
        ip.put("osgi.framework.shape", "jar");
        ip.put("osgi.configuration.area", osgiConfigurationArea.toAbsolutePath().toString());
        ip.put("osgi.noShutdown", "false");
        EclipseStarter.setInitialProperties(ip);
        BundleContext context = EclipseStarter.startup((String[])platformArgs, null);
        return context;
    }

    private static void shutdownPlatform() throws Exception {
        EclipseStarter.shutdown();
    }

    private static long findBundle(BundleContext context, String namePattern) {
        Bundle[] installedBundles = context.getBundles();
        int i = 0;
        while (i < installedBundles.length) {
            Bundle bundle = installedBundles[i];
            if (bundle.getSymbolicName().matches(namePattern)) {
                return bundle.getBundleId();
            }
            ++i;
        }
        throw new RuntimeException("Cannot locate bundle with name pattern " + namePattern);
    }

    private static Object invoke(BundleContext context, long bundleID, String classFqn, String methodToInvoke, String[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Bundle appBundle = context.getBundle(bundleID);
        Class appClass = appBundle.loadClass(classFqn);
        Method method = appClass.getMethod(methodToInvoke, args.getClass());
        return method.invoke(null, new Object[]{args});
    }

    private static Set<String> preLaodedBundlesNamePtterns(BundleContext context) {
        HashSet<String> installedBundleDescriptions = new HashSet<String>();
        Bundle[] installed0 = context.getBundles();
        int i = 0;
        while (i < installed0.length) {
            String descriptor = String.valueOf(installed0[i].getSymbolicName()) + ".*";
            installedBundleDescriptions.add(descriptor);
            ++i;
        }
        return installedBundleDescriptions;
    }

    private static boolean isBundleLoaded(String bundleName, Set<String> preloadeBundlePatternNames) {
        for (String pattern : preloadeBundlePatternNames) {
            if (!bundleName.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    private static void log(String msg) {
        if (DEBUG) {
            System.out.println(String.valueOf(new SimpleDateFormat("HH:mm:ss:SSS").format(new Date())) + " " + msg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getInstallableBundlesNames(String path, String separator) {
        ArrayList<String> filenames = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                InputStream in = ProductLauncher.getResourceAsStream(path);
                try {
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                        String resource;
                        while ((resource = br.readLine()) != null) {
                            filenames.addAll(Arrays.asList(resource.split(separator)));
                        }
                    }
                    if (in == null) return filenames;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return filenames;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filenames;
    }

    private static InputStream getResourceAsStream(String resource) {
        InputStream in = ProductLauncher.getContextClassLoader().getResourceAsStream(resource);
        return in == null ? ProductLauncher.class.getResourceAsStream(resource) : in;
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

