/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.model.utils;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONBooleanLiteral;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONFactory;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.n4js.utils.languages.N4LanguageUtils;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;

public class JSONModelUtils {
    public static final String FILE_EXTENSION = "json";

    public static boolean asBooleanOrFalse(JSONValue jsonValue) {
        return jsonValue instanceof JSONBooleanLiteral ? ((JSONBooleanLiteral)jsonValue).isBooleanValue() : false;
    }

    public static String asStringOrNull(JSONValue jsonValue) {
        return jsonValue instanceof JSONStringLiteral ? ((JSONStringLiteral)jsonValue).getValue() : null;
    }

    public static List<String> asStringsInArrayOrEmpty(JSONValue jsonValue) {
        return JSONModelUtils.asArrayElementsOrEmpty(jsonValue).stream().map(JSONModelUtils::asStringOrNull).filter(str -> !Strings.isNullOrEmpty((String)str)).collect(Collectors.toList());
    }

    public static String asNonEmptyStringOrNull(JSONValue jsonValue) {
        String strValue;
        String string = strValue = jsonValue instanceof JSONStringLiteral ? ((JSONStringLiteral)jsonValue).getValue() : null;
        if (Strings.isNullOrEmpty((String)strValue)) {
            return null;
        }
        return strValue;
    }

    public static List<String> asNonEmptyStringsInArrayOrEmpty(JSONValue jsonValue) {
        return JSONModelUtils.asArrayElementsOrEmpty(jsonValue).stream().map(JSONModelUtils::asNonEmptyStringOrNull).filter(str -> !Strings.isNullOrEmpty((String)str)).collect(Collectors.toList());
    }

    public static List<JSONValue> asArrayElementsOrEmpty(JSONValue jsonValue) {
        return jsonValue instanceof JSONArray ? ((JSONArray)jsonValue).getElements() : Collections.emptyList();
    }

    public static List<NameValuePair> asNameValuePairsOrEmpty(JSONValue jsonValue) {
        return jsonValue instanceof JSONObject ? ((JSONObject)jsonValue).getNameValuePairs() : Collections.emptyList();
    }

    public static JSONDocument getDocument(Resource resource) {
        if (resource.getContents().isEmpty()) {
            throw new IllegalArgumentException("The given empty resource is not a valid JSON resource (URI=" + resource.getURI() + ").");
        }
        EObject firstSlot = (EObject)resource.getContents().get(0);
        if (!(firstSlot instanceof JSONDocument)) {
            throw new IllegalArgumentException("The given resource is not a valid JSON resource (URI=" + resource.getURI() + ").");
        }
        return (JSONDocument)firstSlot;
    }

    public static <T extends JSONValue> T getContent(Resource resource, Class<T> expectedType) {
        return JSONModelUtils.getContent(JSONModelUtils.getDocument(resource), expectedType);
    }

    public static <T extends JSONValue> T getContent(JSONDocument document, Class<T> expectedType) {
        JSONValue content = document.getContent();
        if (content != null && expectedType.isInstance(content)) {
            JSONValue contentCasted = content;
            return (T)contentCasted;
        }
        return null;
    }

    public static Optional<JSONValue> getPath(JSONDocument document, List<String> path) {
        JSONValue content = document.getContent();
        if (content instanceof JSONObject) {
            return JSONModelUtils.getPath((JSONObject)content, path);
        }
        return Optional.empty();
    }

    public static Optional<JSONValue> getPath(JSONObject object, List<String> path) {
        if (path.isEmpty()) {
            return Optional.empty();
        }
        String currentProperty = path.get(0);
        JSONValue propertyValue = JSONModelUtils.getProperty(object, currentProperty).orElse(null);
        if (propertyValue == null) {
            return Optional.empty();
        }
        if (path.size() == 1) {
            return Optional.ofNullable(propertyValue);
        }
        if (!(propertyValue instanceof JSONObject)) {
            return Optional.empty();
        }
        JSONObject targetObject = (JSONObject)propertyValue;
        return JSONModelUtils.getPath(targetObject, path.subList(1, path.size()));
    }

    public static JSONStringLiteral setPath(JSONObject object, String path, String value) {
        return JSONModelUtils.setPath(object, Arrays.asList(path.split("\\.")), JSONModelUtils.createStringLiteral(value));
    }

    public static <V extends JSONValue> V setPath(JSONObject object, String path, V value) {
        return JSONModelUtils.setPath(object, Arrays.asList(path.split("\\.")), value);
    }

    public static <V extends JSONValue> V setPath(JSONObject object, List<String> path, V value) {
        try {
            return JSONModelUtils.setPath(object, path, path, value);
        }
        catch (JSONPropertyPathException e) {
            throw new JSONPropertyPathException("Failed to resolve JSON property path " + path, e);
        }
    }

    private static <V extends JSONValue> V setPath(JSONObject object, List<String> currentPath, List<String> fullPath, V value) {
        if (currentPath.size() == 0) {
            return null;
        }
        String currentProperty = currentPath.get(0);
        int pathLength = currentPath.size();
        if (pathLength == 1) {
            JSONModelUtils.setProperty(object, currentProperty, value);
            return value;
        }
        Optional<NameValuePair> pair = object.getNameValuePairs().stream().filter(p -> p.getName().equals(currentProperty)).findAny();
        if (pair.isPresent()) {
            JSONValue pathValue = pair.get().getValue();
            if (!(pathValue instanceof JSONObject)) {
                throw new JSONPropertyPathException("Cannot resolve JSON property path further then " + fullPath.subList(0, fullPath.size() - pathLength).stream().collect(Collectors.joining(".")) + ". " + pathValue + " is not a JSONObject.", null);
            }
            return JSONModelUtils.setPath((JSONObject)pathValue, currentPath.subList(1, pathLength), fullPath, value);
        }
        JSONObject nextObject = JSONModelUtils.addProperty(object, currentProperty, JSONFactory.eINSTANCE.createJSONObject());
        return JSONModelUtils.setPath(nextObject, currentPath.subList(1, pathLength), fullPath, value);
    }

    public static Optional<JSONValue> getProperty(JSONDocument document, String property) {
        JSONValue content = document.getContent();
        if (content instanceof JSONObject) {
            return JSONModelUtils.getProperty((JSONObject)content, property);
        }
        return Optional.empty();
    }

    public static String getPropertyAsStringOrNull(JSONObject object, String property) {
        return JSONModelUtils.asStringOrNull(JSONModelUtils.getProperty(object, property).orElse(null));
    }

    public static Optional<JSONValue> getProperty(JSONObject object, String property) {
        return object.getNameValuePairs().stream().filter(pair -> pair.getName().equals(property)).findFirst().map(pair -> pair.getValue());
    }

    public static <V extends JSONValue> V addProperty(JSONObject object, String name, V value) {
        NameValuePair nameValuePair = JSONFactory.eINSTANCE.createNameValuePair();
        nameValuePair.setName(name);
        nameValuePair.setValue(value);
        object.getNameValuePairs().add((Object)nameValuePair);
        return value;
    }

    public static <V extends JSONValue> V setProperty(JSONObject object, String name, V value) {
        Optional<NameValuePair> existingPair = object.getNameValuePairs().stream().filter(pair -> pair.getName().equals(name)).findAny();
        if (existingPair.isPresent()) {
            existingPair.get().setValue(value);
        } else {
            JSONModelUtils.addProperty(object, name, value);
        }
        return value;
    }

    public static JSONStringLiteral addProperty(JSONObject object, String name, String value) {
        return JSONModelUtils.addProperty(object, name, JSONModelUtils.createStringLiteral(value));
    }

    public static boolean removeProperty(JSONObject object, String name) {
        return object.getNameValuePairs().removeIf(pair -> name.equals(pair.getName()));
    }

    public static JSONStringLiteral setProperty(JSONObject object, String name, String value) {
        return JSONModelUtils.setProperty(object, name, JSONModelUtils.createStringLiteral(value));
    }

    public static Map<String, NameValuePair> getPropertiesAsMap(JSONObject object, boolean useLinked) {
        return object.getNameValuePairs().stream().collect(Collectors.toMap(pair -> pair.getName(), pair -> pair, (pair1, pair2) -> pair1, () -> useLinked ? new LinkedHashMap() : new HashMap()));
    }

    public static void merge(JSONDocument target, JSONDocument source, boolean copy, boolean recursive) {
        JSONValue targetContent = target.getContent();
        JSONValue sourceContent = source.getContent();
        if (sourceContent instanceof JSONObject && targetContent instanceof JSONObject) {
            JSONModelUtils.merge((JSONObject)targetContent, (JSONObject)sourceContent, copy, recursive);
        } else {
            target.setContent(copy ? (JSONValue)EcoreUtil.copy((EObject)sourceContent) : sourceContent);
        }
    }

    public static void merge(JSONObject target, JSONObject source, boolean copy, boolean recursive) {
        Map<String, NameValuePair> targetPairsPerName = JSONModelUtils.getPropertiesAsMap(target, true);
        for (NameValuePair sourcePair : source.getNameValuePairs()) {
            String sourcePairName = sourcePair.getName();
            JSONValue sourcePairValue = sourcePair.getValue();
            if (recursive && sourcePairValue instanceof JSONObject) {
                JSONValue targetPairValue;
                NameValuePair targetPair = targetPairsPerName.get(sourcePairName);
                JSONValue jSONValue = targetPairValue = targetPair != null ? targetPair.getValue() : null;
                if (targetPairValue instanceof JSONObject) {
                    JSONModelUtils.merge((JSONObject)targetPairValue, (JSONObject)sourcePairValue, copy, recursive);
                    continue;
                }
            }
            targetPairsPerName.put(sourcePairName, copy ? (NameValuePair)EcoreUtil.copy((EObject)sourcePair) : sourcePair);
        }
        EList<NameValuePair> targetList = target.getNameValuePairs();
        targetList.clear();
        targetList.addAll(targetPairsPerName.values());
    }

    public static JSONBooleanLiteral createBooleanLiteral(boolean value) {
        JSONBooleanLiteral literal = JSONFactory.eINSTANCE.createJSONBooleanLiteral();
        literal.setBooleanValue(value);
        return literal;
    }

    public static JSONStringLiteral createStringLiteral(String value) {
        JSONStringLiteral literal = JSONFactory.eINSTANCE.createJSONStringLiteral();
        literal.setValue(value);
        return literal;
    }

    public static JSONArray createArray(Collection<JSONValue> values) {
        JSONArray result = JSONFactory.eINSTANCE.createJSONArray();
        result.getElements().addAll(values);
        return result;
    }

    public static JSONArray createStringArray(Iterable<String> values) {
        JSONArray result = JSONFactory.eINSTANCE.createJSONArray();
        values.forEach(v -> {
            boolean bl = result.getElements().add((Object)JSONModelUtils.createStringLiteral(v));
        });
        return result;
    }

    public static JSONObject createObject(Map<String, JSONValue> properties) {
        JSONObject result = JSONFactory.eINSTANCE.createJSONObject();
        for (Map.Entry<String, JSONValue> entry : properties.entrySet()) {
            result.getNameValuePairs().add((Object)JSONModelUtils.createNameValuePair(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public static <K, V> JSONObject createObject(Map<K, V> properties, Function<K, String> fnKey, Function<V, JSONValue> fnValue) {
        JSONObject result = JSONFactory.eINSTANCE.createJSONObject();
        for (Map.Entry<K, V> entry : properties.entrySet()) {
            result.getNameValuePairs().add((Object)JSONModelUtils.createNameValuePair(fnKey.apply(entry.getKey()), fnValue.apply(entry.getValue())));
        }
        return result;
    }

    public static NameValuePair createNameValuePair(String name, JSONValue value) {
        NameValuePair result = JSONFactory.eINSTANCE.createNameValuePair();
        result.setName(name);
        result.setValue(value);
        return result;
    }

    public static JSONDocument createDocument(JSONValue content) {
        JSONDocument result = JSONFactory.eINSTANCE.createJSONDocument();
        result.setContent(content);
        return result;
    }

    public static JSONDocument loadJSON(Path path, Charset cs) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader in = Files.newBufferedReader(path, cs);){
            N4LanguageUtils.ParseResult result = N4LanguageUtils.parseXtextLanguage((String)FILE_EXTENSION, null, JSONDocument.class, (Reader)in);
            return result.errors.isEmpty() ? (JSONDocument)result.ast : null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static JSONDocument parseJSON(String jsonString) {
        N4LanguageUtils.ParseResult result = N4LanguageUtils.parseXtextLanguage((String)FILE_EXTENSION, JSONDocument.class, (String)jsonString);
        return result.errors.isEmpty() ? (JSONDocument)result.ast : null;
    }

    public static String serializeJSON(JSONValue value) {
        return JSONModelUtils.serializeJSON(JSONModelUtils.createDocument(value));
    }

    public static String serializeJSON(JSONDocument document) {
        ISerializer jsonSerializer = (ISerializer)N4LanguageUtils.getServiceForContext((String)FILE_EXTENSION, ISerializer.class).get();
        ResourceSet resourceSet = (ResourceSet)N4LanguageUtils.getServiceForContext((String)FILE_EXTENSION, ResourceSet.class).get();
        Resource temporaryResource = resourceSet.createResource(URIUtils.toFileUri((String)"__synthetic.json"));
        temporaryResource.getContents().add((Object)document);
        StringWriter writer = new StringWriter();
        SaveOptions serializerOptions = SaveOptions.newBuilder().format().getOptions();
        try {
            jsonSerializer.serialize((EObject)document, (Writer)writer, serializerOptions);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize JSONDocument " + document, e);
        }
    }

    public static final class JSONPropertyPathException
    extends RuntimeException {
        public JSONPropertyPathException(String message) {
            super(message);
        }

        public JSONPropertyPathException(String message, Exception exception) {
            super(message, exception);
        }
    }
}

