/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xpect.text.Canvas;
import org.eclipse.xpect.text.ICanvas;
import org.eclipse.xpect.text.ITextBlock;
import org.eclipse.xpect.text.TextBlock;

public class Table {
    protected static final int UNDEFINED = -1;
    private int border = 0;
    private ITextBlock columnSeparatorBackground = ITextBlock.EMPTY;
    private int columnSeparatorWidth = 1;
    private final Indexed2<CellHSeparator> idxCellHSeparators = new Indexed2<CellHSeparator>(new CellHSeparator.Provider());
    private final Indexed2<Cell> idxCells = new Indexed2<Cell>(new Cell.Provider());
    private final Indexed2<CellVSeparator> idxCellVSeparators = new Indexed2<CellVSeparator>(new CellVSeparator.Provider());
    private final Indexed1<Column> idxColumns = new Indexed1<Column>(new Column.Provider());
    private final Indexed1<ColumnSeparator> idxColumnSeparators = new Indexed1<ColumnSeparator>(new ColumnSeparator.Provider());
    private final Indexed1<Row> idxRows = new Indexed1<Row>(new Row.Provider());
    private final Indexed1<RowSeparator> idxRowSeparators = new Indexed1<RowSeparator>(new RowSeparator.Provider());
    private final Indexed2<SeparatorCrossing> idxSeparatorCrossings = new Indexed2<SeparatorCrossing>(new SeparatorCrossing.Provider());
    private int maxCellWidth = -1;
    private ITextBlock rowSeparatorBackground = ITextBlock.EMPTY;
    private int rowSeparatorHeight = 1;
    private ITextBlock separatorCrossingBackground = ITextBlock.EMPTY;

    public Column addColumn() {
        return this.getColumn(this.getColumnCount());
    }

    public Row addRow() {
        return this.getRow(this.getRowCount());
    }

    public int getBorder() {
        return this.border;
    }

    public RowSeparator getBottomBorder() {
        return this.idxRowSeparators.get(this.getRowCount());
    }

    public Cell getCell(int rowIndex, int colIndex) {
        return this.idxCells.get(rowIndex, colIndex);
    }

    public <T extends Cell> Cell getCell(int rowIndex, int colIndex, Provider2<T> provider) {
        return (Cell)this.idxCells.get(rowIndex, colIndex, provider);
    }

    public Column getColumn(int index) {
        return this.idxColumns.get(index);
    }

    public <T extends Column> T getColumn(int index, Provider1<T> provider) {
        return (T)((Column)this.idxColumns.get(index, provider));
    }

    public int getColumnCount() {
        return this.idxCells.getColumnCount();
    }

    public ITextBlock getColumnSeparatorBackground() {
        return this.columnSeparatorBackground;
    }

    public int getColumnSeparatorWidth() {
        return this.columnSeparatorWidth;
    }

    public ColumnSeparator getLeftBorder() {
        return this.idxColumnSeparators.get(0);
    }

    public int getMaxCellWidth() {
        return this.maxCellWidth;
    }

    public ColumnSeparator getRightBorder() {
        return this.idxColumnSeparators.get(this.getColumnCount());
    }

    public Row getRow(int index) {
        return this.idxRows.get(index);
    }

    public <T extends Row> T getRow(int index, Provider1<T> provider) {
        return (T)((Row)this.idxRows.get(index, provider));
    }

    public int getRowCount() {
        return this.idxCells.getRowCount();
    }

    public ITextBlock getRowSeparatorBackground() {
        return this.rowSeparatorBackground;
    }

    public int getRowSeparatorHeight() {
        return this.rowSeparatorHeight;
    }

    public ITextBlock getSeparatorCrossingBackground() {
        return this.separatorCrossingBackground;
    }

    public RowSeparator getTopBorder() {
        return this.idxRowSeparators.get(0);
    }

    public void paint(ICanvas canvas) {
        int cols = this.getColumnCount();
        int rows = this.getRowCount();
        ArrayList columnWidths = Lists.newArrayList();
        int col = 0;
        while (col < cols) {
            columnWidths.add(this.idxColumns.get(col).getWidth());
            ++col;
        }
        ArrayList columnSeparatorWidths = Lists.newArrayList();
        int col2 = 0;
        while (col2 <= cols) {
            columnSeparatorWidths.add(this.idxColumnSeparators.get(col2).getWidth());
            ++col2;
        }
        int top = 0;
        int row = 0;
        while (row <= rows) {
            int width;
            int col3;
            int left;
            int height = this.idxRowSeparators.get(row).getHeight();
            if (height > 0) {
                left = 0;
                col3 = 0;
                while (col3 <= cols) {
                    width = (Integer)columnSeparatorWidths.get(col3);
                    if (width > 0) {
                        this.idxSeparatorCrossings.get(row, col3).paint(canvas.at(top, left).withBounds(height, width).newSubCanvas());
                        left += width;
                    }
                    if (col3 < cols && (width = ((Integer)columnWidths.get(col3)).intValue()) > 0) {
                        this.idxCellHSeparators.get(row, col3).paint(canvas.at(top, left).withBounds(height, width).newSubCanvas());
                        left += width;
                    }
                    ++col3;
                }
                top += height;
            }
            if (row < rows && (height = this.idxRows.get(row).getHeight()) > 0) {
                left = 0;
                col3 = 0;
                while (col3 <= cols) {
                    width = (Integer)columnSeparatorWidths.get(col3);
                    if (width > 0) {
                        this.idxCellVSeparators.get(row, col3).paint(canvas.at(top, left).withBounds(height, width).newSubCanvas());
                        left += width;
                    }
                    if (col3 < cols && (width = ((Integer)columnWidths.get(col3)).intValue()) > 0) {
                        this.idxCells.get(row, col3).paint(canvas.at(top, left).withBounds(height, width).newSubCanvas());
                        left += width;
                    }
                    ++col3;
                }
                top += height;
            }
            ++row;
        }
    }

    public Table setBorder(int border) {
        this.border = border;
        return this;
    }

    public Table setColumnSeparatorBackground(Object ColumnSeparatorBackground) {
        this.columnSeparatorBackground = TextBlock.get(ColumnSeparatorBackground);
        return this;
    }

    public Table setColumnSeparatorWidth(int columnSeparatorWidth) {
        this.columnSeparatorWidth = columnSeparatorWidth;
        return this;
    }

    public Table setMaxCellWidth(int maxCellWidth) {
        this.maxCellWidth = maxCellWidth;
        return this;
    }

    public Table setRowSeparatorBackground(Object RowSeparatorBackground) {
        this.rowSeparatorBackground = TextBlock.get(RowSeparatorBackground);
        return this;
    }

    public Table setRowSeparatorHeight(int rowSeparatorHeight) {
        this.rowSeparatorHeight = rowSeparatorHeight;
        return this;
    }

    public Table setSeparatorCrossingBackground(Object text) {
        this.separatorCrossingBackground = TextBlock.get(text);
        return this;
    }

    public String toString() {
        ICanvas canvas = Canvas.create();
        this.paint(canvas);
        return canvas.toString();
    }

    public static class Cell
    extends Element2 {
        private ITextBlock text = ITextBlock.EMPTY;

        protected Cell(Table table, int row, int col) {
            super(table, row, col);
        }

        public Column getColumn() {
            return this.table.getColumn(this.getColIndex());
        }

        public int getHeight() {
            return this.text.getLines().size();
        }

        public Row getRow() {
            return this.table.getRow(this.getRowIndex());
        }

        public int getWidth() {
            int result = 0;
            for (String line : this.text.getLines()) {
                int length = line.length();
                if (length <= result) continue;
                result = length;
            }
            if (this.table.maxCellWidth > 0 && result > this.table.maxCellWidth) {
                result = this.table.maxCellWidth;
            }
            return result;
        }

        protected void paint(ICanvas canvas) {
            canvas.print(this.text);
        }

        public Cell setText(Object text) {
            this.text = TextBlock.get(text);
            return this;
        }

        public static class Provider
        implements Provider2<Cell> {
            @Override
            public Cell get(Table table, Object old, int rowIndex, int columnIndex) {
                if (old instanceof Cell) {
                    return (Cell)old;
                }
                if (old == null) {
                    return new Cell(table, rowIndex, columnIndex);
                }
                throw new ClassCastException();
            }
        }
    }

    public static class CellHSeparator
    extends Element2 {
        private ITextBlock background = ITextBlock.EMPTY;

        protected CellHSeparator(Table table, int rowIndex, int colIndex) {
            super(table, rowIndex, colIndex);
        }

        public ITextBlock getBackground() {
            if (this.background != ITextBlock.EMPTY) {
                return this.background;
            }
            return this.getRowSeparator().getBackground();
        }

        public RowSeparator getRowSeparator() {
            return (RowSeparator)this.table.idxRowSeparators.get(this.rowIndex);
        }

        public void paint(ICanvas canvas) {
            ITextBlock b = this.getBackground();
            if (b != ITextBlock.EMPTY) {
                canvas.fill(b);
            }
        }

        public CellHSeparator setBackground(ITextBlock background) {
            this.background = background;
            return this;
        }

        public static class Provider
        implements Provider2<CellHSeparator> {
            @Override
            public CellHSeparator get(Table table, Object old, int rowIndex, int columnIndex) {
                if (old instanceof CellHSeparator) {
                    return (CellHSeparator)old;
                }
                if (old == null) {
                    return new CellHSeparator(table, rowIndex, columnIndex);
                }
                throw new ClassCastException();
            }
        }
    }

    public static class CellVSeparator
    extends Element2 {
        private ITextBlock background = ITextBlock.EMPTY;

        protected CellVSeparator(Table table, int rowIndex, int colIndex) {
            super(table, rowIndex, colIndex);
        }

        public ITextBlock getBackground() {
            if (this.background != ITextBlock.EMPTY) {
                return this.background;
            }
            return this.getColumnSeparator().getBackground();
        }

        public ColumnSeparator getColumnSeparator() {
            return (ColumnSeparator)this.table.idxColumnSeparators.get(this.colIndex);
        }

        public void paint(ICanvas canvas) {
            ITextBlock b = this.getBackground();
            if (b != ITextBlock.EMPTY) {
                canvas.fill(b);
            }
        }

        public CellVSeparator setBackground(ITextBlock background) {
            this.background = background;
            return this;
        }

        public static class Provider
        implements Provider2<CellVSeparator> {
            @Override
            public CellVSeparator get(Table table, Object old, int rowIndex, int columnIndex) {
                if (old instanceof CellVSeparator) {
                    return (CellVSeparator)old;
                }
                if (old == null) {
                    return new CellVSeparator(table, rowIndex, columnIndex);
                }
                throw new ClassCastException();
            }
        }
    }

    public static class Column
    extends Element1 {
        protected Column(Table table, int index) {
            super(table, index);
        }

        public Cell getCell(int rowIndex) {
            return this.table.getCell(rowIndex, this.index);
        }

        public ColumnSeparator getLeftSeparator() {
            return (ColumnSeparator)this.table.idxColumnSeparators.get(this.index);
        }

        public ColumnSeparator getRightSeparator() {
            return (ColumnSeparator)this.table.idxColumnSeparators.get(this.index + 1);
        }

        public int getWidth() {
            int result = 0;
            for (Cell cell : this.table.idxCells.getByColumn(this.index)) {
                int width = cell.getWidth();
                if (width <= result) continue;
                result = width;
            }
            return result;
        }

        public static class Provider
        implements Provider1<Column> {
            @Override
            public Column get(Table table, Object old, int index) {
                if (old instanceof Column) {
                    return (Column)old;
                }
                if (old == null) {
                    return new Column(table, index);
                }
                throw new ClassCastException();
            }
        }
    }

    public static class ColumnSeparator
    extends Element1 {
        private ITextBlock background = ITextBlock.EMPTY;
        private int width = -1;

        protected ColumnSeparator(Table table, int index) {
            super(table, index);
        }

        public ITextBlock getBackground() {
            if (this.background == ITextBlock.EMPTY) {
                return this.table.columnSeparatorBackground;
            }
            return this.background;
        }

        public int getWidth() {
            if (this.width != -1) {
                return this.width;
            }
            if (this.isBorder()) {
                return this.table.border;
            }
            return this.table.columnSeparatorWidth;
        }

        public boolean isBorder() {
            return this.isLeftBorder() || this.isRightBorder();
        }

        public boolean isLeftBorder() {
            return this.index == 0;
        }

        public boolean isRightBorder() {
            return this.index == this.table.getColumnCount();
        }

        public ColumnSeparator setBackground(Object background) {
            this.background = TextBlock.get(background);
            return this;
        }

        public ColumnSeparator setWidth(int width) {
            this.width = width;
            return this;
        }

        public static class Provider
        implements Provider1<ColumnSeparator> {
            @Override
            public ColumnSeparator get(Table table, Object old, int index) {
                if (old instanceof ColumnSeparator) {
                    return (ColumnSeparator)old;
                }
                if (old == null) {
                    return new ColumnSeparator(table, index);
                }
                throw new ClassCastException();
            }
        }
    }

    public static abstract class Element {
        protected final Table table;

        protected Element(Table table) {
            this.table = table;
        }

        public Table getTable() {
            return this.table;
        }
    }

    public static abstract class Element1
    extends Element {
        protected final int index;

        protected Element1(Table table, int index) {
            super(table);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static abstract class Element2
    extends Element {
        protected final int colIndex;
        protected final int rowIndex;

        protected Element2(Table table, int rowIndex, int colIndex) {
            super(table);
            this.rowIndex = rowIndex;
            this.colIndex = colIndex;
        }

        public int getColIndex() {
            return this.colIndex;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }
    }

    public class Indexed1<T> {
        private final Provider1<T> factory;
        private final List<T> list = Lists.newArrayList();

        protected Indexed1(Provider1<T> factory) {
            this.factory = factory;
        }

        public T get(int index) {
            return this.get(index, this.factory);
        }

        public <X extends T> X get(int index, Provider1<X> factory) {
            X result;
            int i = this.list.size();
            while (i < index) {
                this.list.add(null);
                ++i;
            }
            if (this.list.size() == index) {
                X result2 = factory.get(Table.this, null, index);
                this.list.add(result2);
                return result2;
            }
            T old = this.list.get(index);
            if (old != (result = factory.get(Table.this, old, index))) {
                this.list.set(index, result);
            }
            return result;
        }
    }

    public class Indexed2<T> {
        private final List<List<T>> list = Lists.newArrayList();
        private final Provider2<T> provider;

        protected Indexed2(Provider2<T> factory) {
            this.provider = factory;
        }

        public T addToColumn(int colIndex) {
            return this.addToColumn(colIndex, this.provider);
        }

        public <X extends T> X addToColumn(int colIndex, Provider2<X> provider) {
            return this.get(this.getCountInColumn(colIndex), colIndex, provider);
        }

        public T addToRow(int rowIndex) {
            return this.addToRow(rowIndex, this.provider);
        }

        public <X extends T> X addToRow(int rowIndex, Provider2<X> provider) {
            Preconditions.checkArgument((rowIndex >= 0 ? 1 : 0) != 0);
            int i = this.list.size();
            while (i <= rowIndex) {
                this.list.add(Lists.newArrayList());
                ++i;
            }
            List<T> row = this.list.get(rowIndex);
            X result = provider.get(Table.this, null, rowIndex, row.size());
            row.add(result);
            return result;
        }

        public T get(int rowIndex, int colIndex) {
            return this.get(rowIndex, colIndex, this.provider);
        }

        public <X extends T> X get(int rowIndex, int colIndex, Provider2<X> provider) {
            X result;
            Preconditions.checkArgument((colIndex >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((rowIndex >= 0 ? 1 : 0) != 0);
            int i = this.list.size();
            while (i <= rowIndex) {
                this.list.add(Lists.newArrayList());
                ++i;
            }
            List<T> row = this.list.get(rowIndex);
            int i2 = row.size();
            while (i2 < colIndex) {
                row.add(null);
                ++i2;
            }
            if (row.size() == colIndex) {
                X result2 = provider.get(Table.this, null, rowIndex, colIndex);
                row.add(result2);
                return result2;
            }
            T old = row.get(colIndex);
            if (old != (result = provider.get(Table.this, old, rowIndex, colIndex))) {
                row.set(colIndex, result);
            }
            return result;
        }

        public Iterable<T> getByColumn(final int columIndex) {
            Preconditions.checkArgument((columIndex >= 0 ? 1 : 0) != 0);
            return Iterables.filter((Iterable)Iterables.transform(this.list, (Function)new Function<List<T>, T>(){

                public T apply(List<T> input) {
                    if (columIndex < input.size()) {
                        return input.get(columIndex);
                    }
                    return null;
                }
            }), (Predicate)Predicates.notNull());
        }

        public Iterable<T> getByRow(int rowIndex) {
            Preconditions.checkArgument((rowIndex >= 0 ? 1 : 0) != 0);
            if (rowIndex >= this.list.size()) {
                return Collections.emptyList();
            }
            return Iterables.filter((Iterable)this.list.get(rowIndex), (Predicate)Predicates.notNull());
        }

        public int getColumnCount() {
            int result = 0;
            for (List<T> row : this.list) {
                int size = row.size();
                if (size <= result) continue;
                result = size;
            }
            return result;
        }

        public int getCountInColumn(int colIndex) {
            Preconditions.checkArgument((colIndex > 0 ? 1 : 0) != 0);
            int lastNonemptyRow = this.list.size() - 1;
            while (lastNonemptyRow >= 0) {
                List<T> row = this.list.get(lastNonemptyRow);
                if (colIndex >= row.size() || row.get(colIndex) != null) break;
                --lastNonemptyRow;
            }
            return lastNonemptyRow + 1;
        }

        public int getRowCount() {
            return this.list.size();
        }
    }

    public static interface Provider1<T> {
        public T get(Table var1, Object var2, int var3);
    }

    public static interface Provider2<T> {
        public T get(Table var1, Object var2, int var3, int var4);
    }

    public static class Row
    extends Element1 {
        protected Row(Table table, int index) {
            super(table, index);
        }

        public Cell addCell() {
            return (Cell)this.table.idxCells.addToRow(this.index);
        }

        public RowSeparator getBottomSeparator() {
            return (RowSeparator)this.table.idxRowSeparators.get(this.index + 1);
        }

        public Cell getCell(int colIndex) {
            return (Cell)this.table.idxCells.get(this.index, colIndex);
        }

        public int getHeight() {
            int result = 0;
            for (Cell cell : this.table.idxCells.getByRow(this.index)) {
                int height = cell.getHeight();
                if (height <= result) continue;
                result = height;
            }
            return result;
        }

        public RowSeparator getTopSeparator() {
            return (RowSeparator)this.table.idxRowSeparators.get(this.index);
        }

        public static class Provider
        implements Provider1<Row> {
            @Override
            public Row get(Table table, Object old, int index) {
                if (old instanceof Row) {
                    return (Row)old;
                }
                if (old == null) {
                    return new Row(table, index);
                }
                throw new ClassCastException();
            }
        }
    }

    public static class RowSeparator
    extends Element1 {
        private ITextBlock background = ITextBlock.EMPTY;
        private int height = -1;

        protected RowSeparator(Table table, int index) {
            super(table, index);
        }

        public ITextBlock getBackground() {
            if (this.background == ITextBlock.EMPTY) {
                return this.table.rowSeparatorBackground;
            }
            return this.background;
        }

        public int getHeight() {
            if (this.height != -1) {
                return this.height;
            }
            if (this.isBorder()) {
                return this.table.border;
            }
            return this.table.rowSeparatorHeight;
        }

        public boolean isBorder() {
            return this.isTopBorder() || this.isBottomBorder();
        }

        public boolean isBottomBorder() {
            return this.index == this.table.getRowCount();
        }

        public boolean isTopBorder() {
            return this.index == 0;
        }

        public RowSeparator setBackground(Object background) {
            this.background = TextBlock.get(background);
            return this;
        }

        public RowSeparator setHeight(int height) {
            this.height = height;
            return this;
        }

        public static class Provider
        implements Provider1<RowSeparator> {
            @Override
            public RowSeparator get(Table table, Object old, int index) {
                if (old instanceof RowSeparator) {
                    return (RowSeparator)old;
                }
                if (old == null) {
                    return new RowSeparator(table, index);
                }
                throw new ClassCastException();
            }
        }
    }

    public static class SeparatorCrossing
    extends Element2 {
        private ITextBlock background = ITextBlock.EMPTY;

        protected SeparatorCrossing(Table table, int rowIndex, int colIndex) {
            super(table, rowIndex, colIndex);
        }

        public ITextBlock getBackground() {
            if (this.background != ITextBlock.EMPTY) {
                return this.background;
            }
            return this.table.separatorCrossingBackground;
        }

        public void paint(ICanvas canvas) {
            ITextBlock c = this.getBackground();
            if (c != ITextBlock.EMPTY) {
                canvas.fill(c);
            }
        }

        public SeparatorCrossing setBackground(Object background) {
            this.background = TextBlock.get(background);
            return this;
        }

        public static class Provider
        implements Provider2<SeparatorCrossing> {
            @Override
            public SeparatorCrossing get(Table table, Object old, int rowIndex, int columnIndex) {
                if (old instanceof SeparatorCrossing) {
                    return (SeparatorCrossing)old;
                }
                if (old == null) {
                    return new SeparatorCrossing(table, rowIndex, columnIndex);
                }
                throw new ClassCastException();
            }
        }
    }
}

