/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetImpl;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerImpl;
import org.eclipse.swt.graphics.Image;

public class ProjectTypeAwareWorkingSetManager
extends WorkingSetManagerImpl {
    @Inject
    private IN4JSCore core;

    @Override
    public String getLabel() {
        return "N4JS Project Type";
    }

    @Override
    public Optional<Image> getImage() {
        return ImageDescriptorCache.ImageRef.TYPES.asImage();
    }

    @Override
    protected List<WorkingSet> initializeWorkingSets() {
        ArrayList types = Lists.newArrayList((Object[])ProjectType.values());
        types.add(null);
        return Lists.newArrayList((Iterable)FluentIterable.from((Iterable)types).transform(type -> new ProjectTypeWorkingSet((ProjectType)type, this.core, this)));
    }

    public static final class ProjectTypeWorkingSet
    extends WorkingSetImpl {
        private final ProjectType type;
        private final IN4JSCore core;

        private static String typeToId(ProjectType type) {
            if (type == null) {
                return "Other Projects";
            }
            return ProjectType.API.equals((Object)type) ? ProjectType.API.getLiteral() : org.eclipse.xtext.util.Strings.toFirstUpper((String)Strings.nullToEmpty((String)type.getLiteral()).replaceAll("_", " ").toLowerCase());
        }

        public ProjectTypeWorkingSet(ProjectType type, IN4JSCore core, WorkingSetManager manager) {
            super(ProjectTypeWorkingSet.typeToId(type), manager);
            this.type = type;
            this.core = core;
        }

        @Override
        public IAdaptable[] getElements() {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            IProject[] elements = new IProject[projects.length];
            int elementCount = 0;
            int i = 0;
            int size = projects.length;
            while (i < size) {
                IProject project = projects[i];
                IN4JSProject n4Project = (IN4JSProject)this.core.findProject(this.toUri(project)).orNull();
                if (this.type == null) {
                    if (n4Project == null || !n4Project.exists()) {
                        elements[elementCount++] = project;
                    }
                } else if (n4Project != null && n4Project.exists() && this.type.equals((Object)n4Project.getProjectType())) {
                    elements[elementCount++] = project;
                }
                ++i;
            }
            return (IAdaptable[])Arrays.copyOfRange(elements, 0, elementCount);
        }

        public ProjectType getType() {
            return this.type;
        }

        private URI toUri(IProject project) {
            return URI.createPlatformResourceURI((String)project.getName(), (boolean)true);
        }
    }
}

