/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.scoping.builtin;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScopeAccess;
import org.eclipse.n4js.ts.scoping.builtin.EnumerableScope;
import org.eclipse.n4js.ts.scoping.builtin.ExecutionEnvironmentDescriptor;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.types.AnyType;
import org.eclipse.n4js.ts.types.NullType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeDefs;
import org.eclipse.n4js.ts.types.UndefinedType;
import org.eclipse.n4js.ts.types.VirtualBaseType;
import org.eclipse.n4js.ts.types.VoidType;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;

public final class BuiltInTypeScope
extends EnumerableScope {
    @VisibleForTesting
    public static final String[] FILE_NAMES = new String[]{"primitives_js.n4ts", "primitives_n4.n4ts", "builtin_js.n4ts", "builtin_n4.n4ts", "console.n4ts", "builtin_n4idl.n4ts"};
    public static final int ITERABLE_N__MAX_LEN = 9;
    public static final QualifiedName QN_TYPENAME = QualifiedName.create((String)"typeName");
    public static final QualifiedName QN_I18NKEY = QualifiedName.create((String)"i18nKey");
    public static final QualifiedName QN_PATHSELECTOR = QualifiedName.create((String)"pathSelector");
    public static final QualifiedName QN_NUMBER = QualifiedName.create((String)"number");
    public static final QualifiedName QN_INT = QualifiedName.create((String)"int");
    public static final QualifiedName QN_STRING = QualifiedName.create((String)"string");
    public static final QualifiedName QN_STRING_OBJECT = QualifiedName.create((String)"String");
    public static final QualifiedName QN_BOOLEAN = QualifiedName.create((String)"boolean");
    public static final QualifiedName QN_SYMBOL = QualifiedName.create((String)"symbol");
    public static final QualifiedName QN_SYMBOL_OBJECT = QualifiedName.create((String)"Symbol");
    public static final QualifiedName QN_UNDEFINED = QualifiedName.create((String)"undefined");
    public static final QualifiedName QN_VOID = QualifiedName.create((String)"void");
    public static final QualifiedName QN_NULL = QualifiedName.create((String)"null");
    public static final QualifiedName QN_ANY = QualifiedName.create((String)"any");
    public static final QualifiedName QN_REGEXP = QualifiedName.create((String)"RegExp");
    public static final QualifiedName QN_ARRAY = QualifiedName.create((String)"Array");
    public static final QualifiedName QN_OBJECT = QualifiedName.create((String)"Object");
    public static final QualifiedName QN_FUNCTION = QualifiedName.create((String)"Function");
    public static final QualifiedName QN_ITERABLE = QualifiedName.create((String)"Iterable");
    public static final QualifiedName QN_GENERATOR = QualifiedName.create((String)"Generator");
    public static final QualifiedName QN_PROMISE = QualifiedName.create((String)"Promise");
    public static final QualifiedName QN_N4OBJECT = QualifiedName.create((String)"N4Object");
    public static final QualifiedName QN_N4ENUM = QualifiedName.create((String)"N4Enum");
    public static final QualifiedName QN_N4STRINGBASEDENUM = QualifiedName.create((String)"N4StringBasedEnum");
    public static final QualifiedName QN_ERROR = QualifiedName.create((String)"Error");
    public static final QualifiedName QN_N4PROVIDER = QualifiedName.create((String)"N4Provider");
    public static final QualifiedName QN_MIGRATION_CONTEXT = QualifiedName.create((String)"MigrationContext");
    private static final QualifiedName QN_N4ELEMENT = QualifiedName.create((String)"N4Element");
    private static final QualifiedName QN_N4NAMEDELEMENT = QualifiedName.create((String)"N4NamedElement");
    private static final QualifiedName QN_N4TYPE = QualifiedName.create((String)"N4Type");
    private List<ParameterizedTypeRef> n4classifiersAllImplicitSuperTypeRefs;
    private List<ParameterizedTypeRef> objectPrototypesAllImplicitSuperTypeRefs;
    private List<ParameterizedTypeRef> functionTypesAllImplicitSuperTypeRefs;
    private List<TInterface> cachedIterableNTypes = null;

    public static BuiltInTypeScope get(ResourceSet resourceSet) {
        BuiltInTypeScopeAccess result = (BuiltInTypeScopeAccess)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), BuiltInTypeScope.class);
        if (result == null) {
            throw new IllegalStateException("Missing adapter for BuiltInTypeScope");
        }
        return result.getScope();
    }

    public BuiltInTypeScope(ExecutionEnvironmentDescriptor descriptor) {
        super(descriptor);
    }

    private void initImplicitSuperTypeLists() {
        this.objectPrototypesAllImplicitSuperTypeRefs = this.toTypeReferences(new Type[]{this.getObjectType()});
        this.n4classifiersAllImplicitSuperTypeRefs = this.toTypeReferences(new Type[]{this.getN4ObjectType(), this.getObjectType()});
        this.functionTypesAllImplicitSuperTypeRefs = this.toTypeReferences(new Type[]{this.getFunctionType(), this.getObjectType()});
    }

    public final AnyType getAnyType() {
        return (AnyType)this.getEObjectOrProxy(QN_ANY);
    }

    public final ParameterizedTypeRef getAnyTypeRef() {
        return TypeUtils.createTypeRef((Type)this.getAnyType(), new TypeArgument[0]);
    }

    public final NullType getNullType() {
        return (NullType)this.getEObjectOrProxy(QN_NULL);
    }

    public final VoidType getVoidType() {
        return (VoidType)this.getEObjectOrProxy(QN_VOID);
    }

    public final ParameterizedTypeRef getVoidTypeRef() {
        return TypeUtils.createTypeRef((Type)this.getVoidType(), new TypeArgument[0]);
    }

    public final UndefinedType getUndefinedType() {
        return (UndefinedType)this.getEObjectOrProxy(QN_UNDEFINED);
    }

    public final ParameterizedTypeRef getUndefinedTypeRef() {
        return TypeUtils.createTypeRef((Type)this.getUndefinedType(), new TypeArgument[0]);
    }

    public final PrimitiveType getBooleanType() {
        return (PrimitiveType)this.getEObjectOrProxy(QN_BOOLEAN);
    }

    public final PrimitiveType getStringType() {
        return (PrimitiveType)this.getEObjectOrProxy(QN_STRING);
    }

    public final TObjectPrototype getStringObjectType() {
        return (TObjectPrototype)this.getEObjectOrProxy(QN_STRING_OBJECT);
    }

    public final PrimitiveType getNumberType() {
        return (PrimitiveType)this.getEObjectOrProxy(QN_NUMBER);
    }

    public final PrimitiveType getIntType() {
        return (PrimitiveType)this.getEObjectOrProxy(QN_INT);
    }

    public final PrimitiveType getSymbolType() {
        return (PrimitiveType)this.getEObjectOrProxy(QN_SYMBOL);
    }

    public final TObjectPrototype getSymbolObjectType() {
        return (TObjectPrototype)this.getEObjectOrProxy(QN_SYMBOL_OBJECT);
    }

    public final PrimitiveType getPathSelectorType() {
        return (PrimitiveType)this.getEObjectOrProxy(QN_PATHSELECTOR);
    }

    public final PrimitiveType getI18nKeyType() {
        return (PrimitiveType)this.getEObjectOrProxy(QN_I18NKEY);
    }

    public final PrimitiveType getTypeNameType() {
        return (PrimitiveType)this.getEObjectOrProxy(QN_TYPENAME);
    }

    public final TObjectPrototype getRegexpType() {
        return (TObjectPrototype)this.getEObjectOrProxy(QN_REGEXP);
    }

    public final TObjectPrototype getArrayType() {
        return (TObjectPrototype)this.getEObjectOrProxy(QN_ARRAY);
    }

    public final TClassifier getObjectType() {
        return (TClassifier)this.getEObjectOrProxy(QN_OBJECT);
    }

    public final TObjectPrototype getFunctionType() {
        return (TObjectPrototype)this.getEObjectOrProxy(QN_FUNCTION);
    }

    public final TInterface getIterableType() {
        return (TInterface)this.getEObjectOrProxy(QN_ITERABLE);
    }

    public final TInterface getGeneratorType() {
        return (TInterface)this.getEObjectOrProxy(QN_GENERATOR);
    }

    public final TInterface getIterableNType(int n) {
        if (n < 2 || n > 9) {
            throw new IllegalArgumentException("n must lie between 2 and 9 (inclusive)");
        }
        return (TInterface)this.getEObjectOrProxy(QualifiedName.create((String)("Iterable" + n)));
    }

    public final List<TInterface> getIterableNTypes() {
        if (this.cachedIterableNTypes == null) {
            this.cachedIterableNTypes = new ArrayList<TInterface>();
            int n = 2;
            while (n <= 9) {
                this.cachedIterableNTypes.add(this.getIterableNType(n));
                ++n;
            }
            this.cachedIterableNTypes = Collections.unmodifiableList(this.cachedIterableNTypes);
        }
        return this.cachedIterableNTypes;
    }

    public final TClass getN4ObjectType() {
        return (TClass)this.getEObjectOrProxy(QN_N4OBJECT);
    }

    public final TObjectPrototype getErrorType() {
        return (TObjectPrototype)this.getEObjectOrProxy(QN_ERROR);
    }

    public final TObjectPrototype getN4EnumType() {
        return (TObjectPrototype)this.getEObjectOrProxy(QN_N4ENUM);
    }

    public final TObjectPrototype getN4StringBasedEnumType() {
        return (TObjectPrototype)this.getEObjectOrProxy(QN_N4STRINGBASEDENUM);
    }

    public final TClass getPromiseType() {
        return (TClass)this.getEObjectOrProxy(QN_PROMISE);
    }

    public final TInterface getN4ProviderType() {
        return (TInterface)this.getEObjectOrProxy(QN_N4PROVIDER);
    }

    public final TInterface getMigrationContextType() {
        return (TInterface)this.getEObjectOrProxy(QN_MIGRATION_CONTEXT);
    }

    public final TClass getN4ElementType() {
        return (TClass)this.getEObjectOrProxy(QN_N4ELEMENT);
    }

    public final TClass getN4NamedElementType() {
        return (TClass)this.getEObjectOrProxy(QN_N4NAMEDELEMENT);
    }

    public final TClass getN4TypeType() {
        return (TClass)this.getEObjectOrProxy(QN_N4TYPE);
    }

    public final boolean isNumeric(Type type) {
        return type == this.getNumberType() || type == this.getIntType();
    }

    public final boolean isNumericOperand(Type type) {
        return type == this.getNumberType() || type == this.getIntType() || type == this.getBooleanType() || type == this.getNullType() || type == this.getUndefinedType();
    }

    public synchronized List<ParameterizedTypeRef> getN4ClassifiersAllImplicitSuperTypeRefs() {
        if (this.n4classifiersAllImplicitSuperTypeRefs == null) {
            this.initImplicitSuperTypeLists();
        }
        return this.n4classifiersAllImplicitSuperTypeRefs;
    }

    public synchronized List<ParameterizedTypeRef> getObjectPrototypesAllImplicitSuperTypeRefs() {
        if (this.objectPrototypesAllImplicitSuperTypeRefs == null) {
            this.initImplicitSuperTypeLists();
        }
        return this.objectPrototypesAllImplicitSuperTypeRefs;
    }

    public synchronized List<ParameterizedTypeRef> getFunctionTypesAllImplicitSuperTypeRefs() {
        if (this.functionTypesAllImplicitSuperTypeRefs == null) {
            this.initImplicitSuperTypeLists();
        }
        return this.functionTypesAllImplicitSuperTypeRefs;
    }

    @Override
    protected String[] getFileNames() {
        return FILE_NAMES;
    }

    @Override
    protected void buildMap(Resource resource, Map<QualifiedName, IEObjectDescription> elements) {
        TypeDefs typeDefinitions = (TypeDefs)resource.getContents().get(0);
        for (Type type : typeDefinitions.getTypes()) {
            if (type instanceof VirtualBaseType) continue;
            IEObjectDescription description = EObjectDescription.create((String)type.getName(), (EObject)type);
            elements.put(description.getName(), description);
        }
    }
}

