/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.print;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.conversion.ValueConverterUtils;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayBindingPattern;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrayPadding;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BindingElement;
import org.eclipse.n4js.n4JS.BindingProperty;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.BreakStatement;
import org.eclipse.n4js.n4JS.CaseClause;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.CatchBlock;
import org.eclipse.n4js.n4JS.CatchVariable;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.ContinueStatement;
import org.eclipse.n4js.n4JS.DebuggerStatement;
import org.eclipse.n4js.n4JS.DefaultClause;
import org.eclipse.n4js.n4JS.DefaultImportSpecifier;
import org.eclipse.n4js.n4JS.DoStatement;
import org.eclipse.n4js.n4JS.DoubleLiteral;
import org.eclipse.n4js.n4JS.EmptyStatement;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportSpecifier;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.ExportedVariableBinding;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FinallyBlock;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.HexIntLiteral;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.ImportCallExpression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.IntLiteral;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.LocalArgumentsVariable;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ObjectBindingPattern;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.OctalIntLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.PropertyAssignmentAnnotationList;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameKind;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertyNameValuePairSingleName;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.n4JS.PropertySpread;
import org.eclipse.n4js.n4JS.RegularExpressionLiteral;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.ScientificIntLiteral;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ShiftExpression;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.SwitchStatement;
import org.eclipse.n4js.n4JS.TemplateLiteral;
import org.eclipse.n4js.n4JS.TemplateSegment;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.n4JS.TryStatement;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VariableStatementKeyword;
import org.eclipse.n4js.n4JS.WhileStatement;
import org.eclipse.n4js.n4JS.WithStatement;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.n4JS.util.N4JSSwitch;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ImPackage;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.Script_IM;
import org.eclipse.n4js.transpiler.im.Snippet;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.print.SourceMapAwareAppendable;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.xtext.EcoreUtil2;

final class PrettyPrinterSwitch
extends N4JSSwitch<Boolean> {
    private static final Boolean DONE = Boolean.TRUE;
    private final SourceMapAwareAppendable out;

    public static void append(SourceMapAwareAppendable out, TranspilerState state) {
        PrettyPrinterSwitch theSwitch = new PrettyPrinterSwitch(out);
        theSwitch.doSwitch((EObject)state.im);
    }

    private PrettyPrinterSwitch(SourceMapAwareAppendable out) {
        this.out = out;
    }

    protected Boolean doSwitch(EClass eClass, EObject eObject) {
        if (eClass == ImPackage.eINSTANCE.getSnippet()) {
            return this.caseSnippet((Snippet)eObject);
        }
        return (Boolean)super.doSwitch(eClass, eObject);
    }

    protected Boolean doSwitch(int classifierID, EObject elemInIM) {
        this.out.openRegion(elemInIM);
        try {
            Boolean result;
            Boolean bl = result = (Boolean)super.doSwitch(classifierID, elemInIM);
            return bl;
        }
        finally {
            this.out.closeRegion(elemInIM);
        }
    }

    public Boolean defaultCase(EObject object) {
        throw new IllegalStateException("PrettyPrinterSwitch missing a case for objects of type " + object.eClass().getName());
    }

    public Boolean caseScript(Script original) {
        Script_IM original_IM = (Script_IM)original;
        this.processAnnotations((Iterable<? extends Annotation>)original_IM.getAnnotations());
        this.process((Iterable<? extends EObject>)original_IM.getScriptElements(), () -> this.newLine());
        return DONE;
    }

    public Boolean caseExportDeclaration(ExportDeclaration original) {
        if (original.getReexportedFrom() != null) {
            this.throwUnsupportedSyntax();
        }
        this.processAnnotations((Iterable<? extends Annotation>)original.getAnnotations());
        this.write("export ");
        EList namedExports = original.getNamedExports();
        if (!namedExports.isEmpty()) {
            this.write("{ ");
            this.process((Iterable<? extends EObject>)namedExports, ", ");
            this.write(" }");
        } else {
            ExportableElement exportedElement;
            if (original.isDefaultExport()) {
                this.write("default ");
            }
            if ((exportedElement = original.getExportedElement()) != null) {
                this.process((EObject)exportedElement);
            } else {
                Expression exportedExpression = original.getDefaultExportedExpression();
                if (exportedExpression != null && original.isDefaultExport()) {
                    this.process((EObject)exportedExpression);
                    this.write(';');
                }
            }
        }
        return DONE;
    }

    public Boolean caseExportSpecifier(ExportSpecifier original) {
        this.process((EObject)original.getElement());
        String alias = original.getAlias();
        if (alias != null) {
            this.write(" as ");
            this.write(alias);
        }
        return DONE;
    }

    public Boolean caseImportDeclaration(ImportDeclaration original) {
        boolean isLastImport;
        this.processAnnotations((Iterable<? extends Annotation>)original.getAnnotations());
        this.write("import ");
        ArrayList importSpecifiers = new ArrayList(original.getImportSpecifiers());
        if (!importSpecifiers.isEmpty() && importSpecifiers.get(0) instanceof DefaultImportSpecifier) {
            this.process((EObject)importSpecifiers.remove(0));
            if (!importSpecifiers.isEmpty()) {
                this.write(", ");
            }
        }
        if (!importSpecifiers.isEmpty()) {
            boolean isNamespaceImport = importSpecifiers.get(0) instanceof NamespaceImportSpecifier;
            if (isNamespaceImport) {
                this.process((EObject)importSpecifiers.get(0));
            } else {
                this.write('{');
                this.process(importSpecifiers, ", ");
                this.write('}');
            }
        }
        if (original.isImportFrom()) {
            this.write(" from ");
        }
        String moduleSpecifier = original.getModuleSpecifierAsText() != null ? original.getModuleSpecifierAsText() : original.getModule().getQualifiedName();
        this.write(this.quote(moduleSpecifier));
        boolean bl = isLastImport = !(EcoreUtil2.getNextSibling((EObject)original) instanceof ImportDeclaration);
        if (isLastImport) {
            this.newLine();
        }
        return DONE;
    }

    public Boolean caseNamedImportSpecifier(NamedImportSpecifier original) {
        this.write(original.getImportedElementAsText());
        String alias = original.getAlias();
        if (alias != null && !original.isDefaultImport()) {
            this.write(" as ");
            this.write(alias);
        }
        return DONE;
    }

    public Boolean caseNamespaceImportSpecifier(NamespaceImportSpecifier original) {
        this.write("* as ");
        this.write(original.getAlias());
        return DONE;
    }

    public Boolean caseFunctionDeclaration(FunctionDeclaration original) {
        this.processAnnotations((Iterable<? extends Annotation>)original.getAnnotations());
        if (!original.getDeclaredModifiers().isEmpty()) {
            this.processModifiers((EList<N4Modifier>)original.getDeclaredModifiers());
            this.write(' ');
        }
        if (original.isAsync()) {
            this.write("async ");
        }
        this.write("function ");
        if (!original.getTypeVars().isEmpty()) {
            this.processTypeParams((EList<TypeVariable>)original.getTypeVars());
            this.write(' ');
        }
        if (original.isGenerator()) {
            this.write("* ");
        }
        this.write(original.getName());
        this.write('(');
        this.process((Iterable<? extends EObject>)original.getFpars(), ", ");
        this.write(") ");
        if (original.getReturnTypeRef() != null) {
            this.processReturnTypeRef(original.getReturnTypeRef());
            this.write(' ');
        }
        this.process((EObject)original.getBody());
        return DONE;
    }

    public Boolean caseFunctionExpression(FunctionExpression original) {
        this.processAnnotations((Iterable<? extends Annotation>)original.getAnnotations());
        if (original.isAsync()) {
            this.write("async ");
        }
        this.write("function");
        if (!original.getTypeVars().isEmpty()) {
            this.write(' ');
            this.processTypeParams((EList<TypeVariable>)original.getTypeVars());
        }
        if (original.isGenerator()) {
            this.write(" *");
        }
        if (original.getName() != null) {
            this.write(' ');
            this.write(original.getName());
        }
        this.write('(');
        this.process((Iterable<? extends EObject>)original.getFpars(), ", ");
        this.write(") ");
        if (original.getReturnTypeRef() != null) {
            this.processReturnTypeRef(original.getReturnTypeRef());
            this.write(' ');
        }
        this.process((EObject)original.getBody());
        return DONE;
    }

    public Boolean caseArrowFunction(ArrowFunction original) {
        if (original.isAsync()) {
            this.write("async");
        }
        this.write('(');
        this.process((Iterable<? extends EObject>)original.getFpars(), ", ");
        this.write(')');
        this.processReturnTypeRef(original.getReturnTypeRef());
        this.write("=>");
        if (original.isHasBracesAroundBody()) {
            this.process((EObject)original.getBody());
        } else {
            if (!original.isSingleExprImplicitReturn()) {
                throw new IllegalStateException("arrow function without braces must be a valid single-expression arrow function");
            }
            Expression singleExpr = original.getSingleExpression();
            this.process((EObject)singleExpr);
        }
        return DONE;
    }

    public Boolean caseLocalArgumentsVariable(LocalArgumentsVariable original) {
        return DONE;
    }

    public Boolean caseFormalParameter(FormalParameter original) {
        this.processAnnotations((Iterable<? extends Annotation>)original.getAnnotations(), false);
        if (original.isVariadic()) {
            this.write("...");
        }
        this.write(original.getName());
        this.processTypeRef(original.getDeclaredTypeRef());
        if (original.getInitializer() != null) {
            this.write("=");
            this.process((EObject)original.getInitializer());
        }
        return DONE;
    }

    public Boolean caseBlock(Block original) {
        this.processBlock((Collection<? extends Statement>)original.getStatements());
        return DONE;
    }

    public Boolean caseVariableStatement(VariableStatement original) {
        this.write(this.keyword(original.getVarStmtKeyword()));
        this.write(' ');
        this.process((Iterable<? extends EObject>)original.getVarDeclsOrBindings(), ", ");
        this.write(';');
        return DONE;
    }

    public Boolean caseExportedVariableStatement(ExportedVariableStatement original) {
        if (!original.getDeclaredModifiers().isEmpty()) {
            this.processModifiers((EList<N4Modifier>)original.getDeclaredModifiers());
            this.write(' ');
        }
        this.caseVariableStatement((VariableStatement)original);
        return DONE;
    }

    private String keyword(VariableStatementKeyword varStmtKeyword) {
        switch (varStmtKeyword) {
            case LET: {
                return "let";
            }
            case CONST: {
                return "const";
            }
            case VAR: {
                return "var";
            }
        }
        throw new UnsupportedOperationException("unsupported variable statement keyword");
    }

    public Boolean caseVariableDeclaration(VariableDeclaration original) {
        this.processAnnotations((Iterable<? extends Annotation>)original.getAnnotations());
        this.write(original.getName());
        this.processTypeRef(original.getDeclaredTypeRef());
        if (original.getExpression() != null) {
            this.write(" = ");
            this.process((EObject)original.getExpression());
        }
        return DONE;
    }

    public Boolean caseExportedVariableDeclaration(ExportedVariableDeclaration original) {
        this.caseVariableDeclaration((VariableDeclaration)original);
        return DONE;
    }

    public Boolean caseVariableBinding(VariableBinding original) {
        this.process((EObject)original.getPattern());
        if (original.getExpression() != null) {
            this.write(" = ");
            this.process((EObject)original.getExpression());
        }
        return DONE;
    }

    public Boolean caseExportedVariableBinding(ExportedVariableBinding original) {
        this.caseExportedVariableBinding(original);
        return DONE;
    }

    public Boolean caseEmptyStatement(EmptyStatement original) {
        this.write(';');
        return DONE;
    }

    public Boolean caseExpressionStatement(ExpressionStatement original) {
        this.process((EObject)original.getExpression());
        if (!(original.getExpression() instanceof Snippet)) {
            this.write(';');
        }
        return DONE;
    }

    public Boolean caseIfStatement(IfStatement original) {
        this.write("if (");
        this.process((EObject)original.getExpression());
        this.write(") ");
        Statement ifStmnt = original.getIfStmt();
        this.processInBlock(ifStmnt);
        Statement elseStmnt = original.getElseStmt();
        if (elseStmnt != null) {
            this.write(" else ");
            if (elseStmnt instanceof IfStatement) {
                this.process((EObject)elseStmnt);
            } else {
                this.processInBlock(elseStmnt);
            }
        }
        return DONE;
    }

    public Boolean caseDoStatement(DoStatement original) {
        this.write("do ");
        this.processInBlock(original.getStatement());
        this.write(" while(");
        this.process((EObject)original.getExpression());
        this.write(");");
        return DONE;
    }

    public Boolean caseWhileStatement(WhileStatement original) {
        this.write("while(");
        this.process((EObject)original.getExpression());
        this.write(") ");
        this.processInBlock(original.getStatement());
        return DONE;
    }

    public Boolean caseForStatement(ForStatement original) {
        this.write("for(");
        if (!original.getVarDeclsOrBindings().isEmpty()) {
            this.write(this.keyword(original.getVarStmtKeyword()));
            this.write(' ');
            this.process((Iterable<? extends EObject>)original.getVarDeclsOrBindings(), ", ");
        } else if (original.getInitExpr() != null) {
            this.process((EObject)original.getInitExpr());
        }
        if (original.isForPlain()) {
            this.write(';');
            this.processIfNonNull((EObject)original.getExpression());
            this.write(';');
            this.processIfNonNull((EObject)original.getUpdateExpr());
        } else {
            this.write(original.isForOf() ? " of " : " in ");
            this.process((EObject)original.getExpression());
        }
        this.write(") ");
        this.processInBlock(original.getStatement());
        return DONE;
    }

    public Boolean caseContinueStatement(ContinueStatement original) {
        this.write("continue");
        if (original.getLabel() != null) {
            this.write(' ');
            this.write(original.getLabel().getName());
        }
        this.write(';');
        return DONE;
    }

    public Boolean caseBreakStatement(BreakStatement original) {
        this.write("break");
        if (original.getLabel() != null) {
            this.write(' ');
            this.write(original.getLabel().getName());
        }
        this.write(';');
        return DONE;
    }

    public Boolean caseReturnStatement(ReturnStatement original) {
        this.write("return");
        if (original.getExpression() != null) {
            this.write(' ');
            this.process((EObject)original.getExpression());
        }
        this.write(';');
        return DONE;
    }

    public Boolean caseWithStatement(WithStatement original) {
        this.write("with (");
        this.process((EObject)original.getExpression());
        this.write(") ");
        this.processInBlock(original.getStatement());
        return DONE;
    }

    public Boolean caseSwitchStatement(SwitchStatement original) {
        this.write("switch(");
        this.process((EObject)original.getExpression());
        this.write(") ");
        this.processBlockLike((Collection<? extends EObject>)original.getCases(), '{', null, null, '}');
        return DONE;
    }

    public Boolean caseCaseClause(CaseClause original) {
        this.write("case ");
        this.process((EObject)original.getExpression());
        this.write(':');
        boolean isFallthrough = original.getStatements().isEmpty();
        if (!isFallthrough) {
            this.out.indent();
            this.newLine();
            this.process((Iterable<? extends EObject>)original.getStatements(), () -> this.newLine());
            this.out.undent();
        }
        return DONE;
    }

    public Boolean caseDefaultClause(DefaultClause original) {
        this.write("default:");
        if (!original.getStatements().isEmpty()) {
            this.out.indent();
            this.newLine();
            this.process((Iterable<? extends EObject>)original.getStatements(), () -> this.newLine());
            this.out.undent();
        }
        return DONE;
    }

    public Boolean caseLabelledStatement(LabelledStatement original) {
        this.write(original.getName());
        this.write(": ");
        this.process((EObject)original.getStatement());
        return DONE;
    }

    public Boolean caseThrowStatement(ThrowStatement original) {
        this.write("throw ");
        this.process((EObject)original.getExpression());
        this.write(';');
        return DONE;
    }

    public Boolean caseTryStatement(TryStatement original) {
        this.write("try ");
        this.process((EObject)original.getBlock());
        this.processIfNonNull((EObject)original.getCatch());
        this.processIfNonNull((EObject)original.getFinally());
        return DONE;
    }

    public Boolean caseCatchBlock(CatchBlock original) {
        this.write(" catch(");
        this.process((EObject)original.getCatchVariable());
        this.write(") ");
        this.process((EObject)original.getBlock());
        return DONE;
    }

    public Boolean caseCatchVariable(CatchVariable original) {
        this.write(original.getName());
        return DONE;
    }

    public Boolean caseFinallyBlock(FinallyBlock original) {
        this.write(" finally ");
        this.process((EObject)original.getBlock());
        return DONE;
    }

    public Boolean caseDebuggerStatement(DebuggerStatement original) {
        this.write("debugger");
        this.write(';');
        return DONE;
    }

    public Boolean caseParenExpression(ParenExpression original) {
        this.write('(');
        this.process((EObject)original.getExpression());
        this.write(')');
        return DONE;
    }

    public Boolean caseIdentifierRef(IdentifierRef original) {
        IdentifierRef_IM original_IM = (IdentifierRef_IM)original;
        SymbolTableEntry ste = original_IM.getId_IM();
        this.write(ste.getName());
        return DONE;
    }

    public Boolean caseSuperLiteral(SuperLiteral original) {
        this.write("super");
        return DONE;
    }

    public Boolean caseThisLiteral(ThisLiteral original) {
        this.write("this");
        return DONE;
    }

    public Boolean caseArrayLiteral(ArrayLiteral original) {
        EList elements = original.getElements();
        boolean lastIsPadding = !elements.isEmpty() && elements.get(elements.size() - 1) instanceof ArrayPadding;
        String lastLineEnd = lastIsPadding || original.isTrailingComma() ? "," : null;
        this.processBlockLike((Collection<? extends EObject>)original.getElements(), '[', ",", lastLineEnd, ']');
        return DONE;
    }

    public Boolean caseArrayElement(ArrayElement original) {
        if (original.isSpread()) {
            this.write("...");
        }
        this.process((EObject)original.getExpression());
        return DONE;
    }

    public Boolean caseArrayPadding(ArrayPadding original) {
        return DONE;
    }

    public Boolean caseObjectLiteral(ObjectLiteral original) {
        this.processBlockLike((Collection<? extends EObject>)original.getPropertyAssignments(), '{', ",", null, '}');
        return DONE;
    }

    public Boolean casePropertyAssignmentAnnotationList(PropertyAssignmentAnnotationList original) {
        this.processAnnotations((Iterable<? extends Annotation>)original.getAnnotations());
        return DONE;
    }

    public Boolean casePropertyNameValuePair(PropertyNameValuePair original) {
        if (original.getDeclaredName() != null) {
            this.processPropertyName((PropertyNameOwner)original);
            this.write(": ");
        }
        this.process((EObject)original.getExpression());
        return DONE;
    }

    public Boolean casePropertyNameValuePairSingleName(PropertyNameValuePairSingleName original) {
        this.process((EObject)original.getIdentifierRef());
        if (original.getExpression() != null) {
            this.write(" = ");
            this.process((EObject)original.getExpression());
        }
        return DONE;
    }

    public Boolean casePropertyGetterDeclaration(PropertyGetterDeclaration original) {
        this.write("get ");
        this.processPropertyName((PropertyNameOwner)original);
        this.write("() ");
        this.process((EObject)original.getBody());
        return DONE;
    }

    public Boolean casePropertySetterDeclaration(PropertySetterDeclaration original) {
        this.write("set ");
        this.processPropertyName((PropertyNameOwner)original);
        this.write('(');
        this.process((EObject)original.getFpar());
        this.write(") ");
        this.process((EObject)original.getBody());
        return DONE;
    }

    public Boolean casePropertyMethodDeclaration(PropertyMethodDeclaration original) {
        if (original.isGenerator()) {
            this.write("* ");
        }
        this.processPropertyName((PropertyNameOwner)original);
        this.write('(');
        this.process((Iterable<? extends EObject>)original.getFpars(), ", ");
        this.write(") ");
        this.process((EObject)original.getBody());
        return DONE;
    }

    public Boolean casePropertySpread(PropertySpread original) {
        this.write("...");
        this.process((EObject)original.getExpression());
        return DONE;
    }

    public Boolean caseNewExpression(NewExpression original) {
        this.write("new ");
        this.process((EObject)original.getCallee());
        this.processTypeArgs((EList<? extends TypeArgument>)original.getTypeArgs());
        this.write('(');
        this.process((Iterable<? extends EObject>)original.getArguments(), ", ");
        this.write(')');
        return DONE;
    }

    public Boolean caseParameterizedCallExpression(ParameterizedCallExpression original) {
        this.processTypeArgs((EList<? extends TypeArgument>)original.getTypeArgs());
        this.process((EObject)original.getTarget());
        if (original.isOptionalChaining()) {
            this.write("?.");
        }
        this.write('(');
        this.process((Iterable<? extends EObject>)original.getArguments(), ", ");
        this.write(')');
        return DONE;
    }

    public Boolean caseImportCallExpression(ImportCallExpression original) {
        this.write("import");
        this.write('(');
        this.process((EObject)original.getArgument());
        this.write(')');
        return DONE;
    }

    public Boolean caseArgument(Argument original) {
        if (original.isSpread()) {
            this.write("... ");
        }
        this.process((EObject)original.getExpression());
        return DONE;
    }

    public Boolean caseIndexedAccessExpression(IndexedAccessExpression original) {
        this.process((EObject)original.getTarget());
        if (original.isOptionalChaining()) {
            this.write("?.");
        }
        this.write('[');
        this.process((EObject)original.getIndex());
        this.write(']');
        return DONE;
    }

    public Boolean caseParameterizedPropertyAccessExpression(ParameterizedPropertyAccessExpression original) {
        ParameterizedPropertyAccessExpression_IM original_IM = (ParameterizedPropertyAccessExpression_IM)original;
        String propName = original_IM.getPropertyName();
        this.process((EObject)original_IM.getTarget());
        if (TranspilerUtils.isLegalIdentifier(propName)) {
            if (original.isOptionalChaining()) {
                this.write('?');
            }
            this.write('.');
            this.processTypeArgs((EList<? extends TypeArgument>)original.getTypeArgs());
            this.write(propName);
        } else {
            if (original.isOptionalChaining()) {
                this.write("?.");
            }
            this.write('[');
            this.writeQuoted(propName);
            this.write(']');
        }
        return DONE;
    }

    public Boolean caseYieldExpression(YieldExpression original) {
        this.write('(');
        this.write("yield ");
        if (original.isMany()) {
            this.write("* ");
        }
        if (original.getExpression() != null) {
            this.process((EObject)original.getExpression());
        }
        this.write(')');
        return DONE;
    }

    public Boolean caseNullLiteral(NullLiteral original) {
        this.write(original.getValueAsString());
        return DONE;
    }

    public Boolean caseBooleanLiteral(BooleanLiteral original) {
        this.write(original.getValueAsString());
        return DONE;
    }

    public Boolean caseDoubleLiteral(DoubleLiteral original) {
        this.write(original.getValueAsString());
        return DONE;
    }

    public Boolean caseIntLiteral(IntLiteral original) {
        this.write(original.getValueAsString());
        return DONE;
    }

    public Boolean caseOctalIntLiteral(OctalIntLiteral original) {
        this.write(original.getValueAsString());
        return DONE;
    }

    public Boolean caseHexIntLiteral(HexIntLiteral original) {
        this.write(original.getValueAsString());
        return DONE;
    }

    public Boolean caseScientificIntLiteral(ScientificIntLiteral original) {
        this.write(original.getValueAsString());
        return DONE;
    }

    public Boolean caseNumericLiteral(NumericLiteral original) {
        this.write(original.getValueAsString());
        return DONE;
    }

    public Boolean caseStringLiteral(StringLiteral original) {
        if (original.getRawValue() != null) {
            this.write(original.getRawValue());
        } else {
            this.write(this.quote(original.getValueAsString()));
        }
        return DONE;
    }

    public Boolean caseTemplateLiteral(TemplateLiteral original) {
        int indentLevelOLD = this.out.getIndentLevel();
        try {
            this.out.setIndentLevel(0);
            for (Expression segment : original.getSegments()) {
                this.process((EObject)segment);
            }
        }
        finally {
            this.out.setIndentLevel(indentLevelOLD);
        }
        return DONE;
    }

    public Boolean caseTemplateSegment(TemplateSegment original) {
        if (this.out.getIndentLevel() != 0) {
            throw new IllegalStateException("parent TemplateLiteral did not reset the indent level to 0");
        }
        if (original.getRawValue() != null) {
            this.write(original.getRawValue());
        } else {
            TemplateLiteral parent = (TemplateLiteral)original.eContainer();
            EList segments = parent.getSegments();
            int len = segments.size();
            Expression first = (Expression)segments.get(0);
            Expression last = (Expression)segments.get(len - 1);
            if (original == first) {
                this.write("`");
            } else {
                this.write("}");
            }
            String rawValue = ValueConverterUtils.convertToEscapedString((String)original.getValueAsString(), (boolean)false);
            this.write(rawValue);
            if (original == last) {
                this.write("`");
            } else {
                this.write("${");
            }
        }
        return DONE;
    }

    public Boolean caseRegularExpressionLiteral(RegularExpressionLiteral original) {
        this.write(original.getValueAsString());
        return DONE;
    }

    public Boolean casePostfixExpression(PostfixExpression original) {
        this.process((EObject)original.getExpression());
        this.write(original.getOp().getLiteral());
        return DONE;
    }

    public Boolean caseUnaryExpression(UnaryExpression original) {
        UnaryOperator op = original.getOp();
        this.write(op.getLiteral());
        if (op == UnaryOperator.TYPEOF || op == UnaryOperator.DELETE || op == UnaryOperator.VOID) {
            this.write(' ');
        }
        this.process((EObject)original.getExpression());
        return DONE;
    }

    public Boolean caseCastExpression(CastExpression original) {
        this.process((EObject)original.getExpression());
        this.write(" as ");
        this.write(original.getTargetTypeRef().getTypeRefAsString());
        return DONE;
    }

    public Boolean caseMultiplicativeExpression(MultiplicativeExpression original) {
        this.processBinaryExpression(original.getLhs(), original.getOp().getLiteral(), original.getRhs());
        return DONE;
    }

    public Boolean caseAdditiveExpression(AdditiveExpression original) {
        this.processBinaryExpression(original.getLhs(), original.getOp().getLiteral(), original.getRhs());
        return DONE;
    }

    public Boolean caseShiftExpression(ShiftExpression original) {
        this.processBinaryExpression(original.getLhs(), original.getOp().getLiteral(), original.getRhs());
        return DONE;
    }

    public Boolean caseRelationalExpression(RelationalExpression original) {
        this.processBinaryExpression(original.getLhs(), original.getOp().getLiteral(), original.getRhs());
        return DONE;
    }

    public Boolean caseEqualityExpression(EqualityExpression original) {
        this.processBinaryExpression(original.getLhs(), original.getOp().getLiteral(), original.getRhs());
        return DONE;
    }

    public Boolean caseBinaryBitwiseExpression(BinaryBitwiseExpression original) {
        this.processBinaryExpression(original.getLhs(), original.getOp().getLiteral(), original.getRhs());
        return DONE;
    }

    public Boolean caseBinaryLogicalExpression(BinaryLogicalExpression original) {
        this.processBinaryExpression(original.getLhs(), original.getOp().getLiteral(), original.getRhs());
        return DONE;
    }

    public Boolean caseAssignmentExpression(AssignmentExpression original) {
        this.processBinaryExpression(original.getLhs(), original.getOp().getLiteral(), original.getRhs());
        return DONE;
    }

    public Boolean caseConditionalExpression(ConditionalExpression original) {
        this.process((EObject)original.getExpression());
        this.write(" ? ");
        this.process((EObject)original.getTrueExpression());
        this.write(" : ");
        this.process((EObject)original.getFalseExpression());
        return DONE;
    }

    public Boolean caseCommaExpression(CommaExpression original) {
        this.process((Iterable<? extends EObject>)original.getExprs(), ", ");
        return DONE;
    }

    public Boolean caseAwaitExpression(AwaitExpression original) {
        this.write("await ");
        this.process((EObject)original.getExpression());
        return DONE;
    }

    public Boolean caseObjectBindingPattern(ObjectBindingPattern original) {
        this.processBlockLike((Collection<? extends EObject>)original.getProperties(), '{', ",", null, '}');
        return DONE;
    }

    public Boolean caseArrayBindingPattern(ArrayBindingPattern original) {
        EList elements = original.getElements();
        BindingElement last = !elements.isEmpty() ? (BindingElement)elements.get(elements.size() - 1) : null;
        boolean lastIsElision = last != null && last.isElision();
        String lastLineEnd = lastIsElision ? "," : null;
        this.processBlockLike((Collection<? extends EObject>)original.getElements(), '[', ",", lastLineEnd, ']');
        return DONE;
    }

    public Boolean caseBindingProperty(BindingProperty original) {
        if (original.getDeclaredName() == null) {
            this.process((EObject)original.getValue().getVarDecl());
        } else {
            this.processPropertyName((PropertyNameOwner)original);
            this.write(": ");
            this.process((EObject)original.getValue());
        }
        return DONE;
    }

    public Boolean caseBindingElement(BindingElement original) {
        if (original.isRest()) {
            this.write("... ");
        }
        if (original.getNestedPattern() != null) {
            this.process((EObject)original.getNestedPattern());
            if (original.getExpression() != null) {
                this.write(" = ");
                this.process((EObject)original.getExpression());
            }
        } else if (original.getVarDecl() != null) {
            this.process((EObject)original.getVarDecl());
        }
        return DONE;
    }

    public Boolean caseSnippet(Snippet original) {
        String code = original.getCode();
        if (code.endsWith("\n")) {
            code = code.substring(0, code.length() - 1);
        }
        this.write(code);
        return DONE;
    }

    private void write(char c) {
        try {
            this.out.append(c);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    private void write(CharSequence csq) {
        try {
            this.out.append(csq);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    private void writeQuoted(String csq) {
        this.write(this.quote(csq));
    }

    private void writeQuotedIfNonIdentifier(String csq) {
        if (!TranspilerUtils.isLegalIdentifier(csq)) {
            this.writeQuoted(csq);
        } else {
            this.write(csq);
        }
    }

    private void newLine() {
        try {
            this.out.newLine();
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    private void process(Iterable<? extends EObject> elemsInIM, String separator) {
        Iterator<? extends EObject> iter = elemsInIM.iterator();
        while (iter.hasNext()) {
            this.doSwitch(iter.next());
            if (separator == null || !iter.hasNext()) continue;
            this.write(separator);
        }
    }

    private void process(Iterable<? extends EObject> elemsInIM, Runnable separator) {
        Iterator<? extends EObject> iter = elemsInIM.iterator();
        while (iter.hasNext()) {
            this.process(iter.next());
            if (separator == null || !iter.hasNext()) continue;
            separator.run();
        }
    }

    private void processIfNonNull(EObject elemInIM) {
        if (elemInIM != null) {
            this.doSwitch(elemInIM);
        }
    }

    private void process(EObject elemInIM) {
        if (elemInIM == null) {
            throw new IllegalArgumentException("element to process may not be null");
        }
        this.doSwitch(elemInIM);
    }

    private void processAnnotations(Iterable<? extends Annotation> annotations) {
        this.processAnnotations(annotations, true);
    }

    private void processAnnotations(Iterable<? extends Annotation> annotations, boolean multiLine) {
    }

    private void processPropertyName(PropertyNameOwner owner) {
        LiteralOrComputedPropertyName name = owner.getDeclaredName();
        PropertyNameKind kind = name.getKind();
        if (kind == PropertyNameKind.COMPUTED) {
            this.write('[');
            this.process((EObject)name.getExpression());
            this.write(']');
        } else {
            String propName = name.getName();
            if (propName.startsWith("#")) {
                this.write("[Symbol.");
                this.write(propName.substring(1));
                this.write(']');
            } else {
                this.writeQuotedIfNonIdentifier(propName);
            }
        }
    }

    private void processModifiers(EList<N4Modifier> modifiers) {
        int len = modifiers.size();
        int idx = 0;
        while (idx < len) {
            if (idx > 0) {
                this.write(' ');
            }
            this.write(((N4Modifier)modifiers.get(idx)).getName());
            ++idx;
        }
    }

    private void processReturnTypeRef(TypeRef returnTypeRef) {
        if (returnTypeRef == null) {
            return;
        }
        throw new IllegalStateException("Return type reference still left in code. typeref=" + returnTypeRef + " in " + EcoreUtil2.getContainerOfType((EObject)returnTypeRef, FunctionOrFieldAccessor.class));
    }

    private void processTypeRef(TypeRef declaredTypeRef) {
        if (declaredTypeRef == null) {
            return;
        }
        throw new IllegalStateException("Type reference still left in code. typeRef=" + declaredTypeRef);
    }

    private void processTypeParams(EList<TypeVariable> typeParams) {
        if (typeParams.isEmpty()) {
            return;
        }
        throw new IllegalStateException("Type reference still left in code. typeParams=" + typeParams);
    }

    private void processTypeArgs(EList<? extends TypeArgument> typeArgs) {
        if (typeArgs.isEmpty()) {
            return;
        }
        throw new IllegalStateException("Type arguments still left in code. typeArgs=" + typeArgs);
    }

    private void processInBlock(Statement statement) {
        if (statement instanceof Block) {
            this.processBlock((Collection<? extends Statement>)((Block)statement).getStatements());
        } else {
            this.processBlock(Collections.singletonList(statement));
        }
    }

    private void processBlock(Collection<? extends Statement> statements) {
        this.processBlockLike(statements, '{', null, null, '}');
    }

    private void processBlockLike(Collection<? extends EObject> elemsInIM, char open, String lineEnd, String lastLineEnd, char close) {
        if (elemsInIM.isEmpty()) {
            this.write(open);
            this.write(close);
            return;
        }
        this.write(open);
        this.out.indent();
        this.newLine();
        this.process(elemsInIM, () -> {
            if (lineEnd != null) {
                this.write(lineEnd);
            }
            this.newLine();
        });
        if (lastLineEnd != null) {
            this.write(lineEnd);
        }
        this.out.undent();
        this.newLine();
        this.write(close);
    }

    private void processBinaryExpression(Expression lhs, String op, Expression rhs) {
        this.process((EObject)lhs);
        this.write(' ');
        this.write(op);
        this.write(' ');
        this.process((EObject)rhs);
    }

    private String quote(String txt) {
        return String.valueOf('\'') + ValueConverterUtils.convertToEscapedString((String)txt, (boolean)false) + '\'';
    }

    private void throwUnsupportedSyntax() {
        throw new UnsupportedOperationException("syntax not supported by pretty printer");
    }
}

