/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import com.google.common.base.Strings;
import java.util.Set;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.DataCollectors;
import org.eclipse.n4js.smith.DataSeries;

public class CollectedDataAccess {
    public static void setPaused(boolean paused) {
        CollectedDataAccess.getCollectors().setPaused(paused);
    }

    public static void purgeAllData() {
        CollectedDataAccess.getCollectors().getRootCollectors().values().forEach(c -> c.purgeData());
    }

    public static Set<String> getCollectorsKeys() {
        return CollectedDataAccess.getCollectors().getRootCollectors().keySet();
    }

    public static boolean hasNestedData(String key) {
        DataCollector dataCollector = CollectedDataAccess.getCollectors().getRootCollectors().get(key);
        if (dataCollector == null) {
            throw new RuntimeException("Can't locate data collector for the key: " + key);
        }
        return !dataCollector.getChildren().isEmpty();
    }

    public static DataSeries getDataSeries(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            throw new RuntimeException("Invalid key");
        }
        DataCollector dataCollector = CollectedDataAccess.getCollectors().getRootCollectors().get(key);
        if (dataCollector == null) {
            throw new RuntimeException("Key not found: " + key);
        }
        DataSeries rootSeries = new DataSeries(key, dataCollector.getData());
        CollectedDataAccess.collectSeries(dataCollector, rootSeries);
        return rootSeries;
    }

    private static void collectSeries(DataCollector parentCollector, DataSeries parentSeries) {
        parentCollector.childrenKeys().forEach(name -> {
            DataCollector collector = parentCollector.getChild((String)name);
            DataSeries series = new DataSeries((String)name, collector.getData());
            parentSeries.addChild(series);
            CollectedDataAccess.collectSeries(collector, series);
        });
    }

    protected static DataCollectors getCollectors() {
        return DataCollectors.INSTANCE;
    }
}

