/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.ui.navigator.internal.N4JSProjectExplorerHelper;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider2;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.xtext.util.Arrays;

@Singleton
public class N4JSProjectExplorerContentProvider
extends WorkbenchContentProvider
implements ExternalLibraryPreferenceStore.StoreUpdatedListener,
IPipelinedTreeContentProvider2 {
    private static final Logger LOGGER = Logger.getLogger(N4JSProjectExplorerContentProvider.class);
    @Inject
    private N4JSProjectExplorerHelper helper;
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;
    private final Map<IProject, Object[]> virtualNodeCache = Maps.newConcurrentMap();

    @Inject
    public N4JSProjectExplorerContentProvider(ExternalLibraryPreferenceStore store) {
        store.addListener((ExternalLibraryPreferenceStore.StoreUpdatedListener)this);
        int eventMask = 9;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this::cleanBuildOrManifestChangedEvent, eventMask);
    }

    private void cleanBuildOrManifestChangedEvent(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        int buildKind = event.getBuildKind();
        if (buildKind == 15) {
            Object obj = event.getSource();
            if (obj instanceof IProject) {
                IProject project = (IProject)obj;
                this.virtualNodeCache.remove(project);
            }
            if (obj instanceof IWorkspace) {
                this.virtualNodeCache.clear();
            }
            return;
        }
        if (event.getDelta() == null) {
            return;
        }
        try {
            event.getDelta().accept(delta -> {
                IFile file;
                IResource resource = delta.getResource();
                if (resource instanceof IFile && "package.json".equals((file = (IFile)resource).getName())) {
                    IProject project;
                    if (delta.getKind() == 2 && (delta.getFlags() & 0x2000) != 0) {
                        this.virtualNodeCache.clear();
                    }
                    if (delta.getKind() == 4 && (project = file.getProject()) != null && project.isAccessible()) {
                        this.virtualNodeCache.remove(project);
                    }
                }
                return true;
            });
        }
        catch (CoreException e) {
            LOGGER.error((Object)"Error while refreshing virtual nodes in navigator.", (Throwable)e);
        }
    }

    public Object[] getChildren(Object element) {
        if (this.workingSetManagerBroker.isWorkingSetTopLevel()) {
            if (element instanceof IWorkspaceRoot) {
                WorkingSetManager manager = this.workingSetManagerBroker.getActiveManager();
                if (manager != null) {
                    return manager.getWorkingSets();
                }
            } else if (element instanceof WorkingSet) {
                return ((WorkingSet)element).getElements();
            }
        }
        Object[] children = super.getChildren(element);
        if (element instanceof IProject && ((IProject)element).isAccessible()) {
            return Arrays2.add((Object[])children, (Object[])this.getVirtualNodes((IProject)element));
        }
        return children;
    }

    public Object getParent(Object element) {
        WorkingSetManager activeManager;
        if (element instanceof IProject && this.workingSetManagerBroker.isWorkingSetTopLevel() && (activeManager = this.workingSetManagerBroker.getActiveManager()) != null) {
            WorkingSet[] workingSetArray = activeManager.getWorkingSets();
            int n = workingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorkingSet workingSet = workingSetArray[n2];
                Object[] elements = workingSet.getElements();
                if (!Arrays2.isEmpty((Object[])elements) && Arrays.contains((Object[])elements, (Object)element)) {
                    return workingSet;
                }
                ++n2;
            }
        }
        return super.getParent(element);
    }

    public void storeUpdated(ExternalLibraryPreferenceStore store, IProgressMonitor monitor) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1).newChild(projects.length);
        this.virtualNodeCache.clear();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.getVirtualNodes(project);
            subMonitor.worked(1);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getVirtualNodes(IProject project) {
        Object[] objects = this.virtualNodeCache.get(project);
        if (objects == null) {
            IProject iProject = project;
            synchronized (iProject) {
                objects = this.virtualNodeCache.get(project);
                if (objects == null) {
                    objects = this.helper.getVirtualNodesForProject(project);
                    this.virtualNodeCache.put(project, objects);
                }
            }
        }
        return objects;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
        ArrayList children = Lists.newArrayList((Object[])this.getChildren(aParent));
        theCurrentChildren.clear();
        theCurrentChildren.addAll(children);
    }

    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
        ArrayList children = Lists.newArrayList((Object[])this.getElements(anInput));
        theCurrentElements.clear();
        theCurrentElements.addAll(children);
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        return this.getParent(anObject);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        return null;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        return null;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        return true;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return true;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public boolean hasPipelinedChildren(Object anInput, boolean currentHasChildren) {
        return currentHasChildren || this.getChildren(anInput).length > 0;
    }
}

