/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.ui;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.runner.ui.AbstractLaunchConfigurationMainTab;
import org.eclipse.n4js.runner.ui.RunnerUiUtils;
import org.eclipse.n4js.runner.ui.SupportingRunnerPropertyTester;

public class RunnerLaunchConfigurationMainTab
extends AbstractLaunchConfigurationMainTab {
    @Inject
    private SupportingRunnerPropertyTester supportTester;

    @Override
    protected String getResourceLabel() {
        return "File to Run";
    }

    @Override
    protected String getResourceRunConfigKey() {
        return "USER_SELECTION";
    }

    @Override
    protected int getAcceptedResourceTypes() {
        return 1;
    }

    @Override
    protected boolean checkSubclassSpecificConstraints(ILaunchConfiguration launchConfig, IResource resource, URI resourceUri) {
        return this.checkFileToRunSupportedByRunner(launchConfig, resource, resourceUri);
    }

    private boolean checkFileToRunSupportedByRunner(ILaunchConfiguration launchConfig, IResource resource, URI resourceUri) {
        IFile fileToRun = (IFile)resource;
        String runnerId = RunnerUiUtils.getRunnerId(launchConfig, false);
        if (runnerId == null) {
            this.setErrorMessage("cannot read runner ID from launch configuration");
            return false;
        }
        Object[] args = new Object[]{runnerId};
        boolean isSupported = this.supportTester.test(fileToRun, "isSupportingRunner", args, "");
        if (!isSupported) {
            this.setErrorMessage("runner cannot handle provided file to run");
            return false;
        }
        return true;
    }
}

