/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.n4js.hlc.base.HeadlessExtensionRegistrationHelper;
import org.eclipse.n4js.ide.server.N4JSWorkspaceManager;
import org.eclipse.n4js.ide.xtext.server.XLanguageServerImpl;
import org.eclipse.n4js.projectModel.lsp.ex.IProjectConfigEx;
import org.eclipse.xtext.workspace.IWorkspaceConfig;

public class N4JSLanguageServerImpl
extends XLanguageServerImpl {
    @Inject
    public void registerExtensions(HeadlessExtensionRegistrationHelper helper) {
        helper.unregisterExtensions();
        helper.registerExtensions();
    }

    @Override
    public void didOpen(DidOpenTextDocumentParams params) {
        String uriString = params.getTextDocument().getUri();
        if (!this.isInOutputFolder(uriString)) {
            super.didOpen(params);
        }
    }

    @Override
    public void didClose(DidCloseTextDocumentParams params) {
        String uriString = params.getTextDocument().getUri();
        if (!this.isInOutputFolder(uriString)) {
            super.didClose(params);
        }
    }

    @Override
    public void didChange(DidChangeTextDocumentParams params) {
        String uriString = params.getTextDocument().getUri();
        if (!this.isInOutputFolder(uriString)) {
            super.didChange(params);
        }
    }

    @Override
    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        Iterator fileEventIter = params.getChanges().iterator();
        while (fileEventIter.hasNext()) {
            FileEvent fileEvent = (FileEvent)fileEventIter.next();
            String uriString = fileEvent.getUri();
            if (!this.isInOutputFolder(uriString)) continue;
            fileEventIter.remove();
        }
        if (!params.getChanges().isEmpty()) {
            super.didChangeWatchedFiles(params);
        }
    }

    private boolean isInOutputFolder(String uriString) {
        URI uri = URI.createURI((String)uriString);
        if (!uri.hasAuthority()) {
            throw new RuntimeException("Missing authority in uri " + uriString);
        }
        N4JSWorkspaceManager workspaceManager = (N4JSWorkspaceManager)this.getWorkspaceManager();
        IWorkspaceConfig workspaceConfig = workspaceManager.getWorkspaceConfig();
        IProjectConfigEx projectConfig = (IProjectConfigEx)workspaceConfig.findProjectContaining(uri);
        boolean isInOutputFolder = projectConfig != null && projectConfig.isInOutputFolder(uri);
        return isInOutputFolder;
    }

    @Override
    public LanguageClient getLanguageClient() {
        return super.getLanguageClient();
    }
}

