/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.packagejson;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.projectDescription.ModuleFilter;
import org.eclipse.n4js.projectDescription.ModuleFilterSpecifier;
import org.eclipse.n4js.projectDescription.ModuleFilterType;
import org.eclipse.n4js.projectDescription.ProjectDescriptionFactory;
import org.eclipse.n4js.projectDescription.ProjectDescriptionPackage;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectDescription.SourceContainerDescription;
import org.eclipse.n4js.projectDescription.SourceContainerType;

public class PackageJsonUtils {
    public static ProjectReference asProjectReferenceOrNull(JSONValue jsonValue) {
        String valueStr = JSONModelUtils.asNonEmptyStringOrNull((JSONValue)jsonValue);
        if (!Strings.isNullOrEmpty((String)valueStr)) {
            ProjectReference result = ProjectDescriptionFactory.eINSTANCE.createProjectReference();
            result.setProjectName(valueStr);
            return result;
        }
        return null;
    }

    public static List<ProjectReference> asProjectReferencesInArrayOrEmpty(JSONValue jsonValue) {
        return JSONModelUtils.asArrayElementsOrEmpty((JSONValue)jsonValue).stream().map(PackageJsonUtils::asProjectReferenceOrNull).filter(ref -> ref != null).collect(Collectors.toList());
    }

    public static ModuleFilter asModuleFilterOrNull(NameValuePair pair) {
        List<ModuleFilterSpecifier> mspecs;
        ModuleFilterType type = PackageJsonUtils.parseModuleFilterType(pair.getName());
        if (type != null && !(mspecs = PackageJsonUtils.asModuleFilterSpecifierInArrayOrEmpty(pair.getValue())).isEmpty()) {
            ModuleFilter mfilter = ProjectDescriptionFactory.eINSTANCE.createModuleFilter();
            mfilter.setModuleFilterType(type);
            mfilter.getModuleSpecifiers().addAll(mspecs);
            return mfilter;
        }
        return null;
    }

    public static List<ModuleFilter> asModuleFiltersInObjectOrEmpty(JSONValue jsonValue) {
        return JSONModelUtils.asNameValuePairsOrEmpty((JSONValue)jsonValue).stream().map(PackageJsonUtils::asModuleFilterOrNull).filter(mfilter -> mfilter != null).collect(Collectors.toList());
    }

    public static ModuleFilterSpecifier asModuleFilterSpecifierOrNull(JSONValue jsonValue) {
        String moduleStr;
        String singleString = JSONModelUtils.asNonEmptyStringOrNull((JSONValue)jsonValue);
        if (singleString != null) {
            return PackageJsonUtils.createModuleFilterSpecifier(null, singleString);
        }
        List pairs = JSONModelUtils.asNameValuePairsOrEmpty((JSONValue)jsonValue);
        NameValuePair pathNVP = pairs.stream().filter(p -> PackageJsonProperties.NV_SOURCE_CONTAINER.name.equals(p.getName())).findFirst().orElse(null);
        NameValuePair moduleNVP = pairs.stream().filter(p -> PackageJsonProperties.NV_MODULE.name.equals(p.getName())).findFirst().orElse(null);
        String pathStr = pathNVP != null ? JSONModelUtils.asNonEmptyStringOrNull((JSONValue)pathNVP.getValue()) : null;
        String string = moduleStr = moduleNVP != null ? JSONModelUtils.asNonEmptyStringOrNull((JSONValue)moduleNVP.getValue()) : null;
        if (moduleStr != null) {
            return PackageJsonUtils.createModuleFilterSpecifier(pathStr, moduleStr);
        }
        return null;
    }

    private static ModuleFilterSpecifier createModuleFilterSpecifier(String sourcePath, String moduleSpecifierWithWildcard) {
        ModuleFilterSpecifier result = ProjectDescriptionFactory.eINSTANCE.createModuleFilterSpecifier();
        result.setSourcePath(sourcePath);
        result.setModuleSpecifierWithWildcard(moduleSpecifierWithWildcard);
        return result;
    }

    public static List<ModuleFilterSpecifier> asModuleFilterSpecifierInArrayOrEmpty(JSONValue jsonValue) {
        return JSONModelUtils.asArrayElementsOrEmpty((JSONValue)jsonValue).stream().map(PackageJsonUtils::asModuleFilterSpecifierOrNull).filter(mspec -> mspec != null).collect(Collectors.toList());
    }

    public static SourceContainerDescription asSourceContainerDescriptionOrNull(NameValuePair pair) {
        SourceContainerType type = PackageJsonUtils.parseSourceContainerType(pair.getName());
        List paths = JSONModelUtils.asNonEmptyStringsInArrayOrEmpty((JSONValue)pair.getValue());
        if (type != null && !paths.isEmpty()) {
            SourceContainerDescription sourceContainerDescription = ProjectDescriptionFactory.eINSTANCE.createSourceContainerDescription();
            sourceContainerDescription.setSourceContainerType(type);
            sourceContainerDescription.getPaths().addAll((Collection)paths);
            return sourceContainerDescription;
        }
        return null;
    }

    public static List<SourceContainerDescription> asSourceContainerDescriptionsOrEmpty(JSONValue sourcesSection) {
        return JSONModelUtils.asNameValuePairsOrEmpty((JSONValue)sourcesSection).stream().map(PackageJsonUtils::asSourceContainerDescriptionOrNull).filter(scd -> scd != null).collect(Collectors.toList());
    }

    public static ModuleFilterType parseModuleFilterType(String value) {
        if (value.equals("noValidate")) {
            return ModuleFilterType.NO_VALIDATE;
        }
        return null;
    }

    public static String getModuleFilterTypeStringRepresentation(ModuleFilterType type) {
        if (type == ModuleFilterType.NO_VALIDATE) {
            return "noValidate";
        }
        return "<invalid module filter type>";
    }

    public static ProjectType parseProjectType(String projectTypeStr) {
        if ("runtimeEnvironment".equals(projectTypeStr)) {
            return ProjectType.RUNTIME_ENVIRONMENT;
        }
        if ("runtimeLibrary".equals(projectTypeStr)) {
            return ProjectType.RUNTIME_LIBRARY;
        }
        return PackageJsonUtils.parseEnumLiteral(ProjectDescriptionPackage.eINSTANCE.getProjectType(), ProjectType.class, projectTypeStr);
    }

    public static String getProjectTypeStringRepresentation(ProjectType projectType) {
        switch (projectType) {
            case RUNTIME_ENVIRONMENT: {
                return "runtimeEnvironment";
            }
            case RUNTIME_LIBRARY: {
                return "runtimeLibrary";
            }
        }
        return projectType.getName();
    }

    public static SourceContainerType parseSourceContainerType(String sourceContainerTypeStr) {
        return PackageJsonUtils.parseEnumLiteral(ProjectDescriptionPackage.eINSTANCE.getSourceContainerType(), SourceContainerType.class, sourceContainerTypeStr);
    }

    public static String getSourceContainerTypeStringRepresentation(SourceContainerType type) {
        return type.getLiteral().toLowerCase();
    }

    private static <T extends Enumerator> T parseEnumLiteral(EEnum emfEnumType, Class<T> javaEnumType, String enumLiteralStr) {
        EEnumLiteral emfLit;
        EEnumLiteral eEnumLiteral = emfLit = enumLiteralStr != null ? (EEnumLiteral)emfEnumType.getELiterals().stream().filter(lit -> lit.getName().equalsIgnoreCase(enumLiteralStr)).findFirst().orElse(null) : null;
        if (emfLit == null) {
            return null;
        }
        Enumerator javaLit = emfLit.getInstance();
        Enumerator javaLitCasted = javaEnumType.isInstance(javaLit) ? javaLit : null;
        return (T)javaLitCasted;
    }

    public static <T extends JSONValue> List<T> findNameValuePairs(Resource jsonResource, PackageJsonProperties prop, Class<T> clazz) {
        JSONDocument jsonDocument;
        JSONValue jsonContent;
        String[] pathElements = prop.getPathElements();
        LinkedList nameValuePairs = new LinkedList();
        EList contents = jsonResource.getContents();
        EObject rootElem = (EObject)contents.get(0);
        if (rootElem instanceof JSONDocument && (jsonContent = (jsonDocument = (JSONDocument)rootElem).getContent()) instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)jsonContent;
            for (NameValuePair child : jsonObj.getNameValuePairs()) {
                PackageJsonUtils.searchNameValuePair(child, pathElements, 0, clazz, nameValuePairs);
            }
        }
        return nameValuePairs;
    }

    private static <T extends JSONValue> void searchNameValuePair(NameValuePair valuePair, String[] pathElems, int i, Class<T> clazz, List<T> result) {
        String searchName = pathElems[i];
        String jsonName = valuePair.getName();
        JSONValue jsonValue = valuePair.getValue();
        if (i >= pathElems.length || !searchName.equals(jsonName)) {
            return;
        }
        if (i == pathElems.length - 1 && (clazz == null || clazz.isAssignableFrom(jsonValue.getClass()))) {
            result.add(jsonValue);
            return;
        }
        if (jsonValue instanceof JSONObject) {
            JSONObject jObj = (JSONObject)jsonValue;
            for (NameValuePair child : jObj.getNameValuePairs()) {
                PackageJsonUtils.searchNameValuePair(child, pathElems, i + 1, clazz, result);
            }
        }
    }
}

