/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.n4js.smith.ui.graph.Node;
import org.eclipse.n4js.smith.ui.graph.Point;
import org.eclipse.n4js.smith.ui.graph.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

public class GraphUtils {
    private static final Map<RGB, Color> colors = new HashMap<RGB, Color>();

    public static Color getColor(int red, int green, int blue) {
        return GraphUtils.getColor(new RGB(red, green, blue));
    }

    public static Color getColor(RGB rgb) {
        if (!colors.containsKey(rgb)) {
            RGB rgbKey = new RGB(rgb.red, rgb.green, rgb.blue);
            Color rgbColor = new Color((Device)Display.getCurrent(), rgb.red, rgb.green, rgb.blue);
            colors.put(rgbKey, rgbColor);
        }
        return colors.get(rgb);
    }

    public static Rectangle getClip(GC gc) {
        org.eclipse.swt.graphics.Rectangle clip = gc.getClipping();
        return new Rectangle(clip.x, clip.y, clip.width, clip.height);
    }

    public static void drawString(GC gc, String str, float x, float y) {
        GraphUtils.drawString(gc, str, x, y, 0.0f, 0.0f, 255);
    }

    public static void drawString(GC gc, String str, float x, float y, float width, float height, int bgAlpha) {
        if (str == null) {
            return;
        }
        org.eclipse.swt.graphics.Point size = gc.stringExtent(str);
        int posX = Math.round(x + width / 2.0f - (float)(size.x / 2));
        int posY = Math.round(y + height / 2.0f - (float)(size.y / 2));
        if (bgAlpha >= 255) {
            gc.drawString(str, posX, posY);
        } else {
            gc.drawString(str, posX, posY, true);
            if (bgAlpha > 0) {
                gc.setAlpha(bgAlpha);
                gc.fillRectangle(posX, posY, size.x, size.y);
                gc.setAlpha(255);
            }
        }
    }

    public static List<Node> getNodesForElements(Collection<?> elements, List<? extends Node> allNodes) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Object elem : elements) {
            Node node = GraphUtils.getNodeForElement(elem, allNodes);
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static Node getNodeForElement(Object element, List<? extends Node> allNodes) {
        for (Node node : allNodes) {
            if (node.getElement() != element) continue;
            return node;
        }
        return null;
    }

    public static Rectangle getBounds(Stream<Node> nodes) {
        Iterator i = nodes.iterator();
        if (i.hasNext()) {
            float xMin = Float.MAX_VALUE;
            float xMax = Float.MIN_VALUE;
            float yMin = Float.MAX_VALUE;
            float yMax = Float.MIN_VALUE;
            while (i.hasNext()) {
                Node n = (Node)i.next();
                xMin = Math.min(xMin, n.getX());
                yMin = Math.min(yMin, n.getY());
                xMax = Math.max(xMax, n.getX() + n.getWidth());
                yMax = Math.max(yMax, n.getY() + n.getHeight());
            }
            return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
        }
        return Rectangle.EMPTY;
    }

    public static void drawLine(GC gc, Point p1, Point p2, boolean directed) {
        gc.drawLine(Math.round(p1.x), Math.round(p1.y), Math.round(p2.x), Math.round(p2.y));
        if (directed) {
            GraphUtils.drawArrowHead(gc, p1, p2);
        }
    }

    public static void drawArc(GC gc, Point p1, Point p2, boolean directed) {
        gc.drawLine(Math.round(p1.x), Math.round(p1.y), Math.round(p2.x), Math.round(p2.y));
        if (directed) {
            GraphUtils.drawArrowHead(gc, p1, p2);
        }
    }

    public static float[] arc(GC gc, Point ctr, Point src, Point tgt) {
        Path path = new Path(gc.getDevice());
        path.moveTo((float)((int)src.x), (float)((int)src.y));
        path.quadTo((float)((int)ctr.x), (float)((int)ctr.y), (float)((int)tgt.x), (float)((int)tgt.y));
        gc.drawPath(path);
        float[] pp = path.getPathData().points;
        return pp;
    }

    public static float[] arcReversed(GC gc, Point src, Point tgt) {
        Path path = new Path(gc.getDevice());
        int ydiff = (int)((tgt.y - src.y) / 3.0f);
        path.moveTo((float)((int)src.x), (float)((int)src.y));
        path.cubicTo((float)((int)src.x), (float)((int)src.y + ydiff), (float)((int)tgt.x), (float)((int)tgt.y - ydiff * 2), (float)((int)tgt.x), (float)((int)tgt.y));
        gc.drawPath(path);
        float[] pp = path.getPathData().points;
        return pp;
    }

    public static float[] arcSelf(GC gc, Point src, Point tgt) {
        Path path = new Path(gc.getDevice());
        int diffH = 10;
        int diff = diffH * 3;
        path.moveTo((float)((int)src.x), (float)((int)src.y));
        path.cubicTo((float)((int)src.x + diff), (float)((int)src.y - diffH), (float)((int)tgt.x), (float)((int)tgt.y - diff), (float)((int)tgt.x), (float)((int)tgt.y));
        gc.drawPath(path);
        float[] pp = path.getPathData().points;
        return pp;
    }

    public static Point pointOnRect(Point p, Rectangle rect) {
        float maxYx;
        float minYx;
        float maxXy;
        float minXy;
        float minX = rect.x;
        float minY = rect.y;
        float maxX = rect.x + rect.width;
        float maxY = rect.y + rect.height;
        if (minX < p.x && p.x < maxX && minY < p.y && p.y < maxY) {
            return null;
        }
        float midX = (minX + maxX) / 2.0f;
        float midY = (minY + maxY) / 2.0f;
        float m = (midY - p.y) / (midX - p.x);
        if (p.x <= midX && minY <= (minXy = m * (minX - p.x) + p.y) && minXy <= maxY) {
            return new Point(minX, minXy);
        }
        if (p.x >= midX && minY <= (maxXy = m * (maxX - p.x) + p.y) && maxXy <= maxY) {
            return new Point(maxX, maxXy);
        }
        if (p.y <= midY && minX <= (minYx = (minY - p.y) / m + p.x) && minYx <= maxX) {
            return new Point(minYx, minY);
        }
        if (p.y >= midY && minX <= (maxYx = (maxY - p.y) / m + p.x) && maxYx <= maxX) {
            return new Point(maxYx, maxY);
        }
        if (p.x == midX && p.y == midY) {
            return new Point(p.x, p.y);
        }
        return null;
    }

    public static void drawArrowHead(GC gc, Point referencePoint, Point p) {
        double angle = Math.atan2(p.y - referencePoint.y, p.x - referencePoint.x) * 180.0 / Math.PI;
        Transform tf = new Transform(gc.getDevice());
        tf.rotate(Double.valueOf(angle).floatValue());
        tf.scale(7.0f, 3.0f);
        float[] pnts = new float[]{-1.0f, 1.0f, -1.0f, -1.0f};
        tf.transform(pnts);
        gc.drawLine(Math.round(p.x), Math.round(p.y), Math.round(p.x + pnts[0]), Math.round(p.y + pnts[1]));
        gc.drawLine(Math.round(p.x), Math.round(p.y), Math.round(p.x + pnts[2]), Math.round(p.y + pnts[3]));
        tf.dispose();
    }

    public static void drawRectangle(GC gc, float x, float y, float width, float height) {
        gc.drawRectangle(Math.round(x), Math.round(y), Math.round(width), Math.round(height));
    }

    public static <T> List<T> concat(Collection<? extends T> coll1, Collection<? extends T> coll2) {
        ArrayList<T> result = new ArrayList<T>(coll1.size() + coll2.size());
        result.addAll(coll1);
        result.addAll(coll2);
        return result;
    }
}

