/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.ui.internal.Logger;

public abstract class AbstractCommentActionXMLDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    static final String CLOSE_COMMENT = "-->";
    static final String OPEN_COMMENT = "<!--";
    IEditorPart fEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor;
    }

    public void dispose() {
        this.fEditor = null;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        ITextEditor textEditor;
        IDocument document;
        if (this.fEditor instanceof ITextEditor && (document = (textEditor = (ITextEditor)this.fEditor).getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            ITextSelection textSelection = this.getCurrentSelection();
            if (textSelection.isEmpty()) {
                return;
            }
            this.processAction(document, textSelection);
        }
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private ITextSelection getCurrentSelection() {
        ISelection selection;
        ISelectionProvider provider;
        if (this.fEditor instanceof ITextEditor && (provider = ((ITextEditor)this.fEditor).getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }

    abstract void processAction(IDocument var1, ITextSelection var2);

    void removeOpenCloseComments(IDocument document, int offset, int length) {
        try {
            int adjusted_length = length;
            String string = document.get(offset, length);
            int index = string.lastIndexOf(OPEN_COMMENT);
            while (index != -1) {
                document.replace(offset + index, OPEN_COMMENT.length(), "");
                index = string.lastIndexOf(OPEN_COMMENT, index - 1);
                adjusted_length -= OPEN_COMMENT.length();
            }
            string = document.get(offset, adjusted_length);
            index = string.lastIndexOf(CLOSE_COMMENT);
            while (index != -1) {
                document.replace(offset + index, CLOSE_COMMENT.length(), "");
                index = string.lastIndexOf(CLOSE_COMMENT, index - 1);
            }
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }
}

