/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.encoding;

import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;

public class Commander
extends EncodingStrategyAdapter {
    private static final long serialVersionUID = 1L;

    public IConstr addAtMostOne(ISolver solver, IVecInt literals) throws ContradictionException {
        return this.addAtMostOne(solver, literals, 3);
    }

    private IConstr addAtMostOne(ISolver solver, IVecInt literals, int groupSize) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        VecInt clause = new VecInt();
        VecInt clause1 = new VecInt();
        int n = literals.size();
        int nbGroup = (int)Math.ceil((double)literals.size() / (double)groupSize);
        if (nbGroup == 1) {
            int i = 0;
            while (i < literals.size() - 1) {
                int j = i + 1;
                while (j < literals.size()) {
                    clause.push(-literals.get(i));
                    clause.push(-literals.get(j));
                    constrGroup.add(solver.addClause(clause));
                    clause.clear();
                    ++j;
                }
                ++i;
            }
            return constrGroup;
        }
        int[] c = new int[nbGroup];
        int i = 0;
        while (i < nbGroup) {
            c[i] = solver.nextFreeVarId(true);
            ++i;
        }
        int nbVarLastGroup = n - (nbGroup - 1) * groupSize;
        int i2 = 0;
        while (i2 < nbGroup) {
            int size = 0;
            size = i2 == nbGroup - 1 ? nbVarLastGroup : groupSize;
            int j = 0;
            while (j < size - 1) {
                int k = j + 1;
                while (k < size) {
                    clause.push(-literals.get(i2 * groupSize + j));
                    clause.push(-literals.get(i2 * groupSize + k));
                    constrGroup.add(solver.addClause(clause));
                    clause.clear();
                    ++k;
                }
                ++j;
            }
            clause1.push(-c[i2]);
            j = 0;
            while (j < size) {
                clause1.push(literals.get(i2 * groupSize + j));
                clause.push(c[i2]);
                clause.push(-literals.get(i2 * groupSize + j));
                constrGroup.add(solver.addClause(clause));
                clause.clear();
                ++j;
            }
            constrGroup.add(solver.addClause(clause1));
            clause1.clear();
            ++i2;
        }
        constrGroup.add(this.addAtMostOne(solver, new VecInt(c), groupSize));
        return constrGroup;
    }

    public IConstr addAtMost(ISolver solver, IVecInt literals, int degree) throws ContradictionException {
        return super.addAtMost(solver, literals, degree);
    }

    public IConstr addExactlyOne(ISolver solver, IVecInt literals) throws ContradictionException {
        ConstrGroup group = new ConstrGroup();
        group.add(this.addAtLeastOne(solver, literals));
        group.add(this.addAtMostOne(solver, literals));
        return group;
    }

    public IConstr addExactly(ISolver solver, IVecInt literals, int degree) throws ContradictionException {
        ConstrGroup group = new ConstrGroup();
        group.add(this.addAtLeast(solver, literals, degree));
        group.add(this.addAtMost(solver, literals, degree));
        return group;
    }
}

