/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.CFEChildren;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.JumpToken;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.ExpressionWithTarget;
import org.eclipse.n4js.n4JS.N4JSPackage;

class ExpressionWithTargetFactory {
    ExpressionWithTargetFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, ExpressionWithTarget cfe) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)cfe);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)cfe);
        DelegatingNode targetNode = DelegatingNodeFactory.create(astpp, "target", (ControlFlowElement)cfe, (ControlFlowElement)cfe.getTarget());
        cNode.addNode(entryNode);
        cNode.addNode(targetNode);
        LinkedList<Node> nodes = new LinkedList<Node>();
        nodes.add(entryNode);
        nodes.add(targetNode);
        if (cfe.isOptionalChaining()) {
            HelperNode forkNode = new HelperNode("optionalChainingFork", astpp.pos(), (ControlFlowElement)cfe.getTarget());
            cNode.addNode(forkNode);
            nodes.add(forkNode);
            forkNode.addJumpToken(new JumpToken(ControlFlowType.IfNullishTarget));
            cNode.setJumpNode(forkNode);
        }
        List<Node> argumentNodes = CFEChildren.get(astpp, (ControlFlowElement)cfe);
        RepresentingNode representing = new RepresentingNode("expression", astpp.pos(), (ControlFlowElement)cfe);
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)cfe);
        for (Node arg : argumentNodes) {
            cNode.addNode(arg);
        }
        cNode.addNode(representing);
        cNode.addNode(exitNode);
        nodes.addAll(argumentNodes);
        nodes.add(representing);
        nodes.add(exitNode);
        cNode.connectInternalSucc(nodes);
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        if (cfe.eContainingFeature() != N4JSPackage.Literals.EXPRESSION_WITH_TARGET__TARGET) {
            exitNode.addCatchToken(new CatchToken(ControlFlowType.IfNullishTarget));
        }
        return cNode;
    }
}

