/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import org.eclipse.xpect.text.IChange;
import org.eclipse.xpect.text.IPatch;
import org.eclipse.xpect.text.IReplacement;
import org.eclipse.xpect.text.RegionOffsetComparator;
import org.eclipse.xpect.text.Replacement;
import org.eclipse.xtext.util.Strings;

public class Text {
    private String nl;
    private final CharSequence text;

    public Text(CharSequence text) {
        Preconditions.checkNotNull((Object)text);
        this.text = text;
    }

    public char charAt(int c) {
        return this.text.charAt(c);
    }

    public int currentLineEnd(int offset) {
        int nl = this.indexOf('\n', offset);
        if (nl > 0) {
            return this.text.charAt(nl - 1) == '\r' ? nl - 1 : nl;
        }
        return this.text.length();
    }

    public int currentLineEndLenght(int offset) {
        int nl = this.indexOf('\n', offset);
        if (nl > 0) {
            return this.text.charAt(nl - 1) == '\r' ? 2 : 1;
        }
        return 0;
    }

    public int currentLineStart(int offset) {
        return this.lastIndexOf('\n', offset) + 1;
    }

    protected String determineNL() {
        boolean lastIsR = false;
        int i = 0;
        while (i < this.text.length()) {
            switch (this.text.charAt(i)) {
                case '\r': {
                    lastIsR = true;
                    break;
                }
                case '\n': {
                    return lastIsR ? "\r\n" : "\n";
                }
                default: {
                    lastIsR = false;
                }
            }
            ++i;
        }
        return "\n";
    }

    public String escapeNewLines() {
        return this.text.toString().replace("\n", "\\n").replace("\r", "\\r");
    }

    public String findIndentation(int offset) {
        int nl = this.text.toString().lastIndexOf("\n", offset);
        if (nl < 0) {
            nl = 0;
        }
        StringBuilder result = new StringBuilder();
        int i = nl + 1;
        while (i < this.text.length() && Character.isWhitespace(this.text.charAt(i)) && this.text.charAt(i) != '\n') {
            result.append(this.text.charAt(i));
            ++i;
        }
        return result.toString();
    }

    public String findIndentation(String prefix, int offset, int end) {
        if (end <= offset) {
            return "";
        }
        prefix = this.trimRight(prefix);
        ArrayList prefixed = Lists.newArrayList();
        ArrayList unprefixed = Lists.newArrayList();
        for (String line : new Text(this.text.subSequence(offset, end)).splitIntoLines()) {
            if (line.startsWith(prefix)) {
                prefixed.add(line.substring(prefix.length()));
                continue;
            }
            unprefixed.add(line);
        }
        if (prefix.isEmpty() && unprefixed.isEmpty()) {
            return "";
        }
        ArrayList lines = prefixed.size() > unprefixed.size() ? prefixed : unprefixed;
        StringBuilder result = new StringBuilder(prefixed.size() > unprefixed.size() ? prefix : "");
        int i = 0;
        String first;
        while (i < (first = (String)lines.get(0)).length()) {
            char c = first.charAt(i);
            if (!Character.isWhitespace(c) || c == '\n') {
                return result.toString();
            }
            int j = 1;
            while (j < lines.size()) {
                String l = (String)lines.get(j);
                if (i >= l.length() || c != l.charAt(i)) {
                    return result.toString();
                }
                ++j;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public String getNL() {
        if (this.nl == null) {
            this.nl = this.determineNL();
        }
        return this.nl;
    }

    public CharSequence getText() {
        return this.text;
    }

    public String indentWith(String indentation) {
        return this.text.toString().replace("\n", "\n" + indentation);
    }

    public int indexOf(char c, int fromIndex) {
        return this.text.toString().indexOf(c, fromIndex);
    }

    public int indexOf(String str, int fromIndex) {
        return this.text.toString().indexOf(str, fromIndex);
    }

    public boolean isMultiline() {
        return this.indexOf('\n', 0) >= 0;
    }

    public int lastIndexOf(char c, int fromIndex) {
        return this.text.toString().lastIndexOf(c, fromIndex);
    }

    public int length() {
        return this.text.length();
    }

    public int nextLineStart(int offset) {
        return this.indexOf('\n', offset) + 1;
    }

    public int previousLineEnd(int offset) {
        int nl = this.lastIndexOf('\n', offset);
        if (nl > 0) {
            return this.text.charAt(nl - 1) == '\r' ? nl - 1 : nl;
        }
        return nl;
    }

    public int previousLineStart(int offset) {
        int prevEnd = this.previousLineEnd(offset);
        return this.currentLineStart(prevEnd - 1);
    }

    public IReplacement replacementTo(String other) {
        if (Strings.isEmpty((String)other)) {
            return null;
        }
        int prefix = 0;
        while (this.text.charAt(prefix) == other.charAt(prefix)) {
            if (++prefix < this.text.length() && prefix < other.length()) continue;
            return null;
        }
        int suffix = 1;
        while (this.text.charAt(this.text.length() - suffix) == other.charAt(other.length() - suffix)) {
            if (++suffix <= this.text.length() && suffix <= other.length()) continue;
            return null;
        }
        int length = this.text.length() - prefix - suffix + 1;
        int endIndex = other.length() - suffix + 1;
        String replacement = prefix < endIndex ? other.substring(prefix, endIndex) : "";
        return new Replacement(this.text, prefix, length, replacement);
    }

    public List<String> splitIntoLines() {
        int index;
        ArrayList result = Lists.newArrayList();
        String document = this.text.toString();
        int lastIndex = 0;
        while ((index = document.indexOf(10, lastIndex)) >= 0) {
            int end = index > 0 && document.charAt(index - 1) == '\r' ? index - 1 : index;
            result.add(document.substring(lastIndex, end));
            lastIndex = index + 1;
        }
        result.add(document.substring(lastIndex, document.length()));
        return ImmutableList.copyOf((Collection)result);
    }

    public String substring(int beginIndex, int endIndex) {
        return this.text.toString().substring(beginIndex, endIndex);
    }

    public String toString() {
        return this.text.toString();
    }

    protected String trimRight(String str) {
        int i = str.length() - 1;
        while (i >= 0 && Character.isWhitespace(str.charAt(i))) {
            --i;
        }
        return str.substring(0, i + 1);
    }

    public String with(Collection<IReplacement> replacements) {
        if (replacements.isEmpty()) {
            return this.text.toString();
        }
        TreeSet sortedReplacements = Sets.newTreeSet((Comparator)new RegionOffsetComparator());
        for (IReplacement rep : replacements) {
            if (sortedReplacements.add(rep)) continue;
            throw new IllegalStateException("Multiple replacements for same offset");
        }
        int last = 0;
        StringBuilder result = new StringBuilder();
        for (IReplacement rep : sortedReplacements) {
            if (rep.getOffset() < last) {
                throw new IllegalStateException("Overlapping replacements");
            }
            result.append(this.text.toString().substring(last, rep.getOffset()));
            result.append(rep.getReplacement());
            last = rep.getOffset() + rep.getLength();
        }
        if (last < this.text.length()) {
            result.append(this.text.toString().substring(last));
        }
        return result.toString();
    }

    public String with(IChange change) {
        if (change instanceof IPatch) {
            ArrayList replacements = Lists.newArrayList();
            Stack<IPatch> patches = new Stack<IPatch>();
            patches.push((IPatch)change);
            while (!patches.isEmpty()) {
                IPatch p = (IPatch)patches.pop();
                for (IChange c : p.getChanges()) {
                    if (c instanceof IPatch) {
                        patches.push((IPatch)c);
                        continue;
                    }
                    if (!(c instanceof IReplacement)) continue;
                    replacements.add((IReplacement)c);
                }
            }
            return this.with(replacements);
        }
        if (change instanceof IReplacement) {
            return this.with(Collections.singleton((IReplacement)change));
        }
        throw new IllegalStateException();
    }
}

