/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetRef;
import org.eclipse.wst.common.project.facet.core.util.internal.VersionExpr;
import org.eclipse.wst.common.project.facet.ui.internal.constraints.ConstraintOperator;
import org.eclipse.wst.common.project.facet.ui.internal.constraints.GroupingConstraintOperator;
import org.eclipse.wst.common.project.facet.ui.internal.constraints.MultiFacetConstraintOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstraintUtil {
    private ConstraintUtil() {
    }

    public static ConstraintOperator convert(IConstraint inputConstraint) {
        IConstraint.Type inputConstraintType = inputConstraint.getType();
        if (inputConstraintType == IConstraint.Type.AND || inputConstraintType == IConstraint.Type.OR) {
            ConstraintOperator.Type outputConstraintType = inputConstraintType == IConstraint.Type.AND ? ConstraintOperator.Type.AND : ConstraintOperator.Type.OR;
            GroupingConstraintOperator outputConstraint = new GroupingConstraintOperator(outputConstraintType);
            for (Object child : inputConstraint.getOperands()) {
                outputConstraint.addChild(ConstraintUtil.convert((IConstraint)child));
            }
            return outputConstraint;
        }
        if (inputConstraintType == IConstraint.Type.REQUIRES) {
            Object firstOperand = inputConstraint.getOperand(0);
            MultiFacetConstraintOperator outputConstraint = new MultiFacetConstraintOperator(ConstraintOperator.Type.REQUIRES_ONE);
            if (firstOperand instanceof IProjectFacet) {
                IProjectFacet f = (IProjectFacet)firstOperand;
                IVersionExpr vexpr = (IVersionExpr)inputConstraint.getOperand(1);
                outputConstraint.addProjectFacetRef(new ProjectFacetRef(f, vexpr));
            } else {
                IGroup group = (IGroup)firstOperand;
                outputConstraint.addProjectFacetRefs(ConstraintUtil.convertGroupToFacetRefs(group));
            }
            return outputConstraint;
        }
        if (inputConstraintType == IConstraint.Type.CONFLICTS) {
            Object firstOperand = inputConstraint.getOperand(0);
            MultiFacetConstraintOperator outputConstraint = new MultiFacetConstraintOperator(ConstraintOperator.Type.CONFLICTS);
            if (firstOperand instanceof IProjectFacet) {
                IProjectFacet f = (IProjectFacet)firstOperand;
                IVersionExpr vexpr = (IVersionExpr)inputConstraint.getOperand(1);
                outputConstraint.addProjectFacetRef(new ProjectFacetRef(f, vexpr));
            } else {
                IGroup group = (IGroup)firstOperand;
                outputConstraint.addProjectFacetRefs(ConstraintUtil.convertGroupToFacetRefs(group));
            }
            return outputConstraint;
        }
        throw new IllegalStateException(inputConstraintType.name());
    }

    private static Collection<ProjectFacetRef> convertGroupToFacetRefs(IGroup group) {
        HashMap<IProjectFacet, ArrayList<IProjectFacetVersion>> members = new HashMap<IProjectFacet, ArrayList<IProjectFacetVersion>>();
        for (IProjectFacetVersion fv : group.getMembers()) {
            IProjectFacet f = fv.getProjectFacet();
            ArrayList<IProjectFacetVersion> versions = (ArrayList<IProjectFacetVersion>)members.get(f);
            if (versions == null) {
                versions = new ArrayList<IProjectFacetVersion>();
                members.put(f, versions);
            }
            versions.add(fv);
        }
        ArrayList<ProjectFacetRef> facetRefs = new ArrayList<ProjectFacetRef>(members.size());
        for (Map.Entry entry : members.entrySet()) {
            VersionExpr vexpr;
            String vexprString;
            IProjectFacet f = (IProjectFacet)entry.getKey();
            List versions = (List)entry.getValue();
            if (versions.size() == f.getVersions().size()) {
                vexprString = "*";
            } else {
                StringBuilder buf = new StringBuilder();
                for (IProjectFacetVersion fv : versions) {
                    if (buf.length() > 0) {
                        buf.append(',');
                    }
                    buf.append(fv.getVersionString());
                }
                vexprString = buf.toString();
            }
            try {
                vexpr = new VersionExpr((Object)f, vexprString, null);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            facetRefs.add(new ProjectFacetRef(f, (IVersionExpr)vexpr));
        }
        return facetRefs;
    }

    public static ConstraintOperator normalize(ConstraintOperator input) {
        if (input instanceof GroupingConstraintOperator) {
            Iterator itr;
            List<ConstraintOperator> oldChildren = ((GroupingConstraintOperator)input).getChildren();
            ArrayList<ConstraintOperator> newChildren = new ArrayList<ConstraintOperator>(oldChildren.size());
            for (ConstraintOperator child : oldChildren) {
                newChildren.add(ConstraintUtil.normalize(child));
            }
            if (input.getType() == ConstraintOperator.Type.AND) {
                ConstraintOperator firstRequiresAll = null;
                itr = newChildren.iterator();
                while (itr.hasNext()) {
                    ConstraintOperator op = (ConstraintOperator)itr.next();
                    if (op.getType() != ConstraintOperator.Type.REQUIRES_ALL && (op.getType() != ConstraintOperator.Type.REQUIRES_ONE || ((MultiFacetConstraintOperator)op).getProjectFacetRefs().size() != 1)) continue;
                    MultiFacetConstraintOperator mfop = (MultiFacetConstraintOperator)op;
                    if (firstRequiresAll == null) {
                        firstRequiresAll = mfop;
                        continue;
                    }
                    ((MultiFacetConstraintOperator)firstRequiresAll).addProjectFacetRefs(mfop.getProjectFacetRefs());
                    itr.remove();
                }
                if (firstRequiresAll != null && firstRequiresAll.getType() == ConstraintOperator.Type.REQUIRES_ONE && ((MultiFacetConstraintOperator)firstRequiresAll).getProjectFacetRefs().size() > 1) {
                    firstRequiresAll.setType(ConstraintOperator.Type.REQUIRES_ALL);
                }
                MultiFacetConstraintOperator firstConflicts = null;
                Iterator itr2 = newChildren.iterator();
                while (itr2.hasNext()) {
                    ConstraintOperator op = (ConstraintOperator)itr2.next();
                    if (op.getType() != ConstraintOperator.Type.CONFLICTS) continue;
                    MultiFacetConstraintOperator mfop = (MultiFacetConstraintOperator)op;
                    if (firstConflicts == null) {
                        firstConflicts = mfop;
                        continue;
                    }
                    firstConflicts.addProjectFacetRefs(mfop.getProjectFacetRefs());
                    itr2.remove();
                }
            } else {
                MultiFacetConstraintOperator firstRequiresOne = null;
                itr = newChildren.iterator();
                while (itr.hasNext()) {
                    ConstraintOperator op = (ConstraintOperator)itr.next();
                    if (op.getType() != ConstraintOperator.Type.REQUIRES_ONE) continue;
                    MultiFacetConstraintOperator mfop = (MultiFacetConstraintOperator)op;
                    if (firstRequiresOne == null) {
                        firstRequiresOne = mfop;
                        continue;
                    }
                    firstRequiresOne.addProjectFacetRefs(mfop.getProjectFacetRefs());
                    itr.remove();
                }
            }
            if (newChildren.size() == 1) {
                return (ConstraintOperator)newChildren.get(0);
            }
            GroupingConstraintOperator output = new GroupingConstraintOperator(input.getType());
            output.addChildren(newChildren);
            return output;
        }
        return input;
    }
}

