/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.internal;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;

public final class WildcardAsStringUtils {
    private static final Set<Thread> threadsCurrentlyConvertingWildcardsWithImplicitUpperBounds = ConcurrentHashMap.newKeySet();

    public static final String getTypeRefAsString_workaround(Object wildcard) {
        return WildcardAsStringUtils.getTypeRefAsString((Wildcard)wildcard);
    }

    public static final String getTypeRefAsString(Wildcard w) {
        if (w.isImplicitUpperBoundInEffect()) {
            Thread myThread = Thread.currentThread();
            boolean wIsFirst = threadsCurrentlyConvertingWildcardsWithImplicitUpperBounds.add(myThread);
            try {
                String string = WildcardAsStringUtils.primGetTypeRefAsString(w, wIsFirst);
                return string;
            }
            finally {
                if (wIsFirst) {
                    threadsCurrentlyConvertingWildcardsWithImplicitUpperBounds.remove(myThread);
                }
            }
        }
        return WildcardAsStringUtils.primGetTypeRefAsString(w, false);
    }

    private static final String primGetTypeRefAsString(Wildcard w, boolean showImplicitUpperBounds) {
        StringBuilder sb = new StringBuilder();
        sb.append("?");
        TypeRef declUpperBound = w.getDeclaredUpperBound();
        TypeRef upperBound = showImplicitUpperBounds ? w.getDeclaredOrImplicitUpperBound() : declUpperBound;
        TypeRef lowerBound = w.getDeclaredLowerBound();
        if (upperBound != null) {
            sb.append(" extends ");
            sb.append(upperBound.getTypeRefAsString());
        } else if (lowerBound != null) {
            sb.append(" super ");
            sb.append(lowerBound.getTypeRefAsString());
        }
        return sb.toString();
    }

    private WildcardAsStringUtils() {
    }
}

