/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.helper;

import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public final class IssuesProvider
implements Provider<List<Issue>> {
    private final IResourceValidator rv;
    private final Resource r;
    private final OperationCanceledManager operationCanceledManager;
    private final CancelIndicator ci;

    public IssuesProvider(IResourceValidator resourceValidator, Resource res, OperationCanceledManager operationCanceledManager, CancelIndicator ci) {
        this.rv = resourceValidator;
        this.r = res;
        this.operationCanceledManager = operationCanceledManager;
        this.ci = ci;
    }

    public List<Issue> get() throws OperationCanceledError {
        List issues;
        this.operationCanceledManager.checkCanceled(this.ci);
        URI uri = this.r.getURI();
        DataCollector dc = uri != null && "package.json".equals(uri.lastSegment()) ? N4JSDataCollectors.dcValidationsPackageJson : N4JSDataCollectors.dcValidations;
        Throwable throwable = null;
        Object var5_5 = null;
        try (Measurement m = dc.getMeasurement("validation");){
            issues = this.rv.validate(this.r, CheckMode.ALL, this.ci);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!issues.contains(null)) {
            this.operationCanceledManager.checkCanceled(this.ci);
            return issues;
        }
        ArrayList<Issue> result = new ArrayList<Issue>(issues);
        result.removeAll(Collections.singleton(null));
        this.operationCanceledManager.checkCanceled(this.ci);
        return result;
    }
}

