/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@Inherited
public @interface RepeatedTest {
    public int times() default 10;

    public static class Rule
    implements TestRule {
        private final boolean quiet;

        public Rule(boolean quiet) {
            this.quiet = quiet;
        }

        public Rule() {
            this(true);
        }

        public Statement apply(Statement statement, Description description) {
            RepeatedTest repeat = (RepeatedTest)description.getAnnotation(RepeatedTest.class);
            if (repeat == null) {
                repeat = description.getTestClass().getAnnotation(RepeatedTest.class);
            }
            if (repeat != null) {
                return new RepeatedTestStatement(repeat.times(), statement, description, this.quiet);
            }
            return statement;
        }

        public static class RepeatedTestStatement
        extends Statement {
            private final int times;
            private final Statement statement;
            private final boolean quiet;
            private final Description description;

            public RepeatedTestStatement(int times, Statement statement, Description description, boolean quiet) {
                this.times = times;
                this.statement = statement;
                this.description = description;
                this.quiet = quiet;
            }

            public void evaluate() throws Throwable {
                for (int i = 1; i <= this.times; ++i) {
                    if (!this.quiet) {
                        System.out.printf("[%s] %d of %d\n", this.description.getMethodName(), i, this.times);
                    }
                    this.statement.evaluate();
                }
            }
        }
    }
}

