/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.ExternalProjectsCollector;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.PlatformResourceURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.EclipseProjectName;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.ui.external.ExternalLibraryBuilder;
import org.eclipse.n4js.ui.external.ExternalProjectProvider;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.xtext.builder.impl.BuilderStateDiscarder;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.util.Pair;

@Singleton
public class EclipseExternalLibraryWorkspace
extends ExternalLibraryWorkspace
implements ExternalLibraryPreferenceStore.StoreUpdatedListener {
    private static Logger logger = Logger.getLogger(EclipseExternalLibraryWorkspace.class);
    @Inject
    private IN4JSCore core;
    @Inject
    private ExternalLibraryBuilder builder;
    @Inject
    private ExternalProjectsCollector collector;
    @Inject
    private BuilderStateDiscarder builderStateDiscarder;
    @Inject
    private ExternalProjectProvider projectProvider;
    @Inject
    private ExternalLibraryPreferenceStore externalLibraryPreferenceStore;

    @Inject
    void init() {
        try {
            this.projectProvider.updateCache();
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to initialize external library workspace.", t);
            UIUtils.showError(t);
        }
        this.externalLibraryPreferenceStore.addListener((ExternalLibraryPreferenceStore.StoreUpdatedListener)this);
    }

    public void storeUpdated(ExternalLibraryPreferenceStore store, IProgressMonitor monitor) {
        this.projectProvider.updateCache();
    }

    public ProjectDescription getProjectDescription(FileURI location) {
        Pair<N4JSExternalProject, ProjectDescription> pair = this.projectProvider.getProjectWithDescription((SafeURI<?>)location);
        return pair == null ? null : (ProjectDescription)pair.getSecond();
    }

    public FileURI getLocation(ProjectReference reference) {
        N4JSProjectName name = new N4JSProjectName(reference.getProjectName());
        N4JSExternalProject project = this.projectProvider.getProject(name);
        if (project == null) {
            return null;
        }
        FileURI refLocation = (FileURI)project.getIProject().getLocation();
        Pair<N4JSExternalProject, ProjectDescription> pair = this.projectProvider.getProjectWithDescription((SafeURI<?>)refLocation);
        if (pair != null) {
            return refLocation;
        }
        return null;
    }

    public Iterator<? extends FileURI> getFolderIterator(FileURI folderLocation) {
        return Iterators.filter((Iterator)folderLocation.getAllChildren(), loc -> !loc.isDirectory());
    }

    public FileURI findArtifactInFolder(FileURI folderLocation, String folderRelativePath) {
        FileURI result = (FileURI)folderLocation.appendPath(folderRelativePath);
        if (result != null && result.exists()) {
            return result;
        }
        return null;
    }

    public FileURI findProjectWith(FileURI nestedLocation) {
        FileURI uriCandidate;
        FileURI rootLoc = this.getRootLocationForResource(nestedLocation);
        if (rootLoc != null && this.projectProvider.getProject((SafeURI<?>)(uriCandidate = this.computeProjectURI(nestedLocation, rootLoc))) != null) {
            return uriCandidate;
        }
        return null;
    }

    private FileURI computeProjectURI(FileURI nestedLocation, FileURI rootLoc) {
        List path = nestedLocation.deresolve((SafeURI)rootLoc);
        Iterator iterator = path.iterator();
        FileURI result = rootLoc;
        while (iterator.hasNext()) {
            String segment = (String)iterator.next();
            result = (FileURI)result.appendSegment(segment);
            if (segment.startsWith("@")) continue;
            return result;
        }
        return result;
    }

    public ExternalLibraryWorkspace.RegisterResult registerProjects(IProgressMonitor monitor, Set<FileURI> toBeUpdated) {
        ISchedulingRule rule = this.builder.getRule();
        try {
            Job.getJobManager().beginRule(rule, monitor);
            ExternalLibraryWorkspace.RegisterResult registerResult = this.registerProjectsInternal(monitor, toBeUpdated);
            return registerResult;
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    public ExternalLibraryWorkspace.RegisterResult deregisterProjects(IProgressMonitor monitor, Set<FileURI> toBeDeleted) {
        ISchedulingRule rule = this.builder.getRule();
        try {
            Job.getJobManager().beginRule(rule, monitor);
            ExternalLibraryWorkspace.RegisterResult registerResult = this.deregisterProjectsInternal(monitor, toBeDeleted, new HashSet<FileURI>());
            return registerResult;
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    public ExternalLibraryWorkspace.RegisterResult deregisterAllProjects(IProgressMonitor monitor) {
        ISchedulingRule rule = this.builder.getRule();
        try {
            Job.getJobManager().beginRule(rule, monitor);
            HashSet<FileURI> toBeDeleted = new HashSet<FileURI>();
            for (N4JSExternalProject extProject : this.getProjects()) {
                toBeDeleted.add(extProject.getSafeLocation());
            }
            HashSet<FileURI> toBeWiped = new HashSet<FileURI>(this.projectProvider.getRootLocationsInReversedShadowingOrder());
            ExternalLibraryWorkspace.RegisterResult registerResult = this.deregisterProjectsInternal(monitor, toBeDeleted, toBeWiped);
            return registerResult;
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    private ExternalLibraryWorkspace.RegisterResult deregisterProjectsInternal(IProgressMonitor monitor, Set<FileURI> toBeDeleted, Set<FileURI> toBeWiped) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        Set<N4JSExternalProject> allProjectsToClean = this.getAllToBeCleaned(toBeDeleted);
        LinkedList<IProject> extPrjCleaned = new LinkedList<IProject>();
        if (!allProjectsToClean.isEmpty()) {
            extPrjCleaned.addAll(this.builder.clean(allProjectsToClean, (IProgressMonitor)subMonitor.split(1)));
        }
        HashSet wsPrjAffected = Sets.newHashSet();
        wsPrjAffected.addAll(this.collector.getWSProjectsDependendingOn(allProjectsToClean));
        toBeWiped.addAll(toBeDeleted);
        this.wipeIndex(monitor, toBeWiped, allProjectsToClean);
        HashSet cleaned = Sets.newHashSet();
        for (IProject cleanedExternal : extPrjCleaned) {
            cleaned.add(this.getProject(new EclipseProjectName(cleanedExternal.getName()).toN4JSProjectName()).getSafeLocation());
        }
        return new ExternalLibraryWorkspace.RegisterResult((Collection)cleaned, EclipseExternalLibraryWorkspace.getURIs(wsPrjAffected.toArray(new IProject[0])), toBeWiped);
    }

    private static Collection<PlatformResourceURI> getURIs(IProject[] projects) {
        HashSet<PlatformResourceURI> uris = new HashSet<PlatformResourceURI>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            uris.add(new PlatformResourceURI((IResource)project));
            ++n2;
        }
        return uris;
    }

    private Set<N4JSExternalProject> getAllToBeCleaned(Set<FileURI> toBeDeleted) {
        HashSet<N4JSExternalProject> allProjectsToClean = new HashSet<N4JSExternalProject>();
        HashSet<N4JSExternalProject> projectsToClean = new HashSet<N4JSExternalProject>();
        for (FileURI toBeDeletedLocation : toBeDeleted) {
            N4JSExternalProject project = this.projectProvider.getProject((SafeURI<?>)toBeDeletedLocation);
            if (project == null) continue;
            projectsToClean.add(project);
        }
        allProjectsToClean.addAll(projectsToClean);
        allProjectsToClean.addAll(Sets.newHashSet((Iterable)this.collector.getExtProjectsDependendingOn(projectsToClean)));
        return allProjectsToClean;
    }

    private void wipeIndex(IProgressMonitor monitor, Set<FileURI> toBeDeleted, Set<N4JSExternalProject> allProjectsToClean) {
        HashSet<FileURI> toBeWiped = new HashSet<FileURI>(toBeDeleted);
        for (N4JSExternalProject project : allProjectsToClean) {
            toBeWiped.add(project.getSafeLocation());
        }
        this.builder.wipeURIsFromIndex(monitor, toBeWiped);
    }

    private ExternalLibraryWorkspace.RegisterResult registerProjectsInternal(IProgressMonitor monitor, Set<FileURI> toBeUpdated) {
        LinkedList<IProject> extPrjBuilt = new LinkedList<IProject>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        Collection<N4JSExternalProject> projectsToBuild = this.getExternalProjects(toBeUpdated);
        HashSet<N4JSExternalProject> allProjectsToBuild = new HashSet<N4JSExternalProject>();
        allProjectsToBuild.addAll(projectsToBuild);
        allProjectsToBuild.addAll(this.collector.getExtProjectsDependendingOn(projectsToBuild));
        if (!Iterables.isEmpty(allProjectsToBuild)) {
            extPrjBuilt.addAll(this.builder.build(allProjectsToBuild, (IProgressMonitor)subMonitor.split(1)));
        }
        HashSet wsPrjAffected = Sets.newHashSet();
        HashSet<N4JSExternalProject> affectedProjects = new HashSet<N4JSExternalProject>();
        affectedProjects.addAll(allProjectsToBuild);
        wsPrjAffected.addAll(this.collector.getWSProjectsDependendingOn(affectedProjects));
        HashSet built = Sets.newHashSet();
        for (IProject cleanedExternal : extPrjBuilt) {
            built.add(this.getProject(new EclipseProjectName(cleanedExternal.getName()).toN4JSProjectName()).getSafeLocation());
        }
        return new ExternalLibraryWorkspace.RegisterResult((Collection)built, EclipseExternalLibraryWorkspace.getURIs(wsPrjAffected.toArray(new IProject[0])));
    }

    public void scheduleWorkspaceProjects(IProgressMonitor monitor, Set<SafeURI<?>> toBeScheduled) {
        HashSet scheduledProjects = Sets.newHashSet();
        for (SafeURI<?> scheduledURI : toBeScheduled) {
            IN4JSProject wsProject = (IN4JSProject)this.core.findProject(scheduledURI.toURI()).orNull();
            if (!(wsProject instanceof IN4JSEclipseProject)) continue;
            IN4JSEclipseProject n4EclProject = (IN4JSEclipseProject)wsProject;
            scheduledProjects.add(n4EclProject.getProject());
        }
        HashMap args = new HashMap();
        IBuildFlag.FORGET_BUILD_STATE_ONLY.addToMap(args);
        this.builderStateDiscarder.forgetLastBuildState((Iterable)scheduledProjects, args);
    }

    private Collection<N4JSExternalProject> getExternalProjects(Set<FileURI> toBeUpdated) {
        HashSet<N4JSExternalProject> projectsToBeUpdated = new HashSet<N4JSExternalProject>();
        for (SafeURI safeURI : toBeUpdated) {
            N4JSExternalProject n4Prj = this.projectProvider.getProject(safeURI);
            projectsToBeUpdated.add(n4Prj);
        }
        Set set = this.collector.filterNonWSProjects(projectsToBeUpdated);
        return set;
    }

    public Collection<N4JSExternalProject> getProjects() {
        return this.projectProvider.getProjects();
    }

    public boolean isNecessary(SafeURI<?> location) {
        return this.projectProvider.getAllProjectLocations().contains(location);
    }

    public List<Pair<FileURI, ProjectDescription>> computeProjectsIncludingUnnecessary() {
        return this.projectProvider.computeProjectsIncludingUnnecessary();
    }

    public Collection<FileURI> getAllProjectLocations() {
        return this.projectProvider.getAllProjectLocations();
    }

    public Map<N4JSProjectName, VersionNumber> getProjectNameVersionMap() {
        HashMap<N4JSProjectName, VersionNumber> externalLibs = new HashMap<N4JSProjectName, VersionNumber>();
        for (N4JSExternalProject pd : this.getProjects()) {
            N4JSProjectName name = pd.getIProject().getProjectName();
            VersionNumber version = pd.getIProject().getVersion();
            externalLibs.put(name, version);
        }
        return externalLibs;
    }

    public Collection<N4JSExternalProject> getProjectsIn(FileURI rootLocation) {
        return this.projectProvider.getProjectsIn(rootLocation);
    }

    public Collection<N4JSExternalProject> getProjectsIn(Collection<FileURI> rootLocations) {
        LinkedList<N4JSExternalProject> projects = new LinkedList<N4JSExternalProject>();
        for (FileURI rootLoc : rootLocations) {
            projects.addAll(this.getProjectsIn(rootLoc));
        }
        return projects;
    }

    public N4JSExternalProject getProject(N4JSProjectName projectName) {
        return this.projectProvider.getProject(projectName);
    }

    public N4JSExternalProject getProject(FileURI projectLocation) {
        return this.projectProvider.getProject((SafeURI<?>)projectLocation);
    }

    public void updateState() {
        this.projectProvider.updateCache();
    }

    public List<Pair<FileURI, ProjectDescription>> getProjectsIncludingUnnecessary() {
        return this.projectProvider.getProjectsIncludingUnnecessary();
    }

    public List<N4JSExternalProject> getProjectsForName(N4JSProjectName projectName) {
        return this.projectProvider.getProjectsForName(projectName);
    }

    public FileURI getRootLocationForResource(FileURI nestedLocation) {
        return EclipseExternalLibraryWorkspace.getRootLocationForResource(this.projectProvider.getAllRootLocations(), (SafeURI)nestedLocation);
    }
}

