/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.ArrayBindingPattern;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.BindingElement;
import org.eclipse.n4js.n4JS.BindingPattern;
import org.eclipse.n4js.n4JS.BindingProperty;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4JSFactory;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.ObjectBindingPattern;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyAssignmentAnnotationList;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertyNameValuePairSingleName;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class DestructNode {
    private final EObject astElement;
    private final String propName;
    private final IdentifierRef varRef;
    private final VariableDeclaration varDecl;
    private final DestructNode[] nestedNodes;
    private final Expression defaultExpr;
    private final EObject assignedElem;
    private final boolean rest;

    public boolean isPositional() {
        return this.propName == null;
    }

    public static boolean arePositional(DestructNode[] nodes) {
        return nodes != null && IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)nodes)), it -> it.isPositional());
    }

    public boolean isPadding() {
        return this.varRef == null && this.varDecl == null && this.nestedNodes == null;
    }

    public String varName() {
        String _xifexpression = null;
        if (this.varRef != null) {
            IdentifiableElement _id = this.varRef.getId();
            String _name = null;
            if (_id != null) {
                _name = _id.getName();
            }
            _xifexpression = _name;
        } else {
            String _xifexpression_1 = null;
            if (this.varDecl != null) {
                _xifexpression_1 = this.varDecl.getName();
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public VariableDeclaration getVariableDeclaration() {
        VariableDeclaration _switchResult = null;
        EObject astElement = this.astElement;
        boolean _matched = false;
        if (astElement instanceof BindingElement) {
            _matched = true;
            _switchResult = ((BindingElement)this.astElement).getVarDecl();
        }
        if (!_matched && astElement instanceof BindingProperty) {
            boolean _tripleNotEquals;
            BindingElement _value = ((BindingProperty)this.astElement).getValue();
            boolean bl = _tripleNotEquals = _value != null;
            if (_tripleNotEquals) {
                _matched = true;
                _switchResult = ((BindingProperty)this.astElement).getValue().getVarDecl();
            }
        }
        return _switchResult;
    }

    public Pair<EObject, EStructuralFeature> getEObjectAndFeatureForPropName() {
        Pair _xifexpression = null;
        if (this.propName != null) {
            Pair _switchResult = null;
            EObject astElement = this.astElement;
            boolean _matched = false;
            if (astElement instanceof PropertyNameValuePairSingleName) {
                _matched = true;
                EReference _propertyNameValuePairSingleName_IdentifierRef = N4JSPackage.eINSTANCE.getPropertyNameValuePairSingleName_IdentifierRef();
                _switchResult = Pair.of((Object)this.astElement, (Object)_propertyNameValuePairSingleName_IdentifierRef);
            }
            if (!_matched && astElement instanceof BindingProperty) {
                boolean _tripleNotEquals;
                LiteralOrComputedPropertyName _declaredName = ((BindingProperty)this.astElement).getDeclaredName();
                boolean bl = _tripleNotEquals = _declaredName != null;
                if (_tripleNotEquals) {
                    _matched = true;
                    EReference _propertyNameOwner_DeclaredName = N4JSPackage.eINSTANCE.getPropertyNameOwner_DeclaredName();
                    _switchResult = Pair.of((Object)this.astElement, (Object)_propertyNameOwner_DeclaredName);
                }
            }
            if (!_matched && astElement instanceof BindingProperty) {
                boolean _tripleNotEquals;
                BindingElement _value = ((BindingProperty)this.astElement).getValue();
                VariableDeclaration _varDecl = null;
                if (_value != null) {
                    _varDecl = _value.getVarDecl();
                }
                String _name = null;
                if (_varDecl != null) {
                    _name = _varDecl.getName();
                }
                boolean bl = _tripleNotEquals = _name != null;
                if (_tripleNotEquals) {
                    _matched = true;
                    VariableDeclaration _varDecl_1 = ((BindingProperty)this.astElement).getValue().getVarDecl();
                    EAttribute _identifiableElement_Name = TypesPackage.eINSTANCE.getIdentifiableElement_Name();
                    _switchResult = Pair.of((Object)_varDecl_1, (Object)_identifiableElement_Name);
                }
            }
            if (!_matched && astElement instanceof PropertyNameOwner) {
                _matched = true;
                EReference _propertyNameOwner_DeclaredName = N4JSPackage.eINSTANCE.getPropertyNameOwner_DeclaredName();
                _switchResult = Pair.of((Object)this.astElement, (Object)_propertyNameOwner_DeclaredName);
            }
            if (!_matched) {
                _switchResult = Pair.of((Object)this.astElement, null);
            }
            _xifexpression = _switchResult;
        } else {
            _xifexpression = Pair.of((Object)this.astElement, null);
        }
        return _xifexpression;
    }

    public DestructNode findNodeForElement(EObject astElement) {
        Predicate<DestructNode> _function = it -> it.astElement == astElement;
        return this.stream().filter(_function).findFirst().orElse(null);
    }

    public Stream<DestructNode> stream() {
        Stream<DestructNode> _xifexpression = null;
        if (this.nestedNodes == null || ((List)Conversions.doWrapArray((Object)this.nestedNodes)).isEmpty()) {
            _xifexpression = Stream.of(this);
        } else {
            Function<DestructNode, Stream> _function = it -> it.stream();
            _xifexpression = Stream.concat(Stream.of(this), Stream.of(this.nestedNodes).flatMap(_function));
        }
        return _xifexpression;
    }

    public static DestructNode unify(EObject eobj) {
        DestructNode _switchResult = null;
        boolean _matched = false;
        if (eobj instanceof VariableBinding) {
            _matched = true;
            _switchResult = DestructNode.unify((VariableBinding)eobj);
        }
        if (!_matched && eobj instanceof AssignmentExpression) {
            _matched = true;
            _switchResult = DestructNode.unify((AssignmentExpression)eobj);
        }
        if (!_matched && eobj instanceof ForStatement) {
            _matched = true;
            _switchResult = DestructNode.unify((ForStatement)eobj);
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public static DestructNode unify(EObject lhs, Expression rhs) {
        DestructNode[] _entries = DestructNode.toEntries(lhs, rhs);
        return new DestructNode(lhs, null, null, null, _entries, rhs, rhs, false);
    }

    public static DestructNode unify(VariableBinding binding) {
        DestructNode _xifexpression = null;
        if (binding != null && binding.getPattern() != null && (binding.getExpression() != null || binding.eContainer() instanceof ForStatement)) {
            _xifexpression = DestructNode.unify(binding.getPattern(), binding.getExpression());
        }
        return _xifexpression;
    }

    public static DestructNode unify(AssignmentExpression expr) {
        DestructNode _xifexpression = null;
        if (expr != null && expr.getLhs() != null && expr.getRhs() != null && DestructureUtils.isTopOfDestructuringAssignment(expr)) {
            _xifexpression = DestructNode.unify(expr.getLhs(), expr.getRhs());
        }
        return _xifexpression;
    }

    public static DestructNode unify(ForStatement stmnt) {
        DestructNode _xifexpression = null;
        if (stmnt != null && DestructureUtils.isTopOfDestructuringForStatement(stmnt)) {
            DestructNode _xblockexpression = null;
            Expression _xifexpression_1 = null;
            boolean _isForOf = stmnt.isForOf();
            if (_isForOf) {
                _xifexpression_1 = stmnt.getExpression();
            } else {
                StringLiteral _xifexpression_2 = null;
                boolean _isForIn = stmnt.isForIn();
                if (!_isForIn) {
                    throw new IllegalStateException();
                }
                _xifexpression_2 = N4JSFactory.eINSTANCE.createStringLiteral();
                _xifexpression_1 = _xifexpression_2;
            }
            Expression valueToBeDestructured = _xifexpression_1;
            DestructNode _xifexpression_3 = null;
            boolean _containsDestructuringPattern = DestructureUtils.containsDestructuringPattern(stmnt);
            if (_containsDestructuringPattern) {
                DestructNode _xblockexpression_1 = null;
                VariableBinding binding = (VariableBinding)IterableExtensions.head((Iterable)Iterables.filter(stmnt.getVarDeclsOrBindings(), VariableBinding.class));
                DestructNode[] _entries = DestructNode.toEntries(binding.getPattern(), stmnt.getExpression());
                _xifexpression_3 = _xblockexpression_1 = new DestructNode(binding, null, null, null, _entries, valueToBeDestructured, valueToBeDestructured, false);
            } else {
                DestructNode _xifexpression_4 = null;
                boolean _isObjectOrArrayLiteral = DestructureUtils.isObjectOrArrayLiteral(stmnt.getInitExpr());
                if (_isObjectOrArrayLiteral) {
                    Expression _initExpr = stmnt.getInitExpr();
                    DestructNode[] _entries = DestructNode.toEntries(stmnt.getInitExpr(), null);
                    _xifexpression_4 = new DestructNode(_initExpr, null, null, null, _entries, valueToBeDestructured, valueToBeDestructured, false);
                }
                _xifexpression_3 = _xifexpression_4;
            }
            _xifexpression = _xblockexpression = _xifexpression_3;
        }
        return _xifexpression;
    }

    private static DestructNode[] toEntries(EObject pattern, EObject rhs) {
        Iterator _switchResult = null;
        boolean _matched = false;
        if (pattern instanceof ArrayLiteral) {
            _matched = true;
            _switchResult = ((ArrayLiteral)pattern).getElements().iterator();
        }
        if (!_matched && pattern instanceof ObjectLiteral) {
            _matched = true;
            _switchResult = ((ObjectLiteral)pattern).getPropertyAssignments().iterator();
        }
        if (!_matched && pattern instanceof ArrayBindingPattern) {
            _matched = true;
            _switchResult = ((ArrayBindingPattern)pattern).getElements().iterator();
        }
        if (!_matched && pattern instanceof ObjectBindingPattern) {
            _matched = true;
            _switchResult = ((ObjectBindingPattern)pattern).getProperties().iterator();
        }
        Iterator patElemIter = _switchResult;
        Iterator _switchResult_1 = null;
        boolean _matched_1 = false;
        if (rhs instanceof ArrayLiteral) {
            _matched_1 = true;
            _switchResult_1 = ((ArrayLiteral)rhs).getElements().iterator();
        }
        if (!_matched_1 && rhs instanceof ObjectLiteral) {
            _matched_1 = true;
            _switchResult_1 = ((ObjectLiteral)rhs).getPropertyAssignments().iterator();
        }
        Iterator rhsElemIter = _switchResult_1;
        BasicEList nestedDNs = new BasicEList();
        while (patElemIter.hasNext()) {
            DestructNode nestedNode;
            EObject patElem = (EObject)patElemIter.next();
            EObject _xifexpression = null;
            if (rhsElemIter == null) {
                _xifexpression = rhs;
            } else {
                EObject _xifexpression_1 = null;
                boolean _hasNext = rhsElemIter.hasNext();
                _xifexpression_1 = _hasNext ? (EObject)rhsElemIter.next() : null;
                _xifexpression = _xifexpression_1;
            }
            EObject litElem = _xifexpression;
            DestructNode _switchResult_2 = null;
            boolean _matched_2 = false;
            if (patElem instanceof ArrayElement) {
                _matched_2 = true;
                _switchResult_2 = DestructNode.toEntry((ArrayElement)patElem, litElem);
            }
            if (!_matched_2 && patElem instanceof PropertyNameValuePair) {
                _matched_2 = true;
                _switchResult_2 = DestructNode.toEntry((PropertyNameValuePair)patElem, litElem);
            }
            if (!_matched_2 && patElem instanceof BindingElement) {
                _matched_2 = true;
                _switchResult_2 = DestructNode.toEntry((BindingElement)patElem, litElem);
            }
            if (!_matched_2 && patElem instanceof BindingProperty) {
                _matched_2 = true;
                _switchResult_2 = DestructNode.toEntry((BindingProperty)patElem, litElem);
            }
            if ((nestedNode = _switchResult_2) == null) continue;
            nestedDNs.add((Object)nestedNode);
        }
        return (DestructNode[])Conversions.unwrapArray((Object)nestedDNs, DestructNode.class);
    }

    private static DestructNode toEntry(ArrayElement elem, EObject rhs) {
        DestructNode _xblockexpression = null;
        EObject _xifexpression = null;
        _xifexpression = rhs instanceof ArrayElement ? ((ArrayElement)rhs).getExpression() : rhs;
        EObject rhsExpr = _xifexpression;
        Expression expr = elem.getExpression();
        DestructNode _xifexpression_1 = null;
        _xifexpression_1 = expr instanceof AssignmentExpression ? DestructNode.toEntry((EObject)elem, null, ((AssignmentExpression)expr).getLhs(), ((AssignmentExpression)expr).getRhs(), elem.isSpread(), rhsExpr) : DestructNode.toEntry((EObject)elem, null, expr, null, elem.isSpread(), rhsExpr);
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    private static DestructNode toEntry(PropertyNameValuePair pa, EObject rhs) {
        DestructNode _xblockexpression = null;
        EObject _xifexpression = null;
        _xifexpression = rhs instanceof PropertyNameValuePair ? ((PropertyNameValuePair)rhs).getExpression() : rhs;
        EObject rhsExpr = _xifexpression;
        DestructNode _xifexpression_1 = null;
        if (pa instanceof PropertyNameValuePairSingleName) {
            _xifexpression_1 = DestructNode.toEntry(pa, ((PropertyNameValuePairSingleName)pa).getName(), ((PropertyNameValuePairSingleName)pa).getIdentifierRef(), ((PropertyNameValuePairSingleName)pa).getExpression(), false, rhsExpr);
        } else {
            DestructNode _xblockexpression_1 = null;
            Expression expr = pa.getExpression();
            DestructNode _xifexpression_2 = null;
            _xifexpression_2 = expr instanceof AssignmentExpression ? DestructNode.toEntry(pa, pa.getName(), ((AssignmentExpression)expr).getLhs(), ((AssignmentExpression)expr).getRhs(), false, rhsExpr) : DestructNode.toEntry(pa, pa.getName(), expr, null, false, rhsExpr);
            _xifexpression_1 = _xblockexpression_1 = _xifexpression_2;
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    private static DestructNode toEntry(BindingElement elem, EObject rhs) {
        boolean _tripleNotEquals;
        DestructNode _xblockexpression = null;
        EObject _xifexpression = null;
        _xifexpression = rhs instanceof ArrayElement ? ((ArrayElement)rhs).getExpression() : rhs;
        EObject expr = _xifexpression;
        DestructNode _xifexpression_1 = null;
        VariableDeclaration _varDecl = elem.getVarDecl();
        boolean bl = _tripleNotEquals = _varDecl != null;
        if (_tripleNotEquals) {
            _xifexpression_1 = DestructNode.toEntry(elem, null, elem.getVarDecl(), elem.getVarDecl().getExpression(), elem.isRest(), expr);
        } else {
            DestructNode _xifexpression_2 = null;
            BindingPattern _nestedPattern = elem.getNestedPattern();
            boolean _tripleNotEquals_1 = _nestedPattern != null;
            _xifexpression_2 = _tripleNotEquals_1 ? DestructNode.toEntry(elem, null, elem.getNestedPattern(), elem.getExpression(), elem.isRest(), expr) : DestructNode.toEntry(elem, null, null, null, false, expr);
            _xifexpression_1 = _xifexpression_2;
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    private static DestructNode toEntry(BindingProperty prop, EObject rhs) {
        boolean _tripleNotEquals;
        DestructNode _xifexpression = null;
        BindingElement _value = prop.getValue();
        VariableDeclaration _varDecl = null;
        if (_value != null) {
            _varDecl = _value.getVarDecl();
        }
        boolean bl = _tripleNotEquals = _varDecl != null;
        if (_tripleNotEquals) {
            DestructNode _xblockexpression = null;
            EObject expr = DestructNode.getPropertyAssignmentExpression(rhs);
            _xifexpression = _xblockexpression = DestructNode.toEntry(prop, prop.getName(), prop.getValue().getVarDecl(), prop.getValue().getVarDecl().getExpression(), false, expr);
        } else {
            boolean _tripleNotEquals_1;
            DestructNode _xifexpression_1 = null;
            BindingElement _value_1 = prop.getValue();
            BindingPattern _nestedPattern = null;
            if (_value_1 != null) {
                _nestedPattern = _value_1.getNestedPattern();
            }
            boolean bl2 = _tripleNotEquals_1 = _nestedPattern != null;
            if (_tripleNotEquals_1) {
                DestructNode _xblockexpression_1 = null;
                EObject expr = DestructNode.getPropertyAssignmentExpression(rhs);
                _xifexpression_1 = _xblockexpression_1 = DestructNode.toEntry(prop, prop.getName(), prop.getValue().getNestedPattern(), prop.getValue().getExpression(), false, expr);
            } else {
                _xifexpression_1 = DestructNode.toEntry(prop, null, null, null, false, rhs);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private static DestructNode toEntry(EObject astElement, String propName, EObject bindingTarget, Expression defaultExpr, boolean rest, EObject rhs) {
        DestructNode _xifexpression = null;
        if (bindingTarget == null) {
            _xifexpression = new DestructNode(astElement, propName, null, null, null, defaultExpr, null, rest);
        } else {
            DestructNode _xifexpression_1 = null;
            if (bindingTarget instanceof IdentifierRef) {
                _xifexpression_1 = new DestructNode(astElement, propName, (IdentifierRef)bindingTarget, null, null, defaultExpr, rhs, rest);
            } else {
                DestructNode _xifexpression_2 = null;
                if (bindingTarget instanceof VariableDeclaration) {
                    _xifexpression_2 = new DestructNode(astElement, propName, null, (VariableDeclaration)bindingTarget, null, defaultExpr, rhs, rest);
                } else {
                    DestructNode _xifexpression_3 = null;
                    if (bindingTarget instanceof ArrayLiteral || bindingTarget instanceof ObjectLiteral || bindingTarget instanceof BindingPattern) {
                        DestructNode[] _entries = DestructNode.toEntries(bindingTarget, rhs);
                        _xifexpression_3 = new DestructNode(astElement, propName, null, null, _entries, defaultExpr, rhs, rest);
                    } else {
                        _xifexpression_3 = new DestructNode(astElement, propName, null, null, null, defaultExpr, null, rest);
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private static EObject getPropertyAssignmentExpression(EObject rhs) {
        boolean _matched = false;
        if (rhs instanceof PropertyGetterDeclaration) {
            _matched = true;
            return ((PropertyGetterDeclaration)rhs).getDefinedFunctionOrAccessor();
        }
        if (!_matched && rhs instanceof PropertySetterDeclaration) {
            _matched = true;
            return ((PropertySetterDeclaration)rhs).getDefinedFunctionOrAccessor();
        }
        if (!_matched && rhs instanceof PropertyMethodDeclaration) {
            _matched = true;
            return ((PropertyMethodDeclaration)rhs).getDefinedFunctionOrAccessor();
        }
        if (!_matched && rhs instanceof PropertyNameValuePair) {
            _matched = true;
            return ((PropertyNameValuePair)rhs).getExpression();
        }
        if (!_matched && rhs instanceof PropertyAssignmentAnnotationList) {
            _matched = true;
            return null;
        }
        return rhs;
    }

    public List<Expression> getAllDeclaredIdRefs() {
        LinkedList<Expression> idRefs = new LinkedList<Expression>();
        Iterator allNestedNodes = this.stream().iterator();
        while (allNestedNodes.hasNext()) {
            EObject eobj = ((DestructNode)allNestedNodes.next()).getAstElement();
            if (eobj instanceof ArrayElement) {
                Expression expr = ((ArrayElement)eobj).getExpression();
                if (expr instanceof AssignmentExpression) {
                    idRefs.add(((AssignmentExpression)expr).getLhs());
                    continue;
                }
                idRefs.add(expr);
                continue;
            }
            if (eobj instanceof PropertyNameValuePairSingleName) {
                idRefs.add(((PropertyNameValuePairSingleName)eobj).getIdentifierRef());
                continue;
            }
            if (!(eobj instanceof PropertyNameValuePair)) continue;
            Expression expr_1 = ((PropertyNameValuePair)eobj).getExpression();
            if (expr_1 instanceof AssignmentExpression) {
                idRefs.add(((AssignmentExpression)expr_1).getLhs());
                continue;
            }
            idRefs.add(expr_1);
        }
        return idRefs;
    }

    public static Pair<EObject, EObject> getValueFromDestructuring(EObject nodeElem) {
        EObject node = nodeElem;
        EObject topNode = null;
        EObject dNodeElem = null;
        boolean breakSearch = false;
        while (!breakSearch) {
            EObject parent = node.eContainer();
            dNodeElem = DestructNode.getDNodeElem(dNodeElem, parent, node);
            topNode = DestructNode.getTopElem(topNode, parent);
            breakSearch = parent instanceof Statement;
            node = parent;
        }
        DestructNode _xifexpression = null;
        if (topNode instanceof AssignmentExpression) {
            _xifexpression = DestructNode.unify((AssignmentExpression)topNode);
        } else {
            DestructNode _xifexpression_1 = null;
            if (topNode instanceof VariableBinding) {
                _xifexpression_1 = DestructNode.unify((VariableBinding)topNode);
            } else {
                DestructNode _xifexpression_2 = null;
                _xifexpression_2 = topNode instanceof ForStatement ? DestructNode.unify((ForStatement)topNode) : null;
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        DestructNode dNode = _xifexpression;
        if (dNode != null && (dNode = dNode.findNodeForElement(dNodeElem)) != null) {
            EObject assgnValue = dNode.getAssignedElem();
            Expression defaultValue = dNode.getDefaultExpr();
            return Pair.of((Object)assgnValue, (Object)defaultValue);
        }
        return null;
    }

    private static EObject getDNodeElem(EObject dNodeElem, EObject parent, EObject node) {
        if (dNodeElem != null) {
            return dNodeElem;
        }
        if (node instanceof BindingElement && parent instanceof BindingProperty) {
            return parent;
        }
        if (node instanceof BindingElement || node instanceof ArrayElement || node instanceof PropertyAssignment) {
            return node;
        }
        return null;
    }

    private static EObject getTopElem(EObject oldTopNode, EObject parent) {
        EObject _xblockexpression = null;
        ControlFlowElement _switchResult = null;
        boolean _matched = false;
        if (parent instanceof ForStatement) {
            _matched = true;
            _switchResult = (ControlFlowElement)parent;
        }
        if (!_matched && parent instanceof AssignmentExpression) {
            _matched = true;
            _switchResult = (ControlFlowElement)parent;
        }
        if (!_matched && parent instanceof VariableBinding) {
            _matched = true;
            _switchResult = (ControlFlowElement)parent;
        }
        if (!_matched) {
            _switchResult = null;
        }
        ControlFlowElement newTopNode = _switchResult;
        EObject _xifexpression = null;
        if (newTopNode != null) {
            return newTopNode;
        }
        _xblockexpression = _xifexpression = oldTopNode;
        return _xblockexpression;
    }

    public static List<Expression> getAllDeclaredIdRefs(EObject eobj) {
        DestructNode dnode;
        DestructNode _switchResult = null;
        boolean _matched = false;
        if (eobj instanceof ForStatement) {
            _matched = true;
            _switchResult = DestructNode.unify((ForStatement)eobj);
        }
        if (!_matched && eobj instanceof VariableBinding) {
            _matched = true;
            _switchResult = DestructNode.unify((VariableBinding)eobj);
        }
        if (!_matched && eobj instanceof AssignmentExpression) {
            _matched = true;
            _switchResult = DestructNode.unify((AssignmentExpression)eobj);
        }
        if (!_matched) {
            _switchResult = null;
        }
        if ((dnode = _switchResult) == null) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return dnode.getAllDeclaredIdRefs();
    }

    public DestructNode(EObject astElement, String propName, IdentifierRef varRef, VariableDeclaration varDecl, DestructNode[] nestedNodes, Expression defaultExpr, EObject assignedElem, boolean rest) {
        this.astElement = astElement;
        this.propName = propName;
        this.varRef = varRef;
        this.varDecl = varDecl;
        this.nestedNodes = nestedNodes;
        this.defaultExpr = defaultExpr;
        this.assignedElem = assignedElem;
        this.rest = rest;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.astElement == null ? 0 : this.astElement.hashCode());
        result = 31 * result + (this.propName == null ? 0 : this.propName.hashCode());
        result = 31 * result + (this.varRef == null ? 0 : this.varRef.hashCode());
        result = 31 * result + (this.varDecl == null ? 0 : this.varDecl.hashCode());
        result = 31 * result + (this.nestedNodes == null ? 0 : Arrays.deepHashCode(this.nestedNodes));
        result = 31 * result + (this.defaultExpr == null ? 0 : this.defaultExpr.hashCode());
        result = 31 * result + (this.assignedElem == null ? 0 : this.assignedElem.hashCode());
        return 31 * result + (this.rest ? 1231 : 1237);
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DestructNode other = (DestructNode)obj;
        if (this.astElement == null ? other.astElement != null : !this.astElement.equals(other.astElement)) {
            return false;
        }
        if (this.propName == null ? other.propName != null : !this.propName.equals(other.propName)) {
            return false;
        }
        if (this.varRef == null ? other.varRef != null : !this.varRef.equals(other.varRef)) {
            return false;
        }
        if (this.varDecl == null ? other.varDecl != null : !this.varDecl.equals(other.varDecl)) {
            return false;
        }
        if (this.nestedNodes == null ? other.nestedNodes != null : !Arrays.deepEquals(this.nestedNodes, other.nestedNodes)) {
            return false;
        }
        if (this.defaultExpr == null ? other.defaultExpr != null : !this.defaultExpr.equals(other.defaultExpr)) {
            return false;
        }
        if (this.assignedElem == null ? other.assignedElem != null : !this.assignedElem.equals(other.assignedElem)) {
            return false;
        }
        return other.rest == this.rest;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("astElement", (Object)this.astElement);
        b.add("propName", (Object)this.propName);
        b.add("varRef", (Object)this.varRef);
        b.add("varDecl", (Object)this.varDecl);
        b.add("nestedNodes", (Object)this.nestedNodes);
        b.add("defaultExpr", (Object)this.defaultExpr);
        b.add("assignedElem", (Object)this.assignedElem);
        b.add("rest", (Object)this.rest);
        return b.toString();
    }

    @Pure
    public EObject getAstElement() {
        return this.astElement;
    }

    @Pure
    public String getPropName() {
        return this.propName;
    }

    @Pure
    public IdentifierRef getVarRef() {
        return this.varRef;
    }

    @Pure
    public VariableDeclaration getVarDecl() {
        return this.varDecl;
    }

    @Pure
    public DestructNode[] getNestedNodes() {
        return this.nestedNodes;
    }

    @Pure
    public Expression getDefaultExpr() {
        return this.defaultExpr;
    }

    @Pure
    public EObject getAssignedElem() {
        return this.assignedElem;
    }

    @Pure
    public boolean isRest() {
        return this.rest;
    }
}

