/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.assistants;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FieldAccessor;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.SetterDeclaration;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VersionedElement;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.DelegationAssistant;
import org.eclipse.n4js.transpiler.im.DelegatingMember;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ReferencingElementExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.util.SuperInterfacesIterable;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class BootstrapCallAssistant
extends TransformationAssistant {
    @Inject
    private DelegationAssistant delegationAssistant;
    @Inject
    private TypeAssistant typeAssistant;
    @Inject
    private ResourceNameComputer resourceNameComputer;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public ExpressionStatement createMakeClassCall(N4ClassDeclaration classDecl, SymbolTableEntry superClassSTE) {
        ParameterizedCallExpression __CallExpr = TranspilerBuilderBlocks._CallExpr();
        Procedures.Procedure1 _function = it -> {
            it.setTarget((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_$makeClass()));
            EList _arguments = it.getArguments();
            IdentifierRef_IM __IdentRef = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.findSymbolTableEntryForElement((NamedElement)classDecl, false));
            ReferencingElementExpression_IM ___NSSafe_IdentRef = this.__NSSafe_IdentRef(superClassSTE);
            ArrayLiteral _createDirectlyImplementedOrExtendedInterfacesArgument = this.createDirectlyImplementedOrExtendedInterfacesArgument((N4ClassifierDeclaration)classDecl);
            ObjectLiteral _createMemberDefinitions = this.createMemberDefinitions((N4ClassifierDeclaration)classDecl, false);
            ObjectLiteral _createMemberDefinitions_1 = this.createMemberDefinitions((N4ClassifierDeclaration)classDecl, true);
            FunctionExpression _createN4TypeMetaInfoFactoryFunction = this.createN4TypeMetaInfoFactoryFunction((N4TypeDeclaration)classDecl, superClassSTE);
            Functions.Function1 _function_1 = it_1 -> TranspilerBuilderBlocks._Argument((Expression)it_1);
            List _map = ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{__IdentRef, ___NSSafe_IdentRef, _createDirectlyImplementedOrExtendedInterfacesArgument, _createMemberDefinitions, _createMemberDefinitions_1, _createN4TypeMetaInfoFactoryFunction})), (Functions.Function1)_function_1);
            Iterables.addAll((Collection)_arguments, (Iterable)_map);
        };
        ParameterizedCallExpression _doubleArrow = (ParameterizedCallExpression)ObjectExtensions.operator_doubleArrow((Object)__CallExpr, (Procedures.Procedure1)_function);
        return TranspilerBuilderBlocks._ExprStmnt((Expression)_doubleArrow);
    }

    public Statement[] createInterfaceMemberDefinitionSection(N4InterfaceDeclaration ifcDecl) {
        boolean _not;
        ArrayList result = CollectionLiterals.newArrayList();
        SymbolTableEntry ifcSTE = this.findSymbolTableEntryForElement((NamedElement)ifcDecl, true);
        SymbolTableEntryInternal $methodsSTE = this.steFor_$methods();
        SymbolTableEntryOriginal objectSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), true);
        SymbolTableEntryOriginal definePropertiesSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), "defineProperties", false, true, true);
        AssignmentExpression __AssignmentExpr = TranspilerBuilderBlocks._AssignmentExpr();
        Procedures.Procedure1 _function = it -> {
            it.setLhs((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)ifcSTE, (SymbolTableEntry[])new SymbolTableEntry[]{$methodsSTE}));
            it.setRhs((Expression)this.createMemberDefinitions((N4ClassifierDeclaration)ifcDecl, false));
        };
        AssignmentExpression _doubleArrow = (AssignmentExpression)ObjectExtensions.operator_doubleArrow((Object)__AssignmentExpr, (Procedures.Procedure1)_function);
        ExpressionStatement __ExprStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)_doubleArrow);
        result.add(__ExprStmnt);
        ObjectLiteral staticMemberDefinitions = this.createMemberDefinitions((N4ClassifierDeclaration)ifcDecl, true);
        boolean _isEmpty = staticMemberDefinitions.getPropertyAssignments().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ExpressionStatement __ExprStmnt_1 = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)objectSTE, (SymbolTableEntry[])new SymbolTableEntry[]{definePropertiesSTE}), (Expression[])new Expression[]{TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)ifcSTE), staticMemberDefinitions}));
            result.add(__ExprStmnt_1);
        }
        return (Statement[])Conversions.unwrapArray((Object)result, Statement.class);
    }

    public ExpressionStatement createMakeInterfaceCall(N4InterfaceDeclaration ifcDecl) {
        ArrayLiteral extendedInterfaces = this.createDirectlyImplementedOrExtendedInterfacesArgument((N4ClassifierDeclaration)ifcDecl);
        Object _xifexpression = null;
        boolean _isEmpty = extendedInterfaces.getElements().isEmpty();
        boolean _not = !_isEmpty;
        _xifexpression = _not ? TranspilerBuilderBlocks._ArrowFunc((boolean)false, (FormalParameter[])new FormalParameter[0], (Expression)extendedInterfaces) : this.undefinedRef();
        IdentifierRef_IM extendedInterfacesFn = _xifexpression;
        ParameterizedCallExpression __CallExpr = TranspilerBuilderBlocks._CallExpr();
        Procedures.Procedure1 _function = arg_0 -> this.lambda$3(ifcDecl, (Expression)extendedInterfacesFn, arg_0);
        ParameterizedCallExpression _doubleArrow = (ParameterizedCallExpression)ObjectExtensions.operator_doubleArrow((Object)__CallExpr, (Procedures.Procedure1)_function);
        return TranspilerBuilderBlocks._ExprStmnt((Expression)_doubleArrow);
    }

    public ExpressionStatement createMakeEnumCall(N4EnumDeclaration enumDecl) {
        boolean isStringBased = AnnotationDefinition.STRING_BASED.hasAnnotation((AnnotableElement)enumDecl);
        if (isStringBased) {
            throw new IllegalArgumentException("must not create $makeEnum() call for @StringBased enums (they are no longer represented in output code)");
        }
        ArrayLiteral enumLiteralArray = TranspilerBuilderBlocks._ArrLit();
        EList _literals = enumDecl.getLiterals();
        for (N4EnumLiteral literal : _literals) {
            String _name;
            EList _elements = enumLiteralArray.getElements();
            String _elvis = null;
            String _value = literal.getValue();
            _elvis = _value != null ? _value : (_name = literal.getName());
            ArrayElement __ArrayElement = TranspilerBuilderBlocks._ArrayElement((Expression)TranspilerBuilderBlocks._ArrLit((Expression[])new Expression[]{TranspilerBuilderBlocks._StringLiteral((String)literal.getName()), TranspilerBuilderBlocks._StringLiteral((String)_elvis)}));
            _elements.add((Object)__ArrayElement);
        }
        ParameterizedCallExpression __CallExpr = TranspilerBuilderBlocks._CallExpr();
        Procedures.Procedure1 _function = it -> {
            it.setTarget((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_$makeEnum()));
            EList _arguments = it.getArguments();
            IdentifierRef_IM __IdentRef = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.findSymbolTableEntryForElement((NamedElement)enumDecl, false));
            FunctionExpression _createN4TypeMetaInfoFactoryFunction = this.createN4TypeMetaInfoFactoryFunction((N4TypeDeclaration)enumDecl, null);
            Functions.Function1 _function_1 = it_1 -> TranspilerBuilderBlocks._Argument((Expression)it_1);
            List _map = ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{__IdentRef, enumLiteralArray, _createN4TypeMetaInfoFactoryFunction})), (Functions.Function1)_function_1);
            Iterables.addAll((Collection)_arguments, (Iterable)_map);
        };
        ParameterizedCallExpression _doubleArrow = (ParameterizedCallExpression)ObjectExtensions.operator_doubleArrow((Object)__CallExpr, (Procedures.Procedure1)_function);
        return TranspilerBuilderBlocks._ExprStmnt((Expression)_doubleArrow);
    }

    private ObjectLiteral createMemberDefinitions(N4ClassifierDeclaration classDecl, boolean _static) {
        Functions.Function1 _function = it -> Boolean.valueOf(it.isStatic()) == Boolean.valueOf(_static) && !this.isAbstract((ModifiableElement)it) && !it.isConstructor();
        Iterable membersToProcess = IterableExtensions.filter((Iterable)classDecl.getOwnedMembers(), (Functions.Function1)_function);
        if (classDecl instanceof N4InterfaceDeclaration) {
            Functions.Function1 _function_1 = it -> it instanceof FunctionOrFieldAccessor && ((FunctionOrFieldAccessor)it).getBody() != null || it instanceof DelegatingMember && !((DelegatingMember)it).isDelegationTargetIsAbstract();
            membersToProcess = IterableExtensions.filter((Iterable)membersToProcess, (Functions.Function1)_function_1);
        }
        ArrayList fields = CollectionLiterals.newArrayList();
        ArrayListMultimap accessors = ArrayListMultimap.create();
        ArrayList methods = CollectionLiterals.newArrayList();
        for (N4MemberDeclaration m : membersToProcess) {
            boolean _matched = false;
            if (m instanceof N4FieldDeclaration) {
                _matched = true;
                fields.add((N4FieldDeclaration)m);
            }
            if (!_matched && m instanceof FieldAccessor) {
                _matched = true;
                accessors.put((Object)m.getName(), (Object)((FieldAccessor)m));
            }
            if (!_matched && m instanceof N4MethodDeclaration) {
                _matched = true;
                methods.add((N4MethodDeclaration)m);
            }
            if (_matched) continue;
            String _name = m.eClass().getName();
            String _plus = "unsupported type of member: " + _name;
            throw new IllegalStateException(_plus);
        }
        List _xifexpression = null;
        if (_static && classDecl instanceof VersionedElement && ((VersionedElement)classDecl).hasDeclaredVersion()) {
            PropertyNameValuePair _createEmptyObjectMemberForName = this.createEmptyObjectMemberForName("$migrations__n4");
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new PropertyNameValuePair[]{_createEmptyObjectMemberForName}));
        } else {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        List staticMigrationsField = _xifexpression;
        Functions.Function1 _function_2 = it -> this.createMemberDefinitionForMethod((N4MethodDeclaration)it);
        List _map = ListExtensions.map((List)methods, (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = accName -> this.createMemberDefinitionForAccessor(accessors.get(accName));
        Iterable _map_1 = IterableExtensions.map((Iterable)IterableExtensions.toSet((Iterable)accessors.keys()), (Functions.Function1)_function_3);
        Iterable _plus_1 = Iterables.concat((Iterable)_map, (Iterable)_map_1);
        Functions.Function1 _function_4 = it -> this.createMemberDefinitionForField((N4FieldDeclaration)it);
        List _map_2 = ListExtensions.map((List)fields, (Functions.Function1)_function_4);
        Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, (Iterable)_map_2);
        return TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])((PropertyAssignment[])Conversions.unwrapArray((Object)IterableExtensions.filterNull((Iterable)Iterables.concat((Iterable)_plus_2, staticMigrationsField)), PropertyAssignment.class)));
    }

    private PropertyNameValuePair createEmptyObjectMemberForName(String name) {
        ObjectLiteral __ObjLit = TranspilerBuilderBlocks._ObjLit();
        Pair _mappedTo = Pair.of((Object)"value", (Object)__ObjLit);
        BooleanLiteral __TRUE = TranspilerBuilderBlocks._TRUE();
        Pair _mappedTo_1 = Pair.of((Object)"writable", (Object)__TRUE);
        BooleanLiteral __FALSE = TranspilerBuilderBlocks._FALSE();
        Pair _mappedTo_2 = Pair.of((Object)"configurable", (Object)__FALSE);
        BooleanLiteral __FALSE_1 = TranspilerBuilderBlocks._FALSE();
        Pair _mappedTo_3 = Pair.of((Object)"enumerable", (Object)__FALSE_1);
        return TranspilerBuilderBlocks._PropertyNameValuePair((String)name, (Expression)TranspilerBuilderBlocks._ObjLit((Pair[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3}));
    }

    private PropertyNameValuePair createMemberDefinitionForField(N4FieldDeclaration fieldDecl) {
        IdentifierRef_IM _undefinedRef = this.undefinedRef();
        Pair _mappedTo = Pair.of((Object)"value", (Object)_undefinedRef);
        BooleanLiteral __TRUE = TranspilerBuilderBlocks._TRUE();
        Pair _mappedTo_1 = Pair.of((Object)"writable", (Object)__TRUE);
        return TranspilerBuilderBlocks._PropertyNameValuePair((String)fieldDecl.getName(), (Expression)TranspilerBuilderBlocks._ObjLit((Pair[])new Pair[]{_mappedTo, _mappedTo_1}));
    }

    private PropertyNameValuePair createMemberDefinitionForAccessor(List<FieldAccessor> accDecls) {
        String _name_1;
        GetterDeclaration getter = (GetterDeclaration)IterableExtensions.head((Iterable)Iterables.filter(accDecls, GetterDeclaration.class));
        SetterDeclaration setter = (SetterDeclaration)IterableExtensions.head((Iterable)Iterables.filter(accDecls, SetterDeclaration.class));
        if (getter == null && setter == null) {
            throw new IllegalArgumentException("must provide a getter, a setter or both");
        }
        String _elvis = null;
        String _name = null;
        if (getter != null) {
            _name = getter.getName();
        }
        _elvis = _name != null ? _name : (_name_1 = setter.getName());
        String name = _elvis;
        ObjectLiteral __ObjLit = TranspilerBuilderBlocks._ObjLit();
        Procedures.Procedure1 _function = it -> {
            if (getter != null) {
                EList _propertyAssignments = it.getPropertyAssignments();
                Object _xifexpression = null;
                _xifexpression = getter instanceof DelegatingMember ? this.delegationAssistant.createDelegationCode((DelegatingMember)getter) : this.createMemberFunction((FunctionOrFieldAccessor)getter);
                PropertyNameValuePair __PropertyNameValuePair = TranspilerBuilderBlocks._PropertyNameValuePair((String)"get", (Expression)_xifexpression);
                _propertyAssignments.add((Object)__PropertyNameValuePair);
            }
            if (setter != null) {
                EList _propertyAssignments_1 = it.getPropertyAssignments();
                Object _xifexpression_1 = null;
                _xifexpression_1 = setter instanceof DelegatingMember ? this.delegationAssistant.createDelegationCode((DelegatingMember)setter) : this.createMemberFunction((FunctionOrFieldAccessor)setter);
                PropertyNameValuePair __PropertyNameValuePair_1 = TranspilerBuilderBlocks._PropertyNameValuePair((String)"set", (Expression)_xifexpression_1);
                _propertyAssignments_1.add((Object)__PropertyNameValuePair_1);
            }
        };
        ObjectLiteral _doubleArrow = (ObjectLiteral)ObjectExtensions.operator_doubleArrow((Object)__ObjLit, (Procedures.Procedure1)_function);
        return TranspilerBuilderBlocks._PropertyNameValuePair((String)name, (Expression)_doubleArrow);
    }

    private PropertyNameValuePair createMemberDefinitionForMethod(N4MethodDeclaration methDecl) {
        Object _xifexpression = null;
        _xifexpression = methDecl instanceof DelegatingMember ? this.delegationAssistant.createDelegationCode((DelegatingMember)methDecl) : this.createMemberFunction((FunctionOrFieldAccessor)methDecl);
        return TranspilerBuilderBlocks._PropertyNameValuePair((String)methDecl.getName(), (Expression)TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])new PropertyAssignment[]{TranspilerBuilderBlocks._PropertyNameValuePair((String)"value", (Expression)_xifexpression)}));
    }

    private FunctionExpression createMemberFunction(FunctionOrFieldAccessor template) {
        boolean _not;
        FunctionExpression result = TranspilerBuilderBlocks._FunExpr((boolean)template.isAsync(), (Statement[])new Statement[0]);
        result.setName(this.getMemberFunctionName(template));
        EList _fpars = result.getFpars();
        Object _switchResult = null;
        boolean _matched = false;
        if (template instanceof FunctionDefinition) {
            _matched = true;
            _switchResult = ((FunctionDefinition)template).getFpars();
        }
        if (!_matched && template instanceof SetterDeclaration) {
            _matched = true;
            FormalParameter _fpar = ((SetterDeclaration)template).getFpar();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new FormalParameter[]{_fpar}));
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Iterables.addAll((Collection)_fpars, (Iterable)_switchResult);
        result.set_lok(template.get_lok());
        result.setBody(template.getBody());
        boolean _xifexpression = false;
        _xifexpression = template instanceof FunctionDefinition ? ((FunctionDefinition)template).isGenerator() : false;
        result.setGenerator(_xifexpression);
        boolean _isEmpty = template.getAnnotations().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            result.setAnnotationList(TranspilerBuilderBlocks._ExprAnnoList((Annotation[])((Annotation[])Conversions.unwrapArray((Object)template.getAnnotations(), Annotation.class))));
        }
        return result;
    }

    private FunctionExpression createN4TypeMetaInfoFactoryFunction(N4TypeDeclaration typeDecl, SymbolTableEntry superClassSTE) {
        VariableDeclaration varDeclMetaClass = this.createMetaClassVariable(typeDecl, superClassSTE);
        FormalParameter __Fpar = TranspilerBuilderBlocks._Fpar((String)"instanceProto");
        FormalParameter __Fpar_1 = TranspilerBuilderBlocks._Fpar((String)"staticProto");
        Block __Block = TranspilerBuilderBlocks._Block((Statement[])new Statement[0]);
        Procedures.Procedure1 _function = it -> {
            EList _statements = it.getStatements();
            VariableStatement __VariableStatement = TranspilerBuilderBlocks._VariableStatement((VariableDeclaration[])new VariableDeclaration[]{varDeclMetaClass});
            ExpressionStatement __SnippetAsStmnt = TranspilerBuilderBlocks._SnippetAsStmnt((String)"return metaClass;");
            Iterables.addAll((Collection)_statements, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Statement[]{__VariableStatement, __SnippetAsStmnt})));
        };
        Block _doubleArrow = (Block)ObjectExtensions.operator_doubleArrow((Object)__Block, (Procedures.Procedure1)_function);
        return TranspilerBuilderBlocks._FunExpr((boolean)false, null, (FormalParameter[])new FormalParameter[]{__Fpar, __Fpar_1}, (Block)_doubleArrow);
    }

    private VariableDeclaration createMetaClassVariable(N4TypeDeclaration typeDecl, SymbolTableEntry superClassSTE) {
        SymbolTableEntry typeSTE = this.findSymbolTableEntryForElement((NamedElement)typeDecl, true);
        Type type = this.getState().info.getOriginalDefinedType(typeDecl);
        Expression n4superType = this.createN4SuperTypeRef(typeDecl, superClassSTE);
        Iterable _xifexpression = null;
        if (type instanceof TClassifier) {
            Functions.Function1 _function = it -> {
                boolean _isStructurallyTyped = this.isStructurallyTyped((TN4Classifier)it);
                return !_isStructurallyTyped;
            };
            _xifexpression = IterableExtensions.filter((Iterable)SuperInterfacesIterable.of((TClassifier)((TClassifier)type)), (Functions.Function1)_function);
        } else {
            _xifexpression = CollectionLiterals.emptyList();
        }
        List allImplementedInterfaces = _xifexpression;
        Iterable<Object> _xifexpression_1 = null;
        if (typeDecl instanceof N4ClassifierDeclaration) {
            Functions.Function1 _function_1 = it -> {
                boolean _isConsumedFromInterface = this.getState().info.isConsumedFromInterface(it);
                return !_isConsumedFromInterface;
            };
            _xifexpression_1 = IterableExtensions.filter((Iterable)((N4ClassifierDeclaration)typeDecl).getOwnedMembers(), (Functions.Function1)_function_1);
        } else {
            _xifexpression_1 = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        List ownedMembers = _xifexpression_1;
        Iterable<Object> _xifexpression_2 = null;
        if (typeDecl instanceof N4ClassifierDeclaration) {
            Functions.Function1 _function_2 = it -> this.getState().info.isConsumedFromInterface(it);
            _xifexpression_2 = IterableExtensions.filter((Iterable)((N4ClassifierDeclaration)typeDecl).getOwnedMembers(), (Functions.Function1)_function_2);
        } else {
            _xifexpression_2 = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        List consumedMembers = _xifexpression_2;
        SymbolTableEntryInternal _switchResult = null;
        boolean _matched = false;
        if (typeDecl instanceof N4ClassDefinition) {
            _matched = true;
            _switchResult = this.steFor_N4Class();
        }
        if (!_matched && typeDecl instanceof N4InterfaceDeclaration) {
            _matched = true;
            _switchResult = this.steFor_N4Interface();
        }
        if (!_matched && typeDecl instanceof N4EnumDeclaration) {
            _matched = true;
            _switchResult = this.steFor_N4EnumType();
        }
        if (!_matched) {
            String _name = typeDecl.eClass().getName();
            String _plus = "cannot handle declarations of type " + _name;
            throw new IllegalArgumentException(_plus);
        }
        SymbolTableEntryInternal metaClassSTE = _switchResult;
        String origin = this.resourceNameComputer.generateProjectDescriptor(this.getState().resource.getURI());
        String fqn = this.resourceNameComputer.getFullyQualifiedTypeName_WITH_LEGACY_SUPPORT(type);
        VariableDeclaration __VariableDeclaration = TranspilerBuilderBlocks._VariableDeclaration((String)"metaClass");
        Procedures.Procedure1 _function_3 = it -> {
            StringLiteral __StringLiteralForSTE = TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)typeSTE);
            Pair _mappedTo = Pair.of((Object)"name", (Object)__StringLiteralForSTE);
            StringLiteral __StringLiteral = TranspilerBuilderBlocks._StringLiteral((String)origin);
            Pair _mappedTo_1 = Pair.of((Object)"origin", (Object)__StringLiteral);
            StringLiteral __StringLiteral_1 = TranspilerBuilderBlocks._StringLiteral((String)fqn);
            Pair _mappedTo_2 = Pair.of((Object)"fqn", (Object)__StringLiteral_1);
            Pair _mappedTo_3 = Pair.of((Object)"n4superType", (Object)n4superType);
            Functions.Function1 _function_4 = it_1 -> this.resourceNameComputer.getFullyQualifiedTypeName_WITH_LEGACY_SUPPORT((Type)it_1);
            Functions.Function1 _function_5 = it_1 -> TranspilerBuilderBlocks._StringLiteral((String)it_1);
            ArrayLiteral __ArrLit = TranspilerBuilderBlocks._ArrLit((Expression[])((Expression[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)allImplementedInterfaces, (Functions.Function1)_function_4), (Functions.Function1)_function_5), Expression.class)));
            Pair _mappedTo_4 = Pair.of((Object)"allImplementedInterfaces", (Object)__ArrLit);
            Functions.Function1 _function_6 = it_1 -> this.createMemberDescriptor((N4MemberDeclaration)it_1);
            ArrayLiteral __ArrLit_1 = TranspilerBuilderBlocks._ArrLit((Expression[])((Expression[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)ownedMembers, (Functions.Function1)_function_6), Expression.class)));
            Pair _mappedTo_5 = Pair.of((Object)"ownedMembers", (Object)__ArrLit_1);
            Functions.Function1 _function_7 = it_1 -> this.createMemberDescriptor((N4MemberDeclaration)it_1);
            ArrayLiteral __ArrLit_2 = TranspilerBuilderBlocks._ArrLit((Expression[])((Expression[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)consumedMembers, (Functions.Function1)_function_7), Expression.class)));
            Pair _mappedTo_6 = Pair.of((Object)"consumedMembers", (Object)__ArrLit_2);
            ArrayLiteral __ArrLit_3 = TranspilerBuilderBlocks._ArrLit((Expression[])this.createRuntimeAnnotations((AnnotableElement)typeDecl));
            Pair _mappedTo_7 = Pair.of((Object)"annotations", (Object)__ArrLit_3);
            it.setExpression((Expression)TranspilerBuilderBlocks._NewExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)metaClassSTE), (Expression[])new Expression[]{TranspilerBuilderBlocks._ObjLit((Pair[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4, _mappedTo_5, _mappedTo_6, _mappedTo_7})}));
        };
        return (VariableDeclaration)ObjectExtensions.operator_doubleArrow((Object)__VariableDeclaration, (Procedures.Procedure1)_function_3);
    }

    private ArrayLiteral createDirectlyImplementedOrExtendedInterfacesArgument(N4ClassifierDeclaration typeDecl) {
        List interfaces = this.typeAssistant.getSuperInterfacesSTEs(typeDecl);
        Functions.Function1 _function = ifcSTE -> {
            IdentifiableElement tIfc = ifcSTE.getOriginalTarget();
            if (tIfc instanceof TInterface) {
                return !TypeUtils.isBuiltIn((Type)((Type)tIfc)) && (!this.inN4JSD((Type)tIfc) || AnnotationDefinition.N4JS.hasAnnotation((TAnnotableElement)tIfc));
            }
            return false;
        };
        Iterable directlyImplementedInterfacesFiltered = IterableExtensions.filter((Iterable)interfaces, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)it);
        return TranspilerBuilderBlocks._ArrLit((Expression[])((Expression[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)directlyImplementedInterfacesFiltered, (Functions.Function1)_function_1), Expression.class)));
    }

    private Expression createMemberDescriptor(N4MemberDeclaration memberDecl) {
        SymbolTableEntry memberSTE = this.findSymbolTableEntryForElement((NamedElement)memberDecl, true);
        SymbolTableEntryInternal _switchResult = null;
        boolean _matched = false;
        if (memberDecl instanceof N4MethodDeclaration) {
            _matched = true;
            _switchResult = this.steFor_N4Method();
        }
        if (!_matched && memberDecl instanceof FieldAccessor) {
            _matched = true;
            _switchResult = this.steFor_N4Accessor();
        }
        if (!_matched && memberDecl instanceof N4FieldDeclaration) {
            _matched = true;
            _switchResult = this.steFor_N4DataField();
        }
        if (!_matched) {
            _switchResult = this.steFor_N4Member();
        }
        SymbolTableEntryInternal n4MemberClassSTE = _switchResult;
        StringLiteral __StringLiteralForSTE = TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)memberSTE);
        Pair _mappedTo = Pair.of((Object)"name", (Object)__StringLiteralForSTE);
        Pair _xifexpression = null;
        if (memberDecl instanceof FieldAccessor) {
            BooleanLiteral __BooleanLiteral = TranspilerBuilderBlocks._BooleanLiteral((boolean)(memberDecl instanceof GetterDeclaration));
            _xifexpression = Pair.of((Object)"getter", (Object)__BooleanLiteral);
        }
        BooleanLiteral __BooleanLiteral_1 = TranspilerBuilderBlocks._BooleanLiteral((boolean)memberDecl.isStatic());
        Pair _mappedTo_1 = Pair.of((Object)"isStatic", (Object)__BooleanLiteral_1);
        Pair _xifexpression_1 = null;
        if (memberDecl instanceof N4MethodDeclaration) {
            Pair _xblockexpression = null;
            String memberName = ((N4MethodDeclaration)memberDecl).getName();
            boolean memberIsSymbol = memberName != null && memberName.startsWith("#");
            Object _xifexpression_2 = null;
            _xifexpression_2 = !memberIsSymbol ? TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)memberSTE) : this.typeAssistant.getMemberNameAsSymbol(memberName);
            StringLiteral memberExpr = _xifexpression_2;
            Pair _xifexpression_3 = null;
            boolean _isStatic = ((N4MethodDeclaration)memberDecl).isStatic();
            if (_isStatic) {
                IndexedAccessExpression __IndexAccessExpr = TranspilerBuilderBlocks._IndexAccessExpr((Expression)TranspilerBuilderBlocks._Snippet((String)"staticProto"), (Expression)memberExpr);
                _xifexpression_3 = Pair.of((Object)"jsFunction", (Object)__IndexAccessExpr);
            } else {
                IndexedAccessExpression __IndexAccessExpr_1 = TranspilerBuilderBlocks._IndexAccessExpr((Expression)TranspilerBuilderBlocks._Snippet((String)"instanceProto"), (Expression)memberExpr);
                _xifexpression_3 = Pair.of((Object)"jsFunction", (Object)__IndexAccessExpr_1);
            }
            _xifexpression_1 = _xblockexpression = _xifexpression_3;
        }
        ArrayLiteral __ArrLit = TranspilerBuilderBlocks._ArrLit((Expression[])this.createRuntimeAnnotations((AnnotableElement)memberDecl));
        Pair _mappedTo_2 = Pair.of((Object)"annotations", (Object)__ArrLit);
        return TranspilerBuilderBlocks._NewExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)n4MemberClassSTE), (Expression[])new Expression[]{TranspilerBuilderBlocks._ObjLit((Pair[])new Pair[]{_mappedTo, _xifexpression, _mappedTo_1, _xifexpression_1, _mappedTo_2})});
    }

    private NewExpression[] createRuntimeAnnotations(AnnotableElement annElem) {
        TAnnotableElement _switchResult = null;
        boolean _matched = false;
        if (annElem instanceof DelegatingMember) {
            _matched = true;
            IdentifiableElement _originalTarget = ((DelegatingMember)annElem).getDelegationTarget().getOriginalTarget();
            _switchResult = (TAnnotableElement)_originalTarget;
        }
        if (!_matched && annElem instanceof N4TypeDeclaration) {
            _matched = true;
            _switchResult = this.getState().info.getOriginalDefinedType((N4TypeDeclaration)annElem);
        }
        if (!_matched && annElem instanceof N4MemberDeclaration) {
            _matched = true;
            _switchResult = this.getState().info.getOriginalDefinedMember((N4MemberDeclaration)annElem);
        }
        if (!_matched && annElem instanceof TypeDefiningElement) {
            _matched = true;
            Type _xblockexpression = null;
            EObject original = this.getState().tracer.getOriginalASTNode((EObject)annElem);
            Type _xifexpression = null;
            if (original instanceof TypeDefiningElement) {
                _xifexpression = ((TypeDefiningElement)original).getDefinedType();
            }
            _xblockexpression = _xifexpression;
            _switchResult = _xblockexpression;
        }
        TAnnotableElement tAnnElem = _switchResult;
        return this.createRuntimeAnnotations(tAnnElem);
    }

    private NewExpression[] createRuntimeAnnotations(TAnnotableElement tAnnElem) {
        if (tAnnElem == null) {
            return new NewExpression[0];
        }
        Functions.Function1 _function = it -> {
            AnnotationDefinition.RetentionPolicy retention = AnnotationDefinition.find((String)it.getName()).retention;
            return retention == AnnotationDefinition.RetentionPolicy.RUNTIME || retention == AnnotationDefinition.RetentionPolicy.RUNTIME_TYPEFIELD;
        };
        Iterable runtimeAnnotations = IterableExtensions.filter((Iterable)tAnnElem.getAnnotations(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> this.createRuntimeAnnotation((TAnnotation)it);
        return (NewExpression[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)runtimeAnnotations, (Functions.Function1)_function_1), NewExpression.class);
    }

    private NewExpression createRuntimeAnnotation(TAnnotation ann) {
        NewExpression _xblockexpression = null;
        SymbolTableEntryInternal n4AnnotationSTE = this.steFor_N4Annotation();
        StringLiteral __StringLiteral = TranspilerBuilderBlocks._StringLiteral((String)ann.getName());
        Pair _mappedTo = Pair.of((Object)"name", (Object)__StringLiteral);
        Functions.Function1 _function = it -> it.getArgAsString();
        Functions.Function1 _function_1 = it -> TranspilerBuilderBlocks._StringLiteral((String)it);
        ArrayLiteral __ArrLit = TranspilerBuilderBlocks._ArrLit((Expression[])((Expression[])Conversions.unwrapArray((Object)ListExtensions.map((List)ListExtensions.map((List)ann.getArgs(), (Functions.Function1)_function), (Functions.Function1)_function_1), Expression.class)));
        Pair _mappedTo_1 = Pair.of((Object)"details", (Object)__ArrLit);
        _xblockexpression = TranspilerBuilderBlocks._NewExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)n4AnnotationSTE), (Expression[])new Expression[]{TranspilerBuilderBlocks._ObjLit((Pair[])new Pair[]{_mappedTo, _mappedTo_1})});
        return _xblockexpression;
    }

    private Expression createN4SuperTypeRef(N4TypeDeclaration typeDecl, SymbolTableEntry superClassSTE) {
        if (typeDecl instanceof N4ClassDeclaration) {
            TClass _n4ObjectType;
            boolean _tripleEquals;
            TClass type = this.getState().info.getOriginalDefinedType((N4ClassDeclaration)typeDecl);
            TClassifier superType = RuleEnvironmentExtensions.getDeclaredOrImplicitSuperType((RuleEnvironment)this.getState().G, (TClass)type);
            boolean bl = _tripleEquals = superType == (_n4ObjectType = RuleEnvironmentExtensions.n4ObjectType((RuleEnvironment)this.getState().G));
            if (_tripleEquals) {
                return TranspilerBuilderBlocks._Snippet((String)"N4Object.n4type");
            }
            if (superType instanceof TClass) {
                if (((TClass)superType).isExternal() && !AnnotationDefinition.N4JS.hasAnnotation((TAnnotableElement)superType)) {
                    return this.undefinedRef();
                }
                SymbolTableEntryOriginal superTypeSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)superType, true);
                SymbolTableEntryOriginal n4typeSTE = this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.n4ObjectType((RuleEnvironment)this.getState().G), "n4type", false, true, true);
                return this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)superTypeSTE, new SymbolTableEntry[]{n4typeSTE});
            }
            if (superType instanceof TObjectPrototype) {
                return this.undefinedRef();
            }
        }
        return this.undefinedRef();
    }

    private boolean isStructurallyTyped(TN4Classifier n4Classifier) {
        TypingStrategy ts = n4Classifier.getTypingStrategy();
        return ts == TypingStrategy.STRUCTURAL || ts == TypingStrategy.STRUCTURAL_FIELDS;
    }

    private String getMemberFunctionName(FunctionOrFieldAccessor m) {
        String _plus;
        String _firstUpper;
        String _switchResult = null;
        boolean _matched = false;
        if (m instanceof N4GetterDeclaration) {
            _matched = true;
            _firstUpper = Strings.toFirstUpper((String)((N4GetterDeclaration)m).getName());
            _plus = "get" + _firstUpper;
            _switchResult = BootstrapCallAssistant.getMemberFunctionName(_plus);
        }
        if (!_matched && m instanceof N4SetterDeclaration) {
            _matched = true;
            _firstUpper = Strings.toFirstUpper((String)((N4SetterDeclaration)m).getName());
            _plus = "set" + _firstUpper;
            _switchResult = BootstrapCallAssistant.getMemberFunctionName(_plus);
        }
        if (!_matched && m instanceof N4MethodDeclaration) {
            _matched = true;
            _switchResult = BootstrapCallAssistant.getMemberFunctionName(((N4MethodDeclaration)m).getName());
        }
        if (!_matched) {
            String _name = m.eClass().getName();
            _plus = "unsupported subclass of N4MemberDeclaration: " + _name;
            throw new IllegalArgumentException(_plus);
        }
        return _switchResult;
    }

    private static String getMemberFunctionName(String name) {
        boolean _not;
        boolean _isLegalIdentifier = TranspilerUtils.isLegalIdentifier((String)name);
        boolean bl = _not = !_isLegalIdentifier;
        if (_not) {
            String _sanitizeIdentifierName = TranspilerUtils.sanitizeIdentifierName((String)name);
            return String.valueOf(_sanitizeIdentifierName) + "___n4";
        }
        return String.valueOf(name) + "___n4";
    }

    private boolean inN4JSD(Type type) {
        return this.jsVariantHelper.isExternalMode((EObject)type);
    }

    private boolean isAbstract(ModifiableElement element) {
        return element.getDeclaredModifiers().contains((Object)N4Modifier.ABSTRACT);
    }

    private /* synthetic */ void lambda$3(N4InterfaceDeclaration n4InterfaceDeclaration, Expression expression, ParameterizedCallExpression it) {
        it.setTarget((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.steFor_$makeInterface()));
        EList _arguments = it.getArguments();
        IdentifierRef_IM __IdentRef = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.findSymbolTableEntryForElement((NamedElement)n4InterfaceDeclaration, false));
        FunctionExpression _createN4TypeMetaInfoFactoryFunction = this.createN4TypeMetaInfoFactoryFunction((N4TypeDeclaration)n4InterfaceDeclaration, null);
        Functions.Function1 _function_1 = it_1 -> TranspilerBuilderBlocks._Argument((Expression)it_1);
        List _map = ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Expression[]{__IdentRef, expression, _createN4TypeMetaInfoFactoryFunction})), (Functions.Function1)_function_1);
        Iterables.addAll((Collection)_arguments, (Iterable)_map);
    }
}

