/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.preferences.StringVariablePreferencePage;
import org.eclipse.debug.internal.ui.stringsubstitution.StringSubstitutionMessages;
import org.eclipse.debug.internal.ui.stringsubstitution.StringVariableLabelProvider;
import org.eclipse.debug.internal.ui.stringsubstitution.StringVariablePresentationManager;
import org.eclipse.debug.ui.stringsubstitution.IArgumentSelector;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class StringVariableSelectionDialog
extends ElementListSelectionDialog {
    private Button fArgumentButton;
    private Text fDescriptionText;
    private Text fArgumentText;
    private String fArgumentValue;
    private Button fShowAllButton;
    private Label fShowAllDescription;
    private ArrayList<VariableFilter> fFilters = new ArrayList();
    private boolean fShowAllSelected = false;

    public StringVariableSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new StringVariableLabelProvider());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(StringSubstitutionMessages.StringVariableSelectionDialog_2);
        this.setMessage(StringSubstitutionMessages.StringVariableSelectionDialog_3);
        this.setMultipleSelection(false);
        this.setElements(VariablesPlugin.getDefault().getStringVariableManager().getVariables());
    }

    public String getVariableExpression() {
        Object[] selected = this.getResult();
        if (selected != null && selected.length == 1) {
            IStringVariable variable = (IStringVariable)selected[0];
            StringBuilder buffer = new StringBuilder();
            buffer.append("${");
            buffer.append(variable.getName());
            if (this.fArgumentValue != null && this.fArgumentValue.length() > 0) {
                buffer.append(":");
                buffer.append(this.fArgumentValue);
            }
            buffer.append("}");
            return buffer.toString();
        }
        return null;
    }

    public void addVariableFilter(VariableFilter filter) {
        if (!this.fFilters.contains(filter)) {
            this.fFilters.add(filter);
        }
    }

    public void setFilters(VariableFilter[] filters) {
        this.fFilters.clear();
        if (filters != null && filters.length > 0) {
            this.fFilters.addAll(Arrays.asList(filters));
        }
    }

    private void updateElements() {
        Display display = DebugUIPlugin.getStandardDisplay();
        BusyIndicator.showWhile((Display)display, () -> {
            IStringVariable[] elements = VariablesPlugin.getDefault().getStringVariableManager().getVariables();
            display.asyncExec(() -> this.setListElements(elements));
        });
    }

    private void updateDescription() {
        if (this.fShowAllDescription != null && !this.fShowAllDescription.isDisposed()) {
            if (this.fShowAllSelected) {
                this.fShowAllDescription.setText(StringSubstitutionMessages.StringVariableSelectionDialog_11);
            } else {
                this.fShowAllDescription.setText(StringSubstitutionMessages.StringVariableSelectionDialog_10);
            }
        }
    }

    protected void setListElements(Object[] elements) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        filtered.addAll(Arrays.asList(elements));
        if (!this.fFilters.isEmpty() && !this.fShowAllSelected) {
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IDynamicVariable) {
                    boolean bFiltered = false;
                    int j = 0;
                    while (j < this.fFilters.size() && !bFiltered) {
                        VariableFilter filter = this.fFilters.get(j);
                        if (filter.isFiltered((IDynamicVariable)elements[i])) {
                            filtered.remove(elements[i]);
                            bFiltered = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        super.setListElements(filtered.toArray());
    }

    protected Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(ctrl, "org.eclipse.debug.ui.variable_selection_dialog_context");
        return ctrl;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.createArgumentArea((Composite)control);
        return control;
    }

    private void createArgumentArea(Composite parent) {
        Composite container = SWTFactory.createComposite(parent, parent.getFont(), 2, 1, 768, 0, 0);
        Composite btnContainer = SWTFactory.createComposite(container, parent.getFont(), 3, 2, 768, 0, 0);
        boolean bNeedShowAll = false;
        if (!this.fFilters.isEmpty()) {
            IStringVariable[] elements = VariablesPlugin.getDefault().getStringVariableManager().getVariables();
            int i = 0;
            while (i < elements.length && !bNeedShowAll) {
                if (elements[i] instanceof IDynamicVariable) {
                    int j = 0;
                    while (j < this.fFilters.size() && !bNeedShowAll) {
                        VariableFilter filter = this.fFilters.get(j);
                        if (filter.isFiltered((IDynamicVariable)elements[i])) {
                            bNeedShowAll = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (bNeedShowAll) {
            this.fShowAllDescription = SWTFactory.createLabel(btnContainer, "", 3);
            this.updateDescription();
            this.fShowAllButton = SWTFactory.createCheckButton(btnContainer, StringSubstitutionMessages.StringVariableSelectionDialog_9, null, this.fShowAllSelected, 1);
            this.fShowAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StringVariableSelectionDialog.this.fShowAllSelected = StringVariableSelectionDialog.this.fShowAllButton.getSelection();
                    StringVariableSelectionDialog.this.updateDescription();
                    StringVariableSelectionDialog.this.updateElements();
                }
            });
            SWTFactory.createHorizontalSpacer(btnContainer, 1);
        } else {
            SWTFactory.createHorizontalSpacer(btnContainer, 2);
        }
        Button editButton = SWTFactory.createPushButton(btnContainer, StringSubstitutionMessages.StringVariableSelectionDialog_0, null, 128);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog.this.editVariables();
            }
        });
        SWTFactory.createWrapLabel(container, StringSubstitutionMessages.StringVariableSelectionDialog_6, 2);
        Composite args = SWTFactory.createComposite(container, container.getFont(), 2, 2, 768, 0, 0);
        this.fArgumentText = new Text(args, 2048);
        this.fArgumentText.setFont(container.getFont());
        this.fArgumentText.setLayoutData((Object)new GridData(768));
        this.fArgumentButton = SWTFactory.createPushButton(args, StringSubstitutionMessages.StringVariableSelectionDialog_7, null);
        this.fArgumentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog.this.configureArgument();
            }
        });
        SWTFactory.createWrapLabel(container, StringSubstitutionMessages.StringVariableSelectionDialog_8, 2);
        this.fDescriptionText = new Text(container, 2624);
        this.fDescriptionText.setFont(container.getFont());
        this.fDescriptionText.setEditable(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 50;
        this.fDescriptionText.setLayoutData((Object)gd);
    }

    protected void editVariables() {
        Display display = DebugUIPlugin.getStandardDisplay();
        BusyIndicator.showWhile((Display)display, () -> {
            if (this.showVariablesPage()) {
                IStringVariable[] elements = VariablesPlugin.getDefault().getStringVariableManager().getVariables();
                display.asyncExec(() -> this.setListElements(elements));
            }
        });
    }

    private boolean showVariablesPage() {
        StringVariablePreferencePage page = new StringVariablePreferencePage();
        page.setTitle(StringSubstitutionMessages.StringVariableSelectionDialog_1);
        PreferenceNode targetNode = new PreferenceNode("org.eclipse.debug.ui.StringVariablePreferencePage", (IPreferencePage)page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        PreferenceDialog dialog = new PreferenceDialog(DebugUIPlugin.getShell(), manager);
        boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), () -> StringVariableSelectionDialog.lambda$4(dialog, (IPreferenceNode)targetNode, result));
        return result[0];
    }

    protected void configureArgument() {
        Object[] objects = this.getSelectedElements();
        IStringVariable variable = (IStringVariable)objects[0];
        IArgumentSelector selector = StringVariablePresentationManager.getDefault().getArgumentSelector(variable);
        String value = selector.selectArgument(variable, this.getShell());
        if (value != null) {
            this.fArgumentText.setText(value);
        }
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        Object[] objects = this.getSelectedElements();
        boolean buttonEnabled = false;
        boolean argEnabled = false;
        String text = null;
        if (objects.length == 1) {
            IStringVariable variable = (IStringVariable)objects[0];
            IArgumentSelector selector = StringVariablePresentationManager.getDefault().getArgumentSelector(variable);
            if (variable instanceof IDynamicVariable) {
                argEnabled = ((IDynamicVariable)variable).supportsArgument();
            }
            buttonEnabled = argEnabled && selector != null;
            text = variable.getDescription();
        }
        if (text == null) {
            text = "";
        }
        this.fArgumentText.setEnabled(argEnabled);
        this.fArgumentButton.setEnabled(buttonEnabled);
        this.fDescriptionText.setText(text);
    }

    protected void okPressed() {
        this.fArgumentValue = this.fArgumentText.getText().trim();
        super.okPressed();
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.STRING_VARIABLE_SELECTION_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    private static /* synthetic */ void lambda$4(PreferenceDialog preferenceDialog, IPreferenceNode iPreferenceNode, boolean[] blArray) {
        preferenceDialog.create();
        preferenceDialog.setMessage(iPreferenceNode.getLabelText());
        blArray[0] = preferenceDialog.open() == 0;
    }

    public static class VariableFilter {
        public boolean isFiltered(IDynamicVariable var) {
            return false;
        }
    }
}

