/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.n4js.external.ExternalLibraryHelper;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.IExternalPackageManager;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;

@Singleton
public class FileBasedExternalPackageManager
implements IExternalPackageManager {
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;
    @Inject
    private ExternalLibraryHelper externalLibraryHelper;

    @Override
    public boolean isN4ProjectRoot(FileURI rootLocation) {
        if (rootLocation != null && rootLocation.exists()) {
            return this.externalLibraryHelper.isExternalProjectDirectory(rootLocation);
        }
        return false;
    }

    @Override
    public ProjectDescription loadProjectDescriptionFromProjectRoot(FileURI rootLocation) {
        if (rootLocation != null && rootLocation.isDirectory()) {
            return this.projectDescriptionLoader.loadProjectDescriptionAtLocation(rootLocation);
        }
        return null;
    }
}

