/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.n4js.external.ExternalLibraryHelper;
import org.eclipse.n4js.generator.headless.BuildSet;
import org.eclipse.n4js.generator.headless.N4JSCompileException;
import org.eclipse.n4js.generator.headless.logging.IHeadlessLogger;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.N4JSBrokenProjectException;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;

public class HeadlessHelper {
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private IHeadlessLogger logger;
    @Inject
    private ExternalLibraryHelper externalLibraryHelper;

    public void registerProjects(BuildSet buildSet, FileBasedWorkspace workspace) throws N4JSCompileException {
        ArrayList<FileURI> projectUris = new ArrayList<FileURI>();
        for (IN4JSProject project : buildSet.getAllProjects()) {
            SafeURI location = project.getLocation();
            if (location instanceof FileURI) {
                projectUris.add((FileURI)location);
                continue;
            }
            throw new IllegalArgumentException("Unexpected project " + project.getProjectName() + " at " + location);
        }
        this.registerProjectsToFileBasedWorkspace(projectUris, workspace);
    }

    public void registerProjectsToFileBasedWorkspace(Iterable<FileURI> projectURIs, FileBasedWorkspace workspace) throws N4JSCompileException {
        HashMap<String, FileURI> registeredProjects = new HashMap<String, FileURI>();
        workspace.getAllProjectLocationsIterator().forEachRemaining(uri -> {
            String projectName = workspace.getProjectDescription(uri).getProjectName();
            registeredProjects.put(projectName, (FileURI)uri);
        });
        for (FileURI projectURI : projectURIs) {
            ProjectDescription projectDescription = this.projectDescriptionLoader.loadProjectDescriptionAtLocation((SafeURI)projectURI);
            if (projectDescription == null) {
                throw new N4JSCompileException("Cannot load project description for project at " + projectURI + ". Make sure the project contains a valid package.json file.");
            }
            String projectName = projectDescription.getProjectName();
            if (this.skipRegistering(projectName, projectURI, registeredProjects)) {
                if (this.logger == null || !this.logger.isCreateDebugOutput()) continue;
                this.logger.debug("Skipping already registered project '" + projectURI + "'");
                continue;
            }
            try {
                if (this.logger != null && this.logger.isCreateDebugOutput()) {
                    this.logger.debug("Registering project '" + projectURI + "'");
                }
                workspace.registerProject(projectURI);
                registeredProjects.put(projectName, projectURI);
            }
            catch (N4JSBrokenProjectException e) {
                throw new N4JSCompileException("Unable to register project '" + projectURI + "'", e);
            }
        }
    }

    public List<File> toAbsoluteFileList(List<File> relativeFiles) throws N4JSCompileException {
        ArrayList<File> absProjectRoots = new ArrayList<File>(relativeFiles.size());
        for (File relPR : relativeFiles) {
            try {
                absProjectRoots.add(relPR.getCanonicalFile());
            }
            catch (IOException e) {
                throw new N4JSCompileException("Unable to create canonical filename of file '" + relPR + "'", e);
            }
        }
        return absProjectRoots;
    }

    public List<File> findProjectsForSingleFiles(List<File> sourceFiles, FileBasedWorkspace workspace) throws N4JSCompileException {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (File sourceFile : sourceFiles) {
            FileURI projectURI = workspace.findProjectWith(new FileURI(sourceFile));
            if (projectURI == null) {
                throw new N4JSCompileException("No project for file '" + sourceFile.toString() + "' found.");
            }
            result.add(projectURI);
        }
        return result.stream().map(u -> new File(u.toFileString())).collect(Collectors.toList());
    }

    public List<File> collectAllProjectPaths(List<File> absProjectRoots) {
        List<File> projectRoots = this.getProjectStream(absProjectRoots).collect(Collectors.toList());
        return projectRoots;
    }

    public List<IN4JSProject> getN4JSProjects(List<FileURI> projectURIs) {
        return projectURIs.stream().map(u -> this.n4jsCore.create(u.toURI())).filter(p -> this.isProjectToBeBuilt((IN4JSProject)p)).collect(Collectors.toList());
    }

    public boolean isProjectToBeBuilt(IN4JSProject project) {
        if (project == null) {
            return false;
        }
        if (project.isExternal()) {
            return this.externalLibraryHelper.isExternalProjectDirectory(project.getLocation());
        }
        return true;
    }

    public List<FileURI> createFileURIs(List<File> files) {
        return files.stream().map(FileURI::new).collect(Collectors.toList());
    }

    private boolean skipRegistering(String projectName, FileURI projectLocation, Map<String, FileURI> registeredProjects) throws N4JSCompileException {
        if (!registeredProjects.containsKey(projectName)) {
            return false;
        }
        FileURI registeredProjectLocation = registeredProjects.get(projectName);
        if (projectLocation.equals((Object)registeredProjectLocation)) {
            return true;
        }
        if (registeredProjectLocation == null) {
            throw new N4JSCompileException("Duplicate project id [" + projectName + "]. Already registered project at " + registeredProjects.get(projectName) + ", trying to register project at " + projectLocation + ".");
        }
        throw new N4JSCompileException("Duplicate project id [" + projectName + "]. Already registered project at " + registeredProjectLocation + ", trying to register project at " + projectLocation + ".");
    }

    private Stream<File> getProjectStream(List<File> absProjectRoots) {
        Stream<File> scopeFolders = absProjectRoots.stream().filter(File::isDirectory).flatMap(root -> Arrays.asList(root.listFiles(File::isDirectory)).stream()).filter(f -> f.getName().startsWith("@"));
        return Stream.concat(scopeFolders, absProjectRoots.stream()).filter(File::isDirectory).flatMap(root -> Arrays.asList(root.listFiles(File::isDirectory)).stream().sorted()).filter(dir -> new File((File)dir, "package.json").isFile());
    }
}

